/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityContentModel;
import fpml.consolidated.com.CommodityLeg;
import fpml.consolidated.com.WeatherLeg;
import fpml.consolidated.com.meta.CommoditySwapDetailsModelMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.IdentifiedCurrency;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommoditySwapDetailsModel", builder=CommoditySwapDetailsModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommoditySwapDetailsModel", model="fpml", builder=CommoditySwapDetailsModelBuilderImpl.class, version="1.2.2")
public interface CommoditySwapDetailsModel
extends RosettaModelObject {
    public static final CommoditySwapDetailsModelMeta metaData = new CommoditySwapDetailsModelMeta();

    public AdjustableOrRelativeDate getEffectiveDate();

    public AdjustableOrRelativeDate getTerminationDate();

    public IdentifiedCurrency getSettlementCurrency();

    public List<? extends CommodityLeg> getCommoditySwapLeg();

    public List<? extends WeatherLeg> getWeatherLeg();

    public CommodityContentModel getCommodityContentModel();

    public CommoditySwapDetailsModel build();

    public CommoditySwapDetailsModelBuilder toBuilder();

    public static CommoditySwapDetailsModelBuilder builder() {
        return new CommoditySwapDetailsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends CommoditySwapDetailsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommoditySwapDetailsModel> getType() {
        return CommoditySwapDetailsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commoditySwapLeg"), processor, CommodityLeg.class, this.getCommoditySwapLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("weatherLeg"), processor, WeatherLeg.class, this.getWeatherLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.class, this.getCommodityContentModel(), new AttributeMeta[0]);
    }

    public static class CommoditySwapDetailsModelBuilderImpl
    implements CommoditySwapDetailsModelBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder terminationDate;
        protected IdentifiedCurrency.IdentifiedCurrencyBuilder settlementCurrency;
        protected List<CommodityLeg.CommodityLegBuilder> commoditySwapLeg = new ArrayList<CommodityLeg.CommodityLegBuilder>();
        protected List<WeatherLeg.WeatherLegBuilder> weatherLeg = new ArrayList<WeatherLeg.WeatherLegBuilder>();
        protected CommodityContentModel.CommodityContentModelBuilder commodityContentModel;

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminationDate", isRequired=true)
        @RuneAttribute(value="terminationDate", isRequired=true)
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.terminationDate != null ? this.terminationDate : (this.terminationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency() {
            IdentifiedCurrency.IdentifiedCurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = IdentifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commoditySwapLeg")
        @RuneAttribute(value="commoditySwapLeg")
        public List<? extends CommodityLeg.CommodityLegBuilder> getCommoditySwapLeg() {
            return this.commoditySwapLeg;
        }

        @Override
        public CommodityLeg.CommodityLegBuilder getOrCreateCommoditySwapLeg(int index) {
            if (this.commoditySwapLeg == null) {
                this.commoditySwapLeg = new ArrayList<CommodityLeg.CommodityLegBuilder>();
            }
            return (CommodityLeg.CommodityLegBuilder)this.getIndex(this.commoditySwapLeg, index, () -> {
                CommodityLeg.CommodityLegBuilder newCommoditySwapLeg = CommodityLeg.builder();
                return newCommoditySwapLeg;
            });
        }

        @Override
        @RosettaAttribute(value="weatherLeg")
        @RuneAttribute(value="weatherLeg")
        public List<? extends WeatherLeg.WeatherLegBuilder> getWeatherLeg() {
            return this.weatherLeg;
        }

        @Override
        public WeatherLeg.WeatherLegBuilder getOrCreateWeatherLeg(int index) {
            if (this.weatherLeg == null) {
                this.weatherLeg = new ArrayList<WeatherLeg.WeatherLegBuilder>();
            }
            return (WeatherLeg.WeatherLegBuilder)this.getIndex(this.weatherLeg, index, () -> {
                WeatherLeg.WeatherLegBuilder newWeatherLeg = WeatherLeg.builder();
                return newWeatherLeg;
            });
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel() {
            CommodityContentModel.CommodityContentModelBuilder result = this.commodityContentModel != null ? this.commodityContentModel : (this.commodityContentModel = CommodityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public CommoditySwapDetailsModelBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate", isRequired=true)
        @RuneAttribute(value="terminationDate", isRequired=true)
        public CommoditySwapDetailsModelBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public CommoditySwapDetailsModelBuilder setSettlementCurrency(IdentifiedCurrency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commoditySwapLeg")
        @RuneAttribute(value="commoditySwapLeg")
        public CommoditySwapDetailsModelBuilder addCommoditySwapLeg(CommodityLeg _commoditySwapLeg) {
            if (_commoditySwapLeg != null) {
                this.commoditySwapLeg.add(_commoditySwapLeg.toBuilder());
            }
            return this;
        }

        @Override
        public CommoditySwapDetailsModelBuilder addCommoditySwapLeg(CommodityLeg _commoditySwapLeg, int idx) {
            this.getIndex(this.commoditySwapLeg, idx, () -> _commoditySwapLeg.toBuilder());
            return this;
        }

        @Override
        public CommoditySwapDetailsModelBuilder addCommoditySwapLeg(List<? extends CommodityLeg> commoditySwapLegs) {
            if (commoditySwapLegs != null) {
                for (CommodityLeg commodityLeg : commoditySwapLegs) {
                    this.commoditySwapLeg.add(commodityLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commoditySwapLeg")
        public CommoditySwapDetailsModelBuilder setCommoditySwapLeg(List<? extends CommodityLeg> commoditySwapLegs) {
            this.commoditySwapLeg = commoditySwapLegs == null ? new ArrayList<CommodityLeg.CommodityLegBuilder>() : (List)commoditySwapLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="weatherLeg")
        @RuneAttribute(value="weatherLeg")
        public CommoditySwapDetailsModelBuilder addWeatherLeg(WeatherLeg _weatherLeg) {
            if (_weatherLeg != null) {
                this.weatherLeg.add(_weatherLeg.toBuilder());
            }
            return this;
        }

        @Override
        public CommoditySwapDetailsModelBuilder addWeatherLeg(WeatherLeg _weatherLeg, int idx) {
            this.getIndex(this.weatherLeg, idx, () -> _weatherLeg.toBuilder());
            return this;
        }

        @Override
        public CommoditySwapDetailsModelBuilder addWeatherLeg(List<? extends WeatherLeg> weatherLegs) {
            if (weatherLegs != null) {
                for (WeatherLeg weatherLeg : weatherLegs) {
                    this.weatherLeg.add(weatherLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="weatherLeg")
        public CommoditySwapDetailsModelBuilder setWeatherLeg(List<? extends WeatherLeg> weatherLegs) {
            this.weatherLeg = weatherLegs == null ? new ArrayList<WeatherLeg.WeatherLegBuilder>() : (List)weatherLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommoditySwapDetailsModelBuilder setCommodityContentModel(CommodityContentModel _commodityContentModel) {
            this.commodityContentModel = _commodityContentModel == null ? null : _commodityContentModel.toBuilder();
            return this;
        }

        @Override
        public CommoditySwapDetailsModel build() {
            return new CommoditySwapDetailsModelImpl(this);
        }

        @Override
        public CommoditySwapDetailsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public CommoditySwapDetailsModelBuilder prune() {
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.terminationDate != null && !this.terminationDate.prune().hasData()) {
                this.terminationDate = null;
            }
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            this.commoditySwapLeg = this.commoditySwapLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.weatherLeg = this.weatherLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityContentModel != null && !this.commodityContentModel.prune().hasData()) {
                this.commodityContentModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getTerminationDate() != null && this.getTerminationDate().hasData()) {
                return true;
            }
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getCommoditySwapLeg() != null && this.getCommoditySwapLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getWeatherLeg() != null && this.getWeatherLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCommodityContentModel() != null && this.getCommodityContentModel().hasData();
        }

        public CommoditySwapDetailsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommoditySwapDetailsModelBuilder o = (CommoditySwapDetailsModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationDate(), (RosettaModelObjectBuilder)o.getTerminationDate(), this::setTerminationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta(this.getCommoditySwapLeg(), o.getCommoditySwapLeg(), this::getOrCreateCommoditySwapLeg);
            merger.mergeRosetta(this.getWeatherLeg(), o.getWeatherLeg(), this::getOrCreateWeatherLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityContentModel(), (RosettaModelObjectBuilder)o.getCommodityContentModel(), this::setCommodityContentModel);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommoditySwapDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commoditySwapLeg, _that.getCommoditySwapLeg())) {
                return false;
            }
            if (!ListEquals.listEquals(this.weatherLeg, _that.getWeatherLeg())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.commoditySwapLeg != null ? this.commoditySwapLeg.hashCode() : 0);
            _result = 31 * _result + (this.weatherLeg != null ? this.weatherLeg.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommoditySwapDetailsModelBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", terminationDate=" + String.valueOf(this.terminationDate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", commoditySwapLeg=" + String.valueOf(this.commoditySwapLeg) + ", weatherLeg=" + String.valueOf(this.weatherLeg) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "}";
        }
    }

    public static interface CommoditySwapDetailsModelBuilder
    extends CommoditySwapDetailsModel,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate();

        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getSettlementCurrency();

        public CommodityLeg.CommodityLegBuilder getOrCreateCommoditySwapLeg(int var1);

        public List<? extends CommodityLeg.CommodityLegBuilder> getCommoditySwapLeg();

        public WeatherLeg.WeatherLegBuilder getOrCreateWeatherLeg(int var1);

        public List<? extends WeatherLeg.WeatherLegBuilder> getWeatherLeg();

        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel();

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel();

        public CommoditySwapDetailsModelBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public CommoditySwapDetailsModelBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        public CommoditySwapDetailsModelBuilder setSettlementCurrency(IdentifiedCurrency var1);

        public CommoditySwapDetailsModelBuilder addCommoditySwapLeg(CommodityLeg var1);

        public CommoditySwapDetailsModelBuilder addCommoditySwapLeg(CommodityLeg var1, int var2);

        public CommoditySwapDetailsModelBuilder addCommoditySwapLeg(List<? extends CommodityLeg> var1);

        public CommoditySwapDetailsModelBuilder setCommoditySwapLeg(List<? extends CommodityLeg> var1);

        public CommoditySwapDetailsModelBuilder addWeatherLeg(WeatherLeg var1);

        public CommoditySwapDetailsModelBuilder addWeatherLeg(WeatherLeg var1, int var2);

        public CommoditySwapDetailsModelBuilder addWeatherLeg(List<? extends WeatherLeg> var1);

        public CommoditySwapDetailsModelBuilder setWeatherLeg(List<? extends WeatherLeg> var1);

        public CommoditySwapDetailsModelBuilder setCommodityContentModel(CommodityContentModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commoditySwapLeg"), processor, CommodityLeg.CommodityLegBuilder.class, this.getCommoditySwapLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("weatherLeg"), processor, WeatherLeg.WeatherLegBuilder.class, this.getWeatherLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.CommodityContentModelBuilder.class, this.getCommodityContentModel(), new AttributeMeta[0]);
        }

        public CommoditySwapDetailsModelBuilder prune();
    }

    public static class CommoditySwapDetailsModelImpl
    implements CommoditySwapDetailsModel {
        private final AdjustableOrRelativeDate effectiveDate;
        private final AdjustableOrRelativeDate terminationDate;
        private final IdentifiedCurrency settlementCurrency;
        private final List<? extends CommodityLeg> commoditySwapLeg;
        private final List<? extends WeatherLeg> weatherLeg;
        private final CommodityContentModel commodityContentModel;

        protected CommoditySwapDetailsModelImpl(CommoditySwapDetailsModelBuilder builder) {
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.terminationDate = Optional.ofNullable(builder.getTerminationDate()).map(f -> f.build()).orElse(null);
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.commoditySwapLeg = Optional.ofNullable(builder.getCommoditySwapLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.weatherLeg = Optional.ofNullable(builder.getWeatherLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityContentModel = Optional.ofNullable(builder.getCommodityContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="terminationDate", isRequired=true)
        @RuneAttribute(value="terminationDate", isRequired=true)
        public AdjustableOrRelativeDate getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public IdentifiedCurrency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="commoditySwapLeg")
        @RuneAttribute(value="commoditySwapLeg")
        public List<? extends CommodityLeg> getCommoditySwapLeg() {
            return this.commoditySwapLeg;
        }

        @Override
        @RosettaAttribute(value="weatherLeg")
        @RuneAttribute(value="weatherLeg")
        public List<? extends WeatherLeg> getWeatherLeg() {
            return this.weatherLeg;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommoditySwapDetailsModel build() {
            return this;
        }

        @Override
        public CommoditySwapDetailsModelBuilder toBuilder() {
            CommoditySwapDetailsModelBuilder builder = CommoditySwapDetailsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommoditySwapDetailsModelBuilder builder) {
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getTerminationDate()).ifPresent(builder::setTerminationDate);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getCommoditySwapLeg()).ifPresent(builder::setCommoditySwapLeg);
            Optional.ofNullable(this.getWeatherLeg()).ifPresent(builder::setWeatherLeg);
            Optional.ofNullable(this.getCommodityContentModel()).ifPresent(builder::setCommodityContentModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommoditySwapDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commoditySwapLeg, _that.getCommoditySwapLeg())) {
                return false;
            }
            if (!ListEquals.listEquals(this.weatherLeg, _that.getWeatherLeg())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.commoditySwapLeg != null ? this.commoditySwapLeg.hashCode() : 0);
            _result = 31 * _result + (this.weatherLeg != null ? this.weatherLeg.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommoditySwapDetailsModel {effectiveDate=" + String.valueOf(this.effectiveDate) + ", terminationDate=" + String.valueOf(this.terminationDate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", commoditySwapLeg=" + String.valueOf(this.commoditySwapLeg) + ", weatherLeg=" + String.valueOf(this.weatherLeg) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "}";
        }
    }
}

