/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.ChangeEvent;
import fpml.consolidated.business.events.meta.IndexChangeMeta;
import fpml.consolidated.shared.Money;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IndexChange", builder=IndexChangeBuilderImpl.class, version="1.2.2")
@RuneDataType(value="IndexChange", model="fpml", builder=IndexChangeBuilderImpl.class, version="1.2.2")
public interface IndexChange
extends ChangeEvent {
    public static final IndexChangeMeta metaData = new IndexChangeMeta();

    public BigDecimal getIndexFactor();

    public Money getFactoredCalculationAmount();

    @Override
    public IndexChange build();

    @Override
    public IndexChangeBuilder toBuilder();

    public static IndexChangeBuilder builder() {
        return new IndexChangeBuilderImpl();
    }

    default public RosettaMetaData<? extends IndexChange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IndexChange> getType() {
        return IndexChange.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("factoredCalculationAmount"), processor, Money.class, this.getFactoredCalculationAmount(), new AttributeMeta[0]);
    }

    public static class IndexChangeBuilderImpl
    extends ChangeEvent.ChangeEventBuilderImpl
    implements IndexChangeBuilder {
        protected BigDecimal indexFactor;
        protected Money.MoneyBuilder factoredCalculationAmount;

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="factoredCalculationAmount")
        @RuneAttribute(value="factoredCalculationAmount")
        public Money.MoneyBuilder getFactoredCalculationAmount() {
            return this.factoredCalculationAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateFactoredCalculationAmount() {
            Money.MoneyBuilder result = this.factoredCalculationAmount != null ? this.factoredCalculationAmount : (this.factoredCalculationAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public IndexChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public IndexChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public IndexChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public IndexChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public IndexChangeBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="factoredCalculationAmount")
        @RuneAttribute(value="factoredCalculationAmount")
        public IndexChangeBuilder setFactoredCalculationAmount(Money _factoredCalculationAmount) {
            this.factoredCalculationAmount = _factoredCalculationAmount == null ? null : _factoredCalculationAmount.toBuilder();
            return this;
        }

        @Override
        public IndexChange build() {
            return new IndexChangeImpl(this);
        }

        @Override
        public IndexChangeBuilder toBuilder() {
            return this;
        }

        @Override
        public IndexChangeBuilder prune() {
            super.prune();
            if (this.factoredCalculationAmount != null && !this.factoredCalculationAmount.prune().hasData()) {
                this.factoredCalculationAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getIndexFactor() != null) {
                return true;
            }
            return this.getFactoredCalculationAmount() != null && this.getFactoredCalculationAmount().hasData();
        }

        @Override
        public IndexChangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            IndexChangeBuilder o = (IndexChangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFactoredCalculationAmount(), (RosettaModelObjectBuilder)o.getFactoredCalculationAmount(), this::setFactoredCalculationAmount);
            merger.mergeBasic((Object)this.getIndexFactor(), (Object)o.getIndexFactor(), this::setIndexFactor, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IndexChange _that = (IndexChange)this.getType().cast(o);
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            return Objects.equals(this.factoredCalculationAmount, _that.getFactoredCalculationAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.factoredCalculationAmount != null ? this.factoredCalculationAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IndexChangeBuilder {indexFactor=" + String.valueOf(this.indexFactor) + ", factoredCalculationAmount=" + String.valueOf(this.factoredCalculationAmount) + "} " + super.toString();
        }
    }

    public static interface IndexChangeBuilder
    extends IndexChange,
    ChangeEvent.ChangeEventBuilder {
        public Money.MoneyBuilder getOrCreateFactoredCalculationAmount();

        @Override
        public Money.MoneyBuilder getFactoredCalculationAmount();

        @Override
        public IndexChangeBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public IndexChangeBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public IndexChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public IndexChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public IndexChangeBuilder setIndexFactor(BigDecimal var1);

        public IndexChangeBuilder setFactoredCalculationAmount(Money var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("factoredCalculationAmount"), processor, Money.MoneyBuilder.class, this.getFactoredCalculationAmount(), new AttributeMeta[0]);
        }

        @Override
        public IndexChangeBuilder prune();
    }

    public static class IndexChangeImpl
    extends ChangeEvent.ChangeEventImpl
    implements IndexChange {
        private final BigDecimal indexFactor;
        private final Money factoredCalculationAmount;

        protected IndexChangeImpl(IndexChangeBuilder builder) {
            super(builder);
            this.indexFactor = builder.getIndexFactor();
            this.factoredCalculationAmount = Optional.ofNullable(builder.getFactoredCalculationAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="factoredCalculationAmount")
        @RuneAttribute(value="factoredCalculationAmount")
        public Money getFactoredCalculationAmount() {
            return this.factoredCalculationAmount;
        }

        @Override
        public IndexChange build() {
            return this;
        }

        @Override
        public IndexChangeBuilder toBuilder() {
            IndexChangeBuilder builder = IndexChange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IndexChangeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getIndexFactor()).ifPresent(builder::setIndexFactor);
            Optional.ofNullable(this.getFactoredCalculationAmount()).ifPresent(builder::setFactoredCalculationAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IndexChange _that = (IndexChange)this.getType().cast(o);
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            return Objects.equals(this.factoredCalculationAmount, _that.getFactoredCalculationAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.factoredCalculationAmount != null ? this.factoredCalculationAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IndexChange {indexFactor=" + String.valueOf(this.indexFactor) + ", factoredCalculationAmount=" + String.valueOf(this.factoredCalculationAmount) + "} " + super.toString();
        }
    }
}

