/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.asset.DividendPayout;
import fpml.consolidated.asset.PendingPayment;
import fpml.consolidated.asset.meta.SingleUnderlyerMeta;
import fpml.consolidated.shared.AverageDailyTradingVolumeLimit;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SingleUnderlyer", builder=SingleUnderlyerBuilderImpl.class, version="1.2.2")
@RuneDataType(value="SingleUnderlyer", model="fpml", builder=SingleUnderlyerBuilderImpl.class, version="1.2.2")
public interface SingleUnderlyer
extends RosettaModelObject {
    public static final SingleUnderlyerMeta metaData = new SingleUnderlyerMeta();

    public Asset getUnderlyingAsset();

    public BigDecimal getOpenUnits();

    public DividendPayout getDividendPayout();

    public PendingPayment getCouponPayment();

    public AverageDailyTradingVolumeLimit getAverageDailyTradingVolume();

    public Boolean getDepositoryReceipt();

    public SingleUnderlyer build();

    public SingleUnderlyerBuilder toBuilder();

    public static SingleUnderlyerBuilder builder() {
        return new SingleUnderlyerBuilderImpl();
    }

    default public RosettaMetaData<? extends SingleUnderlyer> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SingleUnderlyer> getType() {
        return SingleUnderlyer.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("openUnits"), BigDecimal.class, (Object)this.getOpenUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendPayout"), processor, DividendPayout.class, this.getDividendPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("couponPayment"), processor, PendingPayment.class, this.getCouponPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averageDailyTradingVolume"), processor, AverageDailyTradingVolumeLimit.class, this.getAverageDailyTradingVolume(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("depositoryReceipt"), Boolean.class, (Object)this.getDepositoryReceipt(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SingleUnderlyerBuilderImpl
    implements SingleUnderlyerBuilder {
        protected Asset.AssetBuilder underlyingAsset;
        protected BigDecimal openUnits;
        protected DividendPayout.DividendPayoutBuilder dividendPayout;
        protected PendingPayment.PendingPaymentBuilder couponPayment;
        protected AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder averageDailyTradingVolume;
        protected Boolean depositoryReceipt;

        @Override
        @RosettaAttribute(value="underlyingAsset", isRequired=true)
        @RuneAttribute(value="underlyingAsset", isRequired=true)
        public Asset.AssetBuilder getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlyingAsset() {
            Asset.AssetBuilder result = this.underlyingAsset != null ? this.underlyingAsset : (this.underlyingAsset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BigDecimal getOpenUnits() {
            return this.openUnits;
        }

        @Override
        @RosettaAttribute(value="dividendPayout")
        @RuneAttribute(value="dividendPayout")
        public DividendPayout.DividendPayoutBuilder getDividendPayout() {
            return this.dividendPayout;
        }

        @Override
        public DividendPayout.DividendPayoutBuilder getOrCreateDividendPayout() {
            DividendPayout.DividendPayoutBuilder result = this.dividendPayout != null ? this.dividendPayout : (this.dividendPayout = DividendPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="couponPayment")
        @RuneAttribute(value="couponPayment")
        public PendingPayment.PendingPaymentBuilder getCouponPayment() {
            return this.couponPayment;
        }

        @Override
        public PendingPayment.PendingPaymentBuilder getOrCreateCouponPayment() {
            PendingPayment.PendingPaymentBuilder result = this.couponPayment != null ? this.couponPayment : (this.couponPayment = PendingPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averageDailyTradingVolume")
        @RuneAttribute(value="averageDailyTradingVolume")
        public AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder getAverageDailyTradingVolume() {
            return this.averageDailyTradingVolume;
        }

        @Override
        public AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder getOrCreateAverageDailyTradingVolume() {
            AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder result = this.averageDailyTradingVolume != null ? this.averageDailyTradingVolume : (this.averageDailyTradingVolume = AverageDailyTradingVolumeLimit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="depositoryReceipt")
        @RuneAttribute(value="depositoryReceipt")
        public Boolean getDepositoryReceipt() {
            return this.depositoryReceipt;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset", isRequired=true)
        @RuneAttribute(value="underlyingAsset", isRequired=true)
        public SingleUnderlyerBuilder setUnderlyingAsset(Asset _underlyingAsset) {
            this.underlyingAsset = _underlyingAsset == null ? null : _underlyingAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public SingleUnderlyerBuilder setOpenUnits(BigDecimal _openUnits) {
            this.openUnits = _openUnits == null ? null : _openUnits;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendPayout")
        @RuneAttribute(value="dividendPayout")
        public SingleUnderlyerBuilder setDividendPayout(DividendPayout _dividendPayout) {
            this.dividendPayout = _dividendPayout == null ? null : _dividendPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="couponPayment")
        @RuneAttribute(value="couponPayment")
        public SingleUnderlyerBuilder setCouponPayment(PendingPayment _couponPayment) {
            this.couponPayment = _couponPayment == null ? null : _couponPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averageDailyTradingVolume")
        @RuneAttribute(value="averageDailyTradingVolume")
        public SingleUnderlyerBuilder setAverageDailyTradingVolume(AverageDailyTradingVolumeLimit _averageDailyTradingVolume) {
            this.averageDailyTradingVolume = _averageDailyTradingVolume == null ? null : _averageDailyTradingVolume.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="depositoryReceipt")
        @RuneAttribute(value="depositoryReceipt")
        public SingleUnderlyerBuilder setDepositoryReceipt(Boolean _depositoryReceipt) {
            this.depositoryReceipt = _depositoryReceipt == null ? null : _depositoryReceipt;
            return this;
        }

        @Override
        public SingleUnderlyer build() {
            return new SingleUnderlyerImpl(this);
        }

        @Override
        public SingleUnderlyerBuilder toBuilder() {
            return this;
        }

        @Override
        public SingleUnderlyerBuilder prune() {
            if (this.underlyingAsset != null && !this.underlyingAsset.prune().hasData()) {
                this.underlyingAsset = null;
            }
            if (this.dividendPayout != null && !this.dividendPayout.prune().hasData()) {
                this.dividendPayout = null;
            }
            if (this.couponPayment != null && !this.couponPayment.prune().hasData()) {
                this.couponPayment = null;
            }
            if (this.averageDailyTradingVolume != null && !this.averageDailyTradingVolume.prune().hasData()) {
                this.averageDailyTradingVolume = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnderlyingAsset() != null && this.getUnderlyingAsset().hasData()) {
                return true;
            }
            if (this.getOpenUnits() != null) {
                return true;
            }
            if (this.getDividendPayout() != null && this.getDividendPayout().hasData()) {
                return true;
            }
            if (this.getCouponPayment() != null && this.getCouponPayment().hasData()) {
                return true;
            }
            if (this.getAverageDailyTradingVolume() != null && this.getAverageDailyTradingVolume().hasData()) {
                return true;
            }
            return this.getDepositoryReceipt() != null;
        }

        public SingleUnderlyerBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SingleUnderlyerBuilder o = (SingleUnderlyerBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAsset(), (RosettaModelObjectBuilder)o.getUnderlyingAsset(), this::setUnderlyingAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendPayout(), (RosettaModelObjectBuilder)o.getDividendPayout(), this::setDividendPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCouponPayment(), (RosettaModelObjectBuilder)o.getCouponPayment(), this::setCouponPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAverageDailyTradingVolume(), (RosettaModelObjectBuilder)o.getAverageDailyTradingVolume(), this::setAverageDailyTradingVolume);
            merger.mergeBasic((Object)this.getOpenUnits(), (Object)o.getOpenUnits(), this::setOpenUnits, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDepositoryReceipt(), (Object)o.getDepositoryReceipt(), this::setDepositoryReceipt, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SingleUnderlyer _that = this.getType().cast(o);
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.openUnits, _that.getOpenUnits())) {
                return false;
            }
            if (!Objects.equals(this.dividendPayout, _that.getDividendPayout())) {
                return false;
            }
            if (!Objects.equals(this.couponPayment, _that.getCouponPayment())) {
                return false;
            }
            if (!Objects.equals(this.averageDailyTradingVolume, _that.getAverageDailyTradingVolume())) {
                return false;
            }
            return Objects.equals(this.depositoryReceipt, _that.getDepositoryReceipt());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.openUnits != null ? this.openUnits.hashCode() : 0);
            _result = 31 * _result + (this.dividendPayout != null ? this.dividendPayout.hashCode() : 0);
            _result = 31 * _result + (this.couponPayment != null ? this.couponPayment.hashCode() : 0);
            _result = 31 * _result + (this.averageDailyTradingVolume != null ? this.averageDailyTradingVolume.hashCode() : 0);
            _result = 31 * _result + (this.depositoryReceipt != null ? this.depositoryReceipt.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SingleUnderlyerBuilder {underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", openUnits=" + String.valueOf(this.openUnits) + ", dividendPayout=" + String.valueOf(this.dividendPayout) + ", couponPayment=" + String.valueOf(this.couponPayment) + ", averageDailyTradingVolume=" + String.valueOf(this.averageDailyTradingVolume) + ", depositoryReceipt=" + this.depositoryReceipt + "}";
        }
    }

    public static interface SingleUnderlyerBuilder
    extends SingleUnderlyer,
    RosettaModelObjectBuilder {
        public Asset.AssetBuilder getOrCreateUnderlyingAsset();

        @Override
        public Asset.AssetBuilder getUnderlyingAsset();

        public DividendPayout.DividendPayoutBuilder getOrCreateDividendPayout();

        @Override
        public DividendPayout.DividendPayoutBuilder getDividendPayout();

        public PendingPayment.PendingPaymentBuilder getOrCreateCouponPayment();

        @Override
        public PendingPayment.PendingPaymentBuilder getCouponPayment();

        public AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder getOrCreateAverageDailyTradingVolume();

        @Override
        public AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder getAverageDailyTradingVolume();

        public SingleUnderlyerBuilder setUnderlyingAsset(Asset var1);

        public SingleUnderlyerBuilder setOpenUnits(BigDecimal var1);

        public SingleUnderlyerBuilder setDividendPayout(DividendPayout var1);

        public SingleUnderlyerBuilder setCouponPayment(PendingPayment var1);

        public SingleUnderlyerBuilder setAverageDailyTradingVolume(AverageDailyTradingVolumeLimit var1);

        public SingleUnderlyerBuilder setDepositoryReceipt(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.AssetBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("openUnits"), BigDecimal.class, (Object)this.getOpenUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendPayout"), processor, DividendPayout.DividendPayoutBuilder.class, this.getDividendPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("couponPayment"), processor, PendingPayment.PendingPaymentBuilder.class, this.getCouponPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averageDailyTradingVolume"), processor, AverageDailyTradingVolumeLimit.AverageDailyTradingVolumeLimitBuilder.class, this.getAverageDailyTradingVolume(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("depositoryReceipt"), Boolean.class, (Object)this.getDepositoryReceipt(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SingleUnderlyerBuilder prune();
    }

    public static class SingleUnderlyerImpl
    implements SingleUnderlyer {
        private final Asset underlyingAsset;
        private final BigDecimal openUnits;
        private final DividendPayout dividendPayout;
        private final PendingPayment couponPayment;
        private final AverageDailyTradingVolumeLimit averageDailyTradingVolume;
        private final Boolean depositoryReceipt;

        protected SingleUnderlyerImpl(SingleUnderlyerBuilder builder) {
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).map(f -> f.build()).orElse(null);
            this.openUnits = builder.getOpenUnits();
            this.dividendPayout = Optional.ofNullable(builder.getDividendPayout()).map(f -> f.build()).orElse(null);
            this.couponPayment = Optional.ofNullable(builder.getCouponPayment()).map(f -> f.build()).orElse(null);
            this.averageDailyTradingVolume = Optional.ofNullable(builder.getAverageDailyTradingVolume()).map(f -> f.build()).orElse(null);
            this.depositoryReceipt = builder.getDepositoryReceipt();
        }

        @Override
        @RosettaAttribute(value="underlyingAsset", isRequired=true)
        @RuneAttribute(value="underlyingAsset", isRequired=true)
        public Asset getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BigDecimal getOpenUnits() {
            return this.openUnits;
        }

        @Override
        @RosettaAttribute(value="dividendPayout")
        @RuneAttribute(value="dividendPayout")
        public DividendPayout getDividendPayout() {
            return this.dividendPayout;
        }

        @Override
        @RosettaAttribute(value="couponPayment")
        @RuneAttribute(value="couponPayment")
        public PendingPayment getCouponPayment() {
            return this.couponPayment;
        }

        @Override
        @RosettaAttribute(value="averageDailyTradingVolume")
        @RuneAttribute(value="averageDailyTradingVolume")
        public AverageDailyTradingVolumeLimit getAverageDailyTradingVolume() {
            return this.averageDailyTradingVolume;
        }

        @Override
        @RosettaAttribute(value="depositoryReceipt")
        @RuneAttribute(value="depositoryReceipt")
        public Boolean getDepositoryReceipt() {
            return this.depositoryReceipt;
        }

        @Override
        public SingleUnderlyer build() {
            return this;
        }

        @Override
        public SingleUnderlyerBuilder toBuilder() {
            SingleUnderlyerBuilder builder = SingleUnderlyer.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SingleUnderlyerBuilder builder) {
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
            Optional.ofNullable(this.getOpenUnits()).ifPresent(builder::setOpenUnits);
            Optional.ofNullable(this.getDividendPayout()).ifPresent(builder::setDividendPayout);
            Optional.ofNullable(this.getCouponPayment()).ifPresent(builder::setCouponPayment);
            Optional.ofNullable(this.getAverageDailyTradingVolume()).ifPresent(builder::setAverageDailyTradingVolume);
            Optional.ofNullable(this.getDepositoryReceipt()).ifPresent(builder::setDepositoryReceipt);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SingleUnderlyer _that = this.getType().cast(o);
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.openUnits, _that.getOpenUnits())) {
                return false;
            }
            if (!Objects.equals(this.dividendPayout, _that.getDividendPayout())) {
                return false;
            }
            if (!Objects.equals(this.couponPayment, _that.getCouponPayment())) {
                return false;
            }
            if (!Objects.equals(this.averageDailyTradingVolume, _that.getAverageDailyTradingVolume())) {
                return false;
            }
            return Objects.equals(this.depositoryReceipt, _that.getDepositoryReceipt());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.openUnits != null ? this.openUnits.hashCode() : 0);
            _result = 31 * _result + (this.dividendPayout != null ? this.dividendPayout.hashCode() : 0);
            _result = 31 * _result + (this.couponPayment != null ? this.couponPayment.hashCode() : 0);
            _result = 31 * _result + (this.averageDailyTradingVolume != null ? this.averageDailyTradingVolume.hashCode() : 0);
            _result = 31 * _result + (this.depositoryReceipt != null ? this.depositoryReceipt.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SingleUnderlyer {underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", openUnits=" + String.valueOf(this.openUnits) + ", dividendPayout=" + String.valueOf(this.dividendPayout) + ", couponPayment=" + String.valueOf(this.couponPayment) + ", averageDailyTradingVolume=" + String.valueOf(this.averageDailyTradingVolume) + ", depositoryReceipt=" + this.depositoryReceipt + "}";
        }
    }
}

