/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.AssetMeasureType;
import fpml.consolidated.asset.PriceQuoteUnits;
import fpml.consolidated.asset.PricingModel;
import fpml.consolidated.asset.QuoteLocationModel;
import fpml.consolidated.asset.QuoteTiming;
import fpml.consolidated.asset.ReportingCurrencyType;
import fpml.consolidated.asset.meta.QuotationCharacteristicsModelMeta;
import fpml.consolidated.fpmlenum.QuotationSideEnum;
import fpml.consolidated.shared.CashflowType;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.InformationSource;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="QuotationCharacteristicsModel", builder=QuotationCharacteristicsModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="QuotationCharacteristicsModel", model="fpml", builder=QuotationCharacteristicsModelBuilderImpl.class, version="1.2.2")
public interface QuotationCharacteristicsModel
extends RosettaModelObject {
    public static final QuotationCharacteristicsModelMeta metaData = new QuotationCharacteristicsModelMeta();

    public AssetMeasureType getMeasureType();

    public PriceQuoteUnits getQuoteUnits();

    public QuotationSideEnum getSide();

    public Currency getCurrency();

    public ReportingCurrencyType getCurrencyType();

    public QuoteTiming getTiming();

    public QuoteLocationModel getQuoteLocationModel();

    public List<? extends InformationSource> getInformationSource();

    public PricingModel getPricingModel();

    public ZonedDateTime getTime();

    public ZonedDateTime getValuationDate();

    public ZonedDateTime getExpiryTime();

    public CashflowType getCashflowType();

    public QuotationCharacteristicsModel build();

    public QuotationCharacteristicsModelBuilder toBuilder();

    public static QuotationCharacteristicsModelBuilder builder() {
        return new QuotationCharacteristicsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends QuotationCharacteristicsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends QuotationCharacteristicsModel> getType() {
        return QuotationCharacteristicsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("measureType"), processor, AssetMeasureType.class, this.getMeasureType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quoteUnits"), processor, PriceQuoteUnits.class, this.getQuoteUnits(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currencyType"), processor, ReportingCurrencyType.class, this.getCurrencyType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("timing"), processor, QuoteTiming.class, this.getTiming(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quoteLocationModel"), processor, QuoteLocationModel.class, this.getQuoteLocationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingModel"), processor, PricingModel.class, this.getPricingModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("time"), ZonedDateTime.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationDate"), ZonedDateTime.class, (Object)this.getValuationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expiryTime"), ZonedDateTime.class, (Object)this.getExpiryTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashflowType"), processor, CashflowType.class, this.getCashflowType(), new AttributeMeta[0]);
    }

    public static class QuotationCharacteristicsModelBuilderImpl
    implements QuotationCharacteristicsModelBuilder {
        protected AssetMeasureType.AssetMeasureTypeBuilder measureType;
        protected PriceQuoteUnits.PriceQuoteUnitsBuilder quoteUnits;
        protected QuotationSideEnum side;
        protected Currency.CurrencyBuilder currency;
        protected ReportingCurrencyType.ReportingCurrencyTypeBuilder currencyType;
        protected QuoteTiming.QuoteTimingBuilder timing;
        protected QuoteLocationModel.QuoteLocationModelBuilder quoteLocationModel;
        protected List<InformationSource.InformationSourceBuilder> informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
        protected PricingModel.PricingModelBuilder pricingModel;
        protected ZonedDateTime time;
        protected ZonedDateTime valuationDate;
        protected ZonedDateTime expiryTime;
        protected CashflowType.CashflowTypeBuilder cashflowType;

        @Override
        @RosettaAttribute(value="measureType")
        @RuneAttribute(value="measureType")
        public AssetMeasureType.AssetMeasureTypeBuilder getMeasureType() {
            return this.measureType;
        }

        @Override
        public AssetMeasureType.AssetMeasureTypeBuilder getOrCreateMeasureType() {
            AssetMeasureType.AssetMeasureTypeBuilder result = this.measureType != null ? this.measureType : (this.measureType = AssetMeasureType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quoteUnits")
        @RuneAttribute(value="quoteUnits")
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getQuoteUnits() {
            return this.quoteUnits;
        }

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateQuoteUnits() {
            PriceQuoteUnits.PriceQuoteUnitsBuilder result = this.quoteUnits != null ? this.quoteUnits : (this.quoteUnits = PriceQuoteUnits.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationSideEnum getSide() {
            return this.side;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currencyType")
        @RuneAttribute(value="currencyType")
        public ReportingCurrencyType.ReportingCurrencyTypeBuilder getCurrencyType() {
            return this.currencyType;
        }

        @Override
        public ReportingCurrencyType.ReportingCurrencyTypeBuilder getOrCreateCurrencyType() {
            ReportingCurrencyType.ReportingCurrencyTypeBuilder result = this.currencyType != null ? this.currencyType : (this.currencyType = ReportingCurrencyType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="timing")
        @RuneAttribute(value="timing")
        public QuoteTiming.QuoteTimingBuilder getTiming() {
            return this.timing;
        }

        @Override
        public QuoteTiming.QuoteTimingBuilder getOrCreateTiming() {
            QuoteTiming.QuoteTimingBuilder result = this.timing != null ? this.timing : (this.timing = QuoteTiming.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quoteLocationModel")
        @RuneAttribute(value="quoteLocationModel")
        public QuoteLocationModel.QuoteLocationModelBuilder getQuoteLocationModel() {
            return this.quoteLocationModel;
        }

        @Override
        public QuoteLocationModel.QuoteLocationModelBuilder getOrCreateQuoteLocationModel() {
            QuoteLocationModel.QuoteLocationModelBuilder result = this.quoteLocationModel != null ? this.quoteLocationModel : (this.quoteLocationModel = QuoteLocationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int index) {
            if (this.informationSource == null) {
                this.informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
            }
            return (InformationSource.InformationSourceBuilder)this.getIndex(this.informationSource, index, () -> {
                InformationSource.InformationSourceBuilder newInformationSource = InformationSource.builder();
                return newInformationSource;
            });
        }

        @Override
        @RosettaAttribute(value="pricingModel")
        @RuneAttribute(value="pricingModel")
        public PricingModel.PricingModelBuilder getPricingModel() {
            return this.pricingModel;
        }

        @Override
        public PricingModel.PricingModelBuilder getOrCreatePricingModel() {
            PricingModel.PricingModelBuilder result = this.pricingModel != null ? this.pricingModel : (this.pricingModel = PricingModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public ZonedDateTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public ZonedDateTime getValuationDate() {
            return this.valuationDate;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public ZonedDateTime getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @RosettaAttribute(value="cashflowType")
        @RuneAttribute(value="cashflowType")
        public CashflowType.CashflowTypeBuilder getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public CashflowType.CashflowTypeBuilder getOrCreateCashflowType() {
            CashflowType.CashflowTypeBuilder result = this.cashflowType != null ? this.cashflowType : (this.cashflowType = CashflowType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="measureType")
        @RuneAttribute(value="measureType")
        public QuotationCharacteristicsModelBuilder setMeasureType(AssetMeasureType _measureType) {
            this.measureType = _measureType == null ? null : _measureType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quoteUnits")
        @RuneAttribute(value="quoteUnits")
        public QuotationCharacteristicsModelBuilder setQuoteUnits(PriceQuoteUnits _quoteUnits) {
            this.quoteUnits = _quoteUnits == null ? null : _quoteUnits.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationCharacteristicsModelBuilder setSide(QuotationSideEnum _side) {
            this.side = _side == null ? null : _side;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public QuotationCharacteristicsModelBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyType")
        @RuneAttribute(value="currencyType")
        public QuotationCharacteristicsModelBuilder setCurrencyType(ReportingCurrencyType _currencyType) {
            this.currencyType = _currencyType == null ? null : _currencyType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="timing")
        @RuneAttribute(value="timing")
        public QuotationCharacteristicsModelBuilder setTiming(QuoteTiming _timing) {
            this.timing = _timing == null ? null : _timing.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quoteLocationModel")
        @RuneAttribute(value="quoteLocationModel")
        public QuotationCharacteristicsModelBuilder setQuoteLocationModel(QuoteLocationModel _quoteLocationModel) {
            this.quoteLocationModel = _quoteLocationModel == null ? null : _quoteLocationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public QuotationCharacteristicsModelBuilder addInformationSource(InformationSource _informationSource) {
            if (_informationSource != null) {
                this.informationSource.add(_informationSource.toBuilder());
            }
            return this;
        }

        @Override
        public QuotationCharacteristicsModelBuilder addInformationSource(InformationSource _informationSource, int idx) {
            this.getIndex(this.informationSource, idx, () -> _informationSource.toBuilder());
            return this;
        }

        @Override
        public QuotationCharacteristicsModelBuilder addInformationSource(List<? extends InformationSource> informationSources) {
            if (informationSources != null) {
                for (InformationSource informationSource : informationSources) {
                    this.informationSource.add(informationSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="informationSource")
        public QuotationCharacteristicsModelBuilder setInformationSource(List<? extends InformationSource> informationSources) {
            this.informationSource = informationSources == null ? new ArrayList<InformationSource.InformationSourceBuilder>() : (List)informationSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingModel")
        @RuneAttribute(value="pricingModel")
        public QuotationCharacteristicsModelBuilder setPricingModel(PricingModel _pricingModel) {
            this.pricingModel = _pricingModel == null ? null : _pricingModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public QuotationCharacteristicsModelBuilder setTime(ZonedDateTime _time) {
            this.time = _time == null ? null : _time;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public QuotationCharacteristicsModelBuilder setValuationDate(ZonedDateTime _valuationDate) {
            this.valuationDate = _valuationDate == null ? null : _valuationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public QuotationCharacteristicsModelBuilder setExpiryTime(ZonedDateTime _expiryTime) {
            this.expiryTime = _expiryTime == null ? null : _expiryTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashflowType")
        @RuneAttribute(value="cashflowType")
        public QuotationCharacteristicsModelBuilder setCashflowType(CashflowType _cashflowType) {
            this.cashflowType = _cashflowType == null ? null : _cashflowType.toBuilder();
            return this;
        }

        @Override
        public QuotationCharacteristicsModel build() {
            return new QuotationCharacteristicsModelImpl(this);
        }

        @Override
        public QuotationCharacteristicsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public QuotationCharacteristicsModelBuilder prune() {
            if (this.measureType != null && !this.measureType.prune().hasData()) {
                this.measureType = null;
            }
            if (this.quoteUnits != null && !this.quoteUnits.prune().hasData()) {
                this.quoteUnits = null;
            }
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.currencyType != null && !this.currencyType.prune().hasData()) {
                this.currencyType = null;
            }
            if (this.timing != null && !this.timing.prune().hasData()) {
                this.timing = null;
            }
            if (this.quoteLocationModel != null && !this.quoteLocationModel.prune().hasData()) {
                this.quoteLocationModel = null;
            }
            this.informationSource = this.informationSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.pricingModel != null && !this.pricingModel.prune().hasData()) {
                this.pricingModel = null;
            }
            if (this.cashflowType != null && !this.cashflowType.prune().hasData()) {
                this.cashflowType = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMeasureType() != null && this.getMeasureType().hasData()) {
                return true;
            }
            if (this.getQuoteUnits() != null && this.getQuoteUnits().hasData()) {
                return true;
            }
            if (this.getSide() != null) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getCurrencyType() != null && this.getCurrencyType().hasData()) {
                return true;
            }
            if (this.getTiming() != null && this.getTiming().hasData()) {
                return true;
            }
            if (this.getQuoteLocationModel() != null && this.getQuoteLocationModel().hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPricingModel() != null && this.getPricingModel().hasData()) {
                return true;
            }
            if (this.getTime() != null) {
                return true;
            }
            if (this.getValuationDate() != null) {
                return true;
            }
            if (this.getExpiryTime() != null) {
                return true;
            }
            return this.getCashflowType() != null && this.getCashflowType().hasData();
        }

        public QuotationCharacteristicsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuotationCharacteristicsModelBuilder o = (QuotationCharacteristicsModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeasureType(), (RosettaModelObjectBuilder)o.getMeasureType(), this::setMeasureType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuoteUnits(), (RosettaModelObjectBuilder)o.getQuoteUnits(), this::setQuoteUnits);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrencyType(), (RosettaModelObjectBuilder)o.getCurrencyType(), this::setCurrencyType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTiming(), (RosettaModelObjectBuilder)o.getTiming(), this::setTiming);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuoteLocationModel(), (RosettaModelObjectBuilder)o.getQuoteLocationModel(), this::setQuoteLocationModel);
            merger.mergeRosetta(this.getInformationSource(), o.getInformationSource(), this::getOrCreateInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingModel(), (RosettaModelObjectBuilder)o.getPricingModel(), this::setPricingModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashflowType(), (RosettaModelObjectBuilder)o.getCashflowType(), this::setCashflowType);
            merger.mergeBasic((Object)this.getSide(), (Object)o.getSide(), this::setSide, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationDate(), (Object)o.getValuationDate(), this::setValuationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpiryTime(), (Object)o.getExpiryTime(), this::setExpiryTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuotationCharacteristicsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.measureType, _that.getMeasureType())) {
                return false;
            }
            if (!Objects.equals(this.quoteUnits, _that.getQuoteUnits())) {
                return false;
            }
            if (!Objects.equals((Object)this.side, (Object)_that.getSide())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.currencyType, _that.getCurrencyType())) {
                return false;
            }
            if (!Objects.equals(this.timing, _that.getTiming())) {
                return false;
            }
            if (!Objects.equals(this.quoteLocationModel, _that.getQuoteLocationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.pricingModel, _that.getPricingModel())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.expiryTime, _that.getExpiryTime())) {
                return false;
            }
            return Objects.equals(this.cashflowType, _that.getCashflowType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.measureType != null ? this.measureType.hashCode() : 0);
            _result = 31 * _result + (this.quoteUnits != null ? this.quoteUnits.hashCode() : 0);
            _result = 31 * _result + (this.side != null ? ((Object)((Object)this.side)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.currencyType != null ? this.currencyType.hashCode() : 0);
            _result = 31 * _result + (this.timing != null ? this.timing.hashCode() : 0);
            _result = 31 * _result + (this.quoteLocationModel != null ? this.quoteLocationModel.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.pricingModel != null ? this.pricingModel.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            _result = 31 * _result + (this.cashflowType != null ? this.cashflowType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuotationCharacteristicsModelBuilder {measureType=" + String.valueOf(this.measureType) + ", quoteUnits=" + String.valueOf(this.quoteUnits) + ", side=" + String.valueOf((Object)this.side) + ", currency=" + String.valueOf(this.currency) + ", currencyType=" + String.valueOf(this.currencyType) + ", timing=" + String.valueOf(this.timing) + ", quoteLocationModel=" + String.valueOf(this.quoteLocationModel) + ", informationSource=" + String.valueOf(this.informationSource) + ", pricingModel=" + String.valueOf(this.pricingModel) + ", time=" + String.valueOf(this.time) + ", valuationDate=" + String.valueOf(this.valuationDate) + ", expiryTime=" + String.valueOf(this.expiryTime) + ", cashflowType=" + String.valueOf(this.cashflowType) + "}";
        }
    }

    public static interface QuotationCharacteristicsModelBuilder
    extends QuotationCharacteristicsModel,
    RosettaModelObjectBuilder {
        public AssetMeasureType.AssetMeasureTypeBuilder getOrCreateMeasureType();

        @Override
        public AssetMeasureType.AssetMeasureTypeBuilder getMeasureType();

        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateQuoteUnits();

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getQuoteUnits();

        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public ReportingCurrencyType.ReportingCurrencyTypeBuilder getOrCreateCurrencyType();

        @Override
        public ReportingCurrencyType.ReportingCurrencyTypeBuilder getCurrencyType();

        public QuoteTiming.QuoteTimingBuilder getOrCreateTiming();

        @Override
        public QuoteTiming.QuoteTimingBuilder getTiming();

        public QuoteLocationModel.QuoteLocationModelBuilder getOrCreateQuoteLocationModel();

        @Override
        public QuoteLocationModel.QuoteLocationModelBuilder getQuoteLocationModel();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int var1);

        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource();

        public PricingModel.PricingModelBuilder getOrCreatePricingModel();

        @Override
        public PricingModel.PricingModelBuilder getPricingModel();

        public CashflowType.CashflowTypeBuilder getOrCreateCashflowType();

        @Override
        public CashflowType.CashflowTypeBuilder getCashflowType();

        public QuotationCharacteristicsModelBuilder setMeasureType(AssetMeasureType var1);

        public QuotationCharacteristicsModelBuilder setQuoteUnits(PriceQuoteUnits var1);

        public QuotationCharacteristicsModelBuilder setSide(QuotationSideEnum var1);

        public QuotationCharacteristicsModelBuilder setCurrency(Currency var1);

        public QuotationCharacteristicsModelBuilder setCurrencyType(ReportingCurrencyType var1);

        public QuotationCharacteristicsModelBuilder setTiming(QuoteTiming var1);

        public QuotationCharacteristicsModelBuilder setQuoteLocationModel(QuoteLocationModel var1);

        public QuotationCharacteristicsModelBuilder addInformationSource(InformationSource var1);

        public QuotationCharacteristicsModelBuilder addInformationSource(InformationSource var1, int var2);

        public QuotationCharacteristicsModelBuilder addInformationSource(List<? extends InformationSource> var1);

        public QuotationCharacteristicsModelBuilder setInformationSource(List<? extends InformationSource> var1);

        public QuotationCharacteristicsModelBuilder setPricingModel(PricingModel var1);

        public QuotationCharacteristicsModelBuilder setTime(ZonedDateTime var1);

        public QuotationCharacteristicsModelBuilder setValuationDate(ZonedDateTime var1);

        public QuotationCharacteristicsModelBuilder setExpiryTime(ZonedDateTime var1);

        public QuotationCharacteristicsModelBuilder setCashflowType(CashflowType var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("measureType"), processor, AssetMeasureType.AssetMeasureTypeBuilder.class, this.getMeasureType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quoteUnits"), processor, PriceQuoteUnits.PriceQuoteUnitsBuilder.class, this.getQuoteUnits(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currencyType"), processor, ReportingCurrencyType.ReportingCurrencyTypeBuilder.class, this.getCurrencyType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("timing"), processor, QuoteTiming.QuoteTimingBuilder.class, this.getTiming(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quoteLocationModel"), processor, QuoteLocationModel.QuoteLocationModelBuilder.class, this.getQuoteLocationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingModel"), processor, PricingModel.PricingModelBuilder.class, this.getPricingModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("time"), ZonedDateTime.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationDate"), ZonedDateTime.class, (Object)this.getValuationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expiryTime"), ZonedDateTime.class, (Object)this.getExpiryTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashflowType"), processor, CashflowType.CashflowTypeBuilder.class, this.getCashflowType(), new AttributeMeta[0]);
        }

        public QuotationCharacteristicsModelBuilder prune();
    }

    public static class QuotationCharacteristicsModelImpl
    implements QuotationCharacteristicsModel {
        private final AssetMeasureType measureType;
        private final PriceQuoteUnits quoteUnits;
        private final QuotationSideEnum side;
        private final Currency currency;
        private final ReportingCurrencyType currencyType;
        private final QuoteTiming timing;
        private final QuoteLocationModel quoteLocationModel;
        private final List<? extends InformationSource> informationSource;
        private final PricingModel pricingModel;
        private final ZonedDateTime time;
        private final ZonedDateTime valuationDate;
        private final ZonedDateTime expiryTime;
        private final CashflowType cashflowType;

        protected QuotationCharacteristicsModelImpl(QuotationCharacteristicsModelBuilder builder) {
            this.measureType = Optional.ofNullable(builder.getMeasureType()).map(f -> f.build()).orElse(null);
            this.quoteUnits = Optional.ofNullable(builder.getQuoteUnits()).map(f -> f.build()).orElse(null);
            this.side = builder.getSide();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.currencyType = Optional.ofNullable(builder.getCurrencyType()).map(f -> f.build()).orElse(null);
            this.timing = Optional.ofNullable(builder.getTiming()).map(f -> f.build()).orElse(null);
            this.quoteLocationModel = Optional.ofNullable(builder.getQuoteLocationModel()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.pricingModel = Optional.ofNullable(builder.getPricingModel()).map(f -> f.build()).orElse(null);
            this.time = builder.getTime();
            this.valuationDate = builder.getValuationDate();
            this.expiryTime = builder.getExpiryTime();
            this.cashflowType = Optional.ofNullable(builder.getCashflowType()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="measureType")
        @RuneAttribute(value="measureType")
        public AssetMeasureType getMeasureType() {
            return this.measureType;
        }

        @Override
        @RosettaAttribute(value="quoteUnits")
        @RuneAttribute(value="quoteUnits")
        public PriceQuoteUnits getQuoteUnits() {
            return this.quoteUnits;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationSideEnum getSide() {
            return this.side;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="currencyType")
        @RuneAttribute(value="currencyType")
        public ReportingCurrencyType getCurrencyType() {
            return this.currencyType;
        }

        @Override
        @RosettaAttribute(value="timing")
        @RuneAttribute(value="timing")
        public QuoteTiming getTiming() {
            return this.timing;
        }

        @Override
        @RosettaAttribute(value="quoteLocationModel")
        @RuneAttribute(value="quoteLocationModel")
        public QuoteLocationModel getQuoteLocationModel() {
            return this.quoteLocationModel;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource> getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="pricingModel")
        @RuneAttribute(value="pricingModel")
        public PricingModel getPricingModel() {
            return this.pricingModel;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public ZonedDateTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public ZonedDateTime getValuationDate() {
            return this.valuationDate;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public ZonedDateTime getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @RosettaAttribute(value="cashflowType")
        @RuneAttribute(value="cashflowType")
        public CashflowType getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public QuotationCharacteristicsModel build() {
            return this;
        }

        @Override
        public QuotationCharacteristicsModelBuilder toBuilder() {
            QuotationCharacteristicsModelBuilder builder = QuotationCharacteristicsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuotationCharacteristicsModelBuilder builder) {
            Optional.ofNullable(this.getMeasureType()).ifPresent(builder::setMeasureType);
            Optional.ofNullable(this.getQuoteUnits()).ifPresent(builder::setQuoteUnits);
            Optional.ofNullable(this.getSide()).ifPresent(builder::setSide);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getCurrencyType()).ifPresent(builder::setCurrencyType);
            Optional.ofNullable(this.getTiming()).ifPresent(builder::setTiming);
            Optional.ofNullable(this.getQuoteLocationModel()).ifPresent(builder::setQuoteLocationModel);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getPricingModel()).ifPresent(builder::setPricingModel);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
            Optional.ofNullable(this.getValuationDate()).ifPresent(builder::setValuationDate);
            Optional.ofNullable(this.getExpiryTime()).ifPresent(builder::setExpiryTime);
            Optional.ofNullable(this.getCashflowType()).ifPresent(builder::setCashflowType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuotationCharacteristicsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.measureType, _that.getMeasureType())) {
                return false;
            }
            if (!Objects.equals(this.quoteUnits, _that.getQuoteUnits())) {
                return false;
            }
            if (!Objects.equals((Object)this.side, (Object)_that.getSide())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.currencyType, _that.getCurrencyType())) {
                return false;
            }
            if (!Objects.equals(this.timing, _that.getTiming())) {
                return false;
            }
            if (!Objects.equals(this.quoteLocationModel, _that.getQuoteLocationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.pricingModel, _that.getPricingModel())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.expiryTime, _that.getExpiryTime())) {
                return false;
            }
            return Objects.equals(this.cashflowType, _that.getCashflowType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.measureType != null ? this.measureType.hashCode() : 0);
            _result = 31 * _result + (this.quoteUnits != null ? this.quoteUnits.hashCode() : 0);
            _result = 31 * _result + (this.side != null ? ((Object)((Object)this.side)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.currencyType != null ? this.currencyType.hashCode() : 0);
            _result = 31 * _result + (this.timing != null ? this.timing.hashCode() : 0);
            _result = 31 * _result + (this.quoteLocationModel != null ? this.quoteLocationModel.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.pricingModel != null ? this.pricingModel.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            _result = 31 * _result + (this.cashflowType != null ? this.cashflowType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuotationCharacteristicsModel {measureType=" + String.valueOf(this.measureType) + ", quoteUnits=" + String.valueOf(this.quoteUnits) + ", side=" + String.valueOf((Object)this.side) + ", currency=" + String.valueOf(this.currency) + ", currencyType=" + String.valueOf(this.currencyType) + ", timing=" + String.valueOf(this.timing) + ", quoteLocationModel=" + String.valueOf(this.quoteLocationModel) + ", informationSource=" + String.valueOf(this.informationSource) + ", pricingModel=" + String.valueOf(this.pricingModel) + ", time=" + String.valueOf(this.time) + ", valuationDate=" + String.valueOf(this.valuationDate) + ", expiryTime=" + String.valueOf(this.expiryTime) + ", cashflowType=" + String.valueOf(this.cashflowType) + "}";
        }
    }
}

