/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.FxRateAssetMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.FxSpotRateSource;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxRateAsset", builder=FxRateAssetBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxRateAsset", model="fpml", builder=FxRateAssetBuilderImpl.class, version="1.2.2")
public interface FxRateAsset
extends UnderlyingAsset {
    public static final FxRateAssetMeta metaData = new FxRateAssetMeta();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public FxSpotRateSource getRateSource();

    @Override
    public FxRateAsset build();

    @Override
    public FxRateAssetBuilder toBuilder();

    public static FxRateAssetBuilder builder() {
        return new FxRateAssetBuilderImpl();
    }

    default public RosettaMetaData<? extends FxRateAsset> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxRateAsset> getType() {
        return FxRateAsset.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateSource"), processor, FxSpotRateSource.class, this.getRateSource(), new AttributeMeta[0]);
    }

    public static class FxRateAssetBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements FxRateAssetBuilder {
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected FxSpotRateSource.FxSpotRateSourceBuilder rateSource;

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rateSource")
        @RuneAttribute(value="rateSource")
        public FxSpotRateSource.FxSpotRateSourceBuilder getRateSource() {
            return this.rateSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateRateSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.rateSource != null ? this.rateSource : (this.rateSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxRateAssetBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public FxRateAssetBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public FxRateAssetBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public FxRateAssetBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public FxRateAssetBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public FxRateAssetBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public FxRateAssetBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public FxRateAssetBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public FxRateAssetBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public FxRateAssetBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public FxRateAssetBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public FxRateAssetBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public FxRateAssetBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public FxRateAssetBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public FxRateAssetBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateSource")
        @RuneAttribute(value="rateSource")
        public FxRateAssetBuilder setRateSource(FxSpotRateSource _rateSource) {
            this.rateSource = _rateSource == null ? null : _rateSource.toBuilder();
            return this;
        }

        @Override
        public FxRateAsset build() {
            return new FxRateAssetImpl(this);
        }

        @Override
        public FxRateAssetBuilder toBuilder() {
            return this;
        }

        @Override
        public FxRateAssetBuilder prune() {
            super.prune();
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.rateSource != null && !this.rateSource.prune().hasData()) {
                this.rateSource = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            return this.getRateSource() != null && this.getRateSource().hasData();
        }

        @Override
        public FxRateAssetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxRateAssetBuilder o = (FxRateAssetBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateSource(), (RosettaModelObjectBuilder)o.getRateSource(), this::setRateSource);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxRateAsset _that = (FxRateAsset)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            return Objects.equals(this.rateSource, _that.getRateSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.rateSource != null ? this.rateSource.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxRateAssetBuilder {quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", rateSource=" + String.valueOf(this.rateSource) + "} " + super.toString();
        }
    }

    public static interface FxRateAssetBuilder
    extends FxRateAsset,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateRateSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getRateSource();

        @Override
        public FxRateAssetBuilder setId(String var1);

        @Override
        public FxRateAssetBuilder addInstrumentId(InstrumentId var1);

        @Override
        public FxRateAssetBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public FxRateAssetBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FxRateAssetBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FxRateAssetBuilder addInstrumentType(InstrumentType var1);

        @Override
        public FxRateAssetBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public FxRateAssetBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public FxRateAssetBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public FxRateAssetBuilder setDescription(String var1);

        @Override
        public FxRateAssetBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public FxRateAssetBuilder setExchangeId(ExchangeId var1);

        @Override
        public FxRateAssetBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public FxRateAssetBuilder setDefinition(ProductReference var1);

        public FxRateAssetBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxRateAssetBuilder setRateSource(FxSpotRateSource var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getRateSource(), new AttributeMeta[0]);
        }

        @Override
        public FxRateAssetBuilder prune();
    }

    public static class FxRateAssetImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements FxRateAsset {
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final FxSpotRateSource rateSource;

        protected FxRateAssetImpl(FxRateAssetBuilder builder) {
            super(builder);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.rateSource = Optional.ofNullable(builder.getRateSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="rateSource")
        @RuneAttribute(value="rateSource")
        public FxSpotRateSource getRateSource() {
            return this.rateSource;
        }

        @Override
        public FxRateAsset build() {
            return this;
        }

        @Override
        public FxRateAssetBuilder toBuilder() {
            FxRateAssetBuilder builder = FxRateAsset.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxRateAssetBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getRateSource()).ifPresent(builder::setRateSource);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxRateAsset _that = (FxRateAsset)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            return Objects.equals(this.rateSource, _that.getRateSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.rateSource != null ? this.rateSource.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxRateAsset {quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", rateSource=" + String.valueOf(this.rateSource) + "} " + super.toString();
        }
    }
}

