/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.ExchangeIdentifierModel;
import fpml.consolidated.asset.ExchangeTradedContract;
import fpml.consolidated.asset.ExchangeTradedContractUnderlyer;
import fpml.consolidated.asset.ExchangeTradedOptionSequence;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.ExchangeTradedOptionMeta;
import fpml.consolidated.fpmlenum.ExerciseStyleEnum;
import fpml.consolidated.fpmlenum.PutCallEnum;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeTradedOption", builder=ExchangeTradedOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ExchangeTradedOption", model="fpml", builder=ExchangeTradedOptionBuilderImpl.class, version="1.2.2")
public interface ExchangeTradedOption
extends ExchangeTradedContract {
    public static final ExchangeTradedOptionMeta metaData = new ExchangeTradedOptionMeta();

    public ExchangeTradedOptionSequence getExchangeTradedOptionSequence();

    public PutCallEnum getOptionType();

    public ExerciseStyleEnum getExerciseStyle();

    public ExchangeTradedContractUnderlyer getUnderlyer();

    public SettlementTypeEnum getSettlementType();

    @Override
    public ExchangeTradedOption build();

    @Override
    public ExchangeTradedOptionBuilder toBuilder();

    public static ExchangeTradedOptionBuilder builder() {
        return new ExchangeTradedOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeTradedOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeTradedOption> getType() {
        return ExchangeTradedOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeTradedOptionSequence"), processor, ExchangeTradedOptionSequence.class, this.getExchangeTradedOptionSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exerciseStyle"), ExerciseStyleEnum.class, (Object)this.getExerciseStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ExchangeTradedOptionBuilderImpl
    extends ExchangeTradedContract.ExchangeTradedContractBuilderImpl
    implements ExchangeTradedOptionBuilder {
        protected ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder exchangeTradedOptionSequence;
        protected PutCallEnum optionType;
        protected ExerciseStyleEnum exerciseStyle;
        protected ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder underlyer;
        protected SettlementTypeEnum settlementType;

        @Override
        @RosettaAttribute(value="exchangeTradedOptionSequence")
        @RuneAttribute(value="exchangeTradedOptionSequence")
        public ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder getExchangeTradedOptionSequence() {
            return this.exchangeTradedOptionSequence;
        }

        @Override
        public ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder getOrCreateExchangeTradedOptionSequence() {
            ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder result = this.exchangeTradedOptionSequence != null ? this.exchangeTradedOptionSequence : (this.exchangeTradedOptionSequence = ExchangeTradedOptionSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public ExerciseStyleEnum getExerciseStyle() {
            return this.exerciseStyle;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getUnderlyer() {
            return this.underlyer;
        }

        @Override
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getOrCreateUnderlyer() {
            ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder result = this.underlyer != null ? this.underlyer : (this.underlyer = ExchangeTradedContractUnderlyer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ExchangeTradedOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public ExchangeTradedOptionBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedOptionBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedOptionBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public ExchangeTradedOptionBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedOptionBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedOptionBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedOptionBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedOptionBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public ExchangeTradedOptionBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ExchangeTradedOptionBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeTradedOptionBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ExchangeTradedOptionBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ExchangeTradedOptionBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public ExchangeTradedOptionBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public ExchangeTradedOptionBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractReference")
        @RuneAttribute(value="contractReference")
        public ExchangeTradedOptionBuilder setContractReference(String _contractReference) {
            this.contractReference = _contractReference == null ? null : _contractReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ExchangeTradedOptionBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedOptionSequence")
        @RuneAttribute(value="exchangeTradedOptionSequence")
        public ExchangeTradedOptionBuilder setExchangeTradedOptionSequence(ExchangeTradedOptionSequence _exchangeTradedOptionSequence) {
            this.exchangeTradedOptionSequence = _exchangeTradedOptionSequence == null ? null : _exchangeTradedOptionSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public ExchangeTradedOptionBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public ExchangeTradedOptionBuilder setExerciseStyle(ExerciseStyleEnum _exerciseStyle) {
            this.exerciseStyle = _exerciseStyle == null ? null : _exerciseStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public ExchangeTradedOptionBuilder setUnderlyer(ExchangeTradedContractUnderlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public ExchangeTradedOptionBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        public ExchangeTradedOption build() {
            return new ExchangeTradedOptionImpl(this);
        }

        @Override
        public ExchangeTradedOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeTradedOptionBuilder prune() {
            super.prune();
            if (this.exchangeTradedOptionSequence != null && !this.exchangeTradedOptionSequence.prune().hasData()) {
                this.exchangeTradedOptionSequence = null;
            }
            if (this.underlyer != null && !this.underlyer.prune().hasData()) {
                this.underlyer = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExchangeTradedOptionSequence() != null && this.getExchangeTradedOptionSequence().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getExerciseStyle() != null) {
                return true;
            }
            if (this.getUnderlyer() != null && this.getUnderlyer().hasData()) {
                return true;
            }
            return this.getSettlementType() != null;
        }

        @Override
        public ExchangeTradedOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExchangeTradedOptionBuilder o = (ExchangeTradedOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedOptionSequence(), (RosettaModelObjectBuilder)o.getExchangeTradedOptionSequence(), this::setExchangeTradedOptionSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyer(), (RosettaModelObjectBuilder)o.getUnderlyer(), this::setUnderlyer);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExerciseStyle(), (Object)o.getExerciseStyle(), this::setExerciseStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTradedOption _that = (ExchangeTradedOption)this.getType().cast(o);
            if (!Objects.equals(this.exchangeTradedOptionSequence, _that.getExchangeTradedOptionSequence())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.exerciseStyle, (Object)_that.getExerciseStyle())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            return Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeTradedOptionSequence != null ? this.exchangeTradedOptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exerciseStyle != null ? ((Object)((Object)this.exerciseStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedOptionBuilder {exchangeTradedOptionSequence=" + String.valueOf(this.exchangeTradedOptionSequence) + ", optionType=" + String.valueOf((Object)this.optionType) + ", exerciseStyle=" + String.valueOf((Object)this.exerciseStyle) + ", underlyer=" + String.valueOf(this.underlyer) + ", settlementType=" + String.valueOf((Object)this.settlementType) + "} " + super.toString();
        }
    }

    public static interface ExchangeTradedOptionBuilder
    extends ExchangeTradedOption,
    ExchangeTradedContract.ExchangeTradedContractBuilder {
        public ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder getOrCreateExchangeTradedOptionSequence();

        @Override
        public ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder getExchangeTradedOptionSequence();

        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getOrCreateUnderlyer();

        @Override
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getUnderlyer();

        @Override
        public ExchangeTradedOptionBuilder setId(String var1);

        @Override
        public ExchangeTradedOptionBuilder addInstrumentId(InstrumentId var1);

        @Override
        public ExchangeTradedOptionBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public ExchangeTradedOptionBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedOptionBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedOptionBuilder addInstrumentType(InstrumentType var1);

        @Override
        public ExchangeTradedOptionBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public ExchangeTradedOptionBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedOptionBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedOptionBuilder setDescription(String var1);

        @Override
        public ExchangeTradedOptionBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public ExchangeTradedOptionBuilder setExchangeId(ExchangeId var1);

        @Override
        public ExchangeTradedOptionBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public ExchangeTradedOptionBuilder setDefinition(ProductReference var1);

        @Override
        public ExchangeTradedOptionBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        @Override
        public ExchangeTradedOptionBuilder setMultiplier(BigDecimal var1);

        @Override
        public ExchangeTradedOptionBuilder setContractReference(String var1);

        @Override
        public ExchangeTradedOptionBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        public ExchangeTradedOptionBuilder setExchangeTradedOptionSequence(ExchangeTradedOptionSequence var1);

        public ExchangeTradedOptionBuilder setOptionType(PutCallEnum var1);

        public ExchangeTradedOptionBuilder setExerciseStyle(ExerciseStyleEnum var1);

        public ExchangeTradedOptionBuilder setUnderlyer(ExchangeTradedContractUnderlyer var1);

        public ExchangeTradedOptionBuilder setSettlementType(SettlementTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeTradedOptionSequence"), processor, ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder.class, this.getExchangeTradedOptionSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exerciseStyle"), ExerciseStyleEnum.class, (Object)this.getExerciseStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder.class, this.getUnderlyer(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ExchangeTradedOptionBuilder prune();
    }

    public static class ExchangeTradedOptionImpl
    extends ExchangeTradedContract.ExchangeTradedContractImpl
    implements ExchangeTradedOption {
        private final ExchangeTradedOptionSequence exchangeTradedOptionSequence;
        private final PutCallEnum optionType;
        private final ExerciseStyleEnum exerciseStyle;
        private final ExchangeTradedContractUnderlyer underlyer;
        private final SettlementTypeEnum settlementType;

        protected ExchangeTradedOptionImpl(ExchangeTradedOptionBuilder builder) {
            super(builder);
            this.exchangeTradedOptionSequence = Optional.ofNullable(builder.getExchangeTradedOptionSequence()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.exerciseStyle = builder.getExerciseStyle();
            this.underlyer = Optional.ofNullable(builder.getUnderlyer()).map(f -> f.build()).orElse(null);
            this.settlementType = builder.getSettlementType();
        }

        @Override
        @RosettaAttribute(value="exchangeTradedOptionSequence")
        @RuneAttribute(value="exchangeTradedOptionSequence")
        public ExchangeTradedOptionSequence getExchangeTradedOptionSequence() {
            return this.exchangeTradedOptionSequence;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public ExerciseStyleEnum getExerciseStyle() {
            return this.exerciseStyle;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public ExchangeTradedContractUnderlyer getUnderlyer() {
            return this.underlyer;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        public ExchangeTradedOption build() {
            return this;
        }

        @Override
        public ExchangeTradedOptionBuilder toBuilder() {
            ExchangeTradedOptionBuilder builder = ExchangeTradedOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeTradedOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExchangeTradedOptionSequence()).ifPresent(builder::setExchangeTradedOptionSequence);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getExerciseStyle()).ifPresent(builder::setExerciseStyle);
            Optional.ofNullable(this.getUnderlyer()).ifPresent(builder::setUnderlyer);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTradedOption _that = (ExchangeTradedOption)this.getType().cast(o);
            if (!Objects.equals(this.exchangeTradedOptionSequence, _that.getExchangeTradedOptionSequence())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.exerciseStyle, (Object)_that.getExerciseStyle())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            return Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeTradedOptionSequence != null ? this.exchangeTradedOptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exerciseStyle != null ? ((Object)((Object)this.exerciseStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedOption {exchangeTradedOptionSequence=" + String.valueOf(this.exchangeTradedOptionSequence) + ", optionType=" + String.valueOf((Object)this.optionType) + ", exerciseStyle=" + String.valueOf((Object)this.exerciseStyle) + ", underlyer=" + String.valueOf(this.underlyer) + ", settlementType=" + String.valueOf((Object)this.settlementType) + "} " + super.toString();
        }
    }
}

