/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.meta.CommissionMeta;
import fpml.consolidated.fpmlenum.CommissionDenominationEnum;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.FxRate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Commission", builder=CommissionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Commission", model="fpml", builder=CommissionBuilderImpl.class, version="1.2.2")
public interface Commission
extends RosettaModelObject {
    public static final CommissionMeta metaData = new CommissionMeta();

    public CommissionDenominationEnum getCommissionDenomination();

    public BigDecimal getCommissionAmount();

    public Currency getCurrency();

    public BigDecimal getCommissionPerTrade();

    public List<? extends FxRate> getFxRate();

    public Commission build();

    public CommissionBuilder toBuilder();

    public static CommissionBuilder builder() {
        return new CommissionBuilderImpl();
    }

    default public RosettaMetaData<? extends Commission> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Commission> getType() {
        return Commission.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("commissionDenomination"), CommissionDenominationEnum.class, (Object)this.getCommissionDenomination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("commissionAmount"), BigDecimal.class, (Object)this.getCommissionAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("commissionPerTrade"), BigDecimal.class, (Object)this.getCommissionPerTrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.class, this.getFxRate(), new AttributeMeta[0]);
    }

    public static class CommissionBuilderImpl
    implements CommissionBuilder {
        protected CommissionDenominationEnum commissionDenomination;
        protected BigDecimal commissionAmount;
        protected Currency.CurrencyBuilder currency;
        protected BigDecimal commissionPerTrade;
        protected List<FxRate.FxRateBuilder> fxRate = new ArrayList<FxRate.FxRateBuilder>();

        @Override
        @RosettaAttribute(value="commissionDenomination")
        @RuneAttribute(value="commissionDenomination")
        public CommissionDenominationEnum getCommissionDenomination() {
            return this.commissionDenomination;
        }

        @Override
        @RosettaAttribute(value="commissionAmount")
        @RuneAttribute(value="commissionAmount")
        public BigDecimal getCommissionAmount() {
            return this.commissionAmount;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commissionPerTrade")
        @RuneAttribute(value="commissionPerTrade")
        public BigDecimal getCommissionPerTrade() {
            return this.commissionPerTrade;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate.FxRateBuilder> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxRate.FxRateBuilder getOrCreateFxRate(int index) {
            if (this.fxRate == null) {
                this.fxRate = new ArrayList<FxRate.FxRateBuilder>();
            }
            return (FxRate.FxRateBuilder)this.getIndex(this.fxRate, index, () -> {
                FxRate.FxRateBuilder newFxRate = FxRate.builder();
                return newFxRate;
            });
        }

        @Override
        @RosettaAttribute(value="commissionDenomination")
        @RuneAttribute(value="commissionDenomination")
        public CommissionBuilder setCommissionDenomination(CommissionDenominationEnum _commissionDenomination) {
            this.commissionDenomination = _commissionDenomination == null ? null : _commissionDenomination;
            return this;
        }

        @Override
        @RosettaAttribute(value="commissionAmount")
        @RuneAttribute(value="commissionAmount")
        public CommissionBuilder setCommissionAmount(BigDecimal _commissionAmount) {
            this.commissionAmount = _commissionAmount == null ? null : _commissionAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public CommissionBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commissionPerTrade")
        @RuneAttribute(value="commissionPerTrade")
        public CommissionBuilder setCommissionPerTrade(BigDecimal _commissionPerTrade) {
            this.commissionPerTrade = _commissionPerTrade == null ? null : _commissionPerTrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public CommissionBuilder addFxRate(FxRate _fxRate) {
            if (_fxRate != null) {
                this.fxRate.add(_fxRate.toBuilder());
            }
            return this;
        }

        @Override
        public CommissionBuilder addFxRate(FxRate _fxRate, int idx) {
            this.getIndex(this.fxRate, idx, () -> _fxRate.toBuilder());
            return this;
        }

        @Override
        public CommissionBuilder addFxRate(List<? extends FxRate> fxRates) {
            if (fxRates != null) {
                for (FxRate fxRate : fxRates) {
                    this.fxRate.add(fxRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fxRate")
        public CommissionBuilder setFxRate(List<? extends FxRate> fxRates) {
            this.fxRate = fxRates == null ? new ArrayList<FxRate.FxRateBuilder>() : (List)fxRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Commission build() {
            return new CommissionImpl(this);
        }

        @Override
        public CommissionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommissionBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            this.fxRate = this.fxRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCommissionDenomination() != null) {
                return true;
            }
            if (this.getCommissionAmount() != null) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getCommissionPerTrade() != null) {
                return true;
            }
            return this.getFxRate() != null && this.getFxRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CommissionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommissionBuilder o = (CommissionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta(this.getFxRate(), o.getFxRate(), this::getOrCreateFxRate);
            merger.mergeBasic((Object)this.getCommissionDenomination(), (Object)o.getCommissionDenomination(), this::setCommissionDenomination, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCommissionAmount(), (Object)o.getCommissionAmount(), this::setCommissionAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCommissionPerTrade(), (Object)o.getCommissionPerTrade(), this::setCommissionPerTrade, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Commission _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.commissionDenomination, (Object)_that.getCommissionDenomination())) {
                return false;
            }
            if (!Objects.equals(this.commissionAmount, _that.getCommissionAmount())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.commissionPerTrade, _that.getCommissionPerTrade())) {
                return false;
            }
            return ListEquals.listEquals(this.fxRate, _that.getFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commissionDenomination != null ? ((Object)((Object)this.commissionDenomination)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commissionAmount != null ? this.commissionAmount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.commissionPerTrade != null ? this.commissionPerTrade.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommissionBuilder {commissionDenomination=" + String.valueOf((Object)this.commissionDenomination) + ", commissionAmount=" + String.valueOf(this.commissionAmount) + ", currency=" + String.valueOf(this.currency) + ", commissionPerTrade=" + String.valueOf(this.commissionPerTrade) + ", fxRate=" + String.valueOf(this.fxRate) + "}";
        }
    }

    public static interface CommissionBuilder
    extends Commission,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public FxRate.FxRateBuilder getOrCreateFxRate(int var1);

        public List<? extends FxRate.FxRateBuilder> getFxRate();

        public CommissionBuilder setCommissionDenomination(CommissionDenominationEnum var1);

        public CommissionBuilder setCommissionAmount(BigDecimal var1);

        public CommissionBuilder setCurrency(Currency var1);

        public CommissionBuilder setCommissionPerTrade(BigDecimal var1);

        public CommissionBuilder addFxRate(FxRate var1);

        public CommissionBuilder addFxRate(FxRate var1, int var2);

        public CommissionBuilder addFxRate(List<? extends FxRate> var1);

        public CommissionBuilder setFxRate(List<? extends FxRate> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("commissionDenomination"), CommissionDenominationEnum.class, (Object)this.getCommissionDenomination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("commissionAmount"), BigDecimal.class, (Object)this.getCommissionAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("commissionPerTrade"), BigDecimal.class, (Object)this.getCommissionPerTrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.FxRateBuilder.class, this.getFxRate(), new AttributeMeta[0]);
        }

        public CommissionBuilder prune();
    }

    public static class CommissionImpl
    implements Commission {
        private final CommissionDenominationEnum commissionDenomination;
        private final BigDecimal commissionAmount;
        private final Currency currency;
        private final BigDecimal commissionPerTrade;
        private final List<? extends FxRate> fxRate;

        protected CommissionImpl(CommissionBuilder builder) {
            this.commissionDenomination = builder.getCommissionDenomination();
            this.commissionAmount = builder.getCommissionAmount();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.commissionPerTrade = builder.getCommissionPerTrade();
            this.fxRate = Optional.ofNullable(builder.getFxRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="commissionDenomination")
        @RuneAttribute(value="commissionDenomination")
        public CommissionDenominationEnum getCommissionDenomination() {
            return this.commissionDenomination;
        }

        @Override
        @RosettaAttribute(value="commissionAmount")
        @RuneAttribute(value="commissionAmount")
        public BigDecimal getCommissionAmount() {
            return this.commissionAmount;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="commissionPerTrade")
        @RuneAttribute(value="commissionPerTrade")
        public BigDecimal getCommissionPerTrade() {
            return this.commissionPerTrade;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate> getFxRate() {
            return this.fxRate;
        }

        @Override
        public Commission build() {
            return this;
        }

        @Override
        public CommissionBuilder toBuilder() {
            CommissionBuilder builder = Commission.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommissionBuilder builder) {
            Optional.ofNullable(this.getCommissionDenomination()).ifPresent(builder::setCommissionDenomination);
            Optional.ofNullable(this.getCommissionAmount()).ifPresent(builder::setCommissionAmount);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getCommissionPerTrade()).ifPresent(builder::setCommissionPerTrade);
            Optional.ofNullable(this.getFxRate()).ifPresent(builder::setFxRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Commission _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.commissionDenomination, (Object)_that.getCommissionDenomination())) {
                return false;
            }
            if (!Objects.equals(this.commissionAmount, _that.getCommissionAmount())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.commissionPerTrade, _that.getCommissionPerTrade())) {
                return false;
            }
            return ListEquals.listEquals(this.fxRate, _that.getFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commissionDenomination != null ? ((Object)((Object)this.commissionDenomination)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commissionAmount != null ? this.commissionAmount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.commissionPerTrade != null ? this.commissionPerTrade.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Commission {commissionDenomination=" + String.valueOf((Object)this.commissionDenomination) + ", commissionAmount=" + String.valueOf(this.commissionAmount) + ", currency=" + String.valueOf(this.currency) + ", commissionPerTrade=" + String.valueOf(this.commissionPerTrade) + ", fxRate=" + String.valueOf(this.fxRate) + "}";
        }
    }
}

