/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.rosetta.model.lib.expression.Converter;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperItem;
import com.rosetta.model.lib.mapper.NamedFunction;
import com.rosetta.model.lib.meta.FieldWithMeta;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public interface MapperBuilder<T>
extends Mapper<T> {
    public <F> MapperBuilder<F> map(String var1, Function<T, F> var2);

    public <F> MapperBuilder<F> map(NamedFunction<T, F> var1);

    public <F> MapperBuilder<F> mapC(String var1, Function<T, List<? extends F>> var2);

    public <F> MapperBuilder<F> mapC(NamedFunction<T, List<? extends F>> var1);

    default public <C> MapperBuilder<C> convert(Class<C> clazz) {
        return this.map("Convert to " + clazz.getSimpleName(), i -> Converter.convert(clazz, i));
    }

    public MapperBuilder<T> unionSame(MapperBuilder<T> var1);

    public MapperBuilder<Object> unionDifferent(MapperBuilder<?> var1);

    public Stream<MapperItem<? extends T, ?>> getItems();

    default public Optional<MapperItem<?, ?>> findParent(MapperItem<?, ?> item) {
        Optional parentItem = item.getParentItem();
        if (parentItem.isPresent()) {
            if (parentItem.get().getMappedObject() instanceof FieldWithMeta) {
                return this.findParent(parentItem.get());
            }
            return Optional.of(parentItem.get());
        }
        return Optional.empty();
    }
}

