/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;

public class RosettaNumber
extends Number
implements Comparable<RosettaNumber> {
    public static final MathContext DECIMAL_PRECISION = MathContext.DECIMAL128;
    public static final RosettaNumber ZERO = new RosettaNumber(BigDecimal.ZERO);
    public static final RosettaNumber ONE = new RosettaNumber(BigDecimal.ONE);
    private static final long serialVersionUID = 1L;
    private final BigDecimal value;

    private RosettaNumber(BigDecimal value) {
        this.value = value.stripTrailingZeros();
    }

    public RosettaNumber(String repr) {
        this(new BigDecimal(repr, DECIMAL_PRECISION));
    }

    public static RosettaNumber valueOf(double value) {
        return new RosettaNumber(Double.toString(value));
    }

    public static RosettaNumber valueOf(long value) {
        return new RosettaNumber(new BigDecimal(value, DECIMAL_PRECISION));
    }

    public static RosettaNumber valueOf(BigInteger value) {
        return new RosettaNumber(new BigDecimal(value, DECIMAL_PRECISION));
    }

    public static RosettaNumber valueOf(BigDecimal value) {
        return new RosettaNumber(value.toString());
    }

    public RosettaNumber add(RosettaNumber other) {
        return new RosettaNumber(this.value.add(other.value));
    }

    public RosettaNumber subtract(RosettaNumber other) {
        return new RosettaNumber(this.value.subtract(other.value));
    }

    public RosettaNumber multiply(RosettaNumber other) {
        return new RosettaNumber(this.value.multiply(other.value, DECIMAL_PRECISION));
    }

    public RosettaNumber divide(RosettaNumber other) {
        return new RosettaNumber(this.value.divide(other.value, DECIMAL_PRECISION));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RosettaNumber other = (RosettaNumber)object;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toPlainString();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public int compareTo(RosettaNumber o) {
        return this.value.compareTo(o.value);
    }
}

