/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.schemeimport.iso.currency;

import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.impl.RosettaFactoryImpl;
import com.regnosys.testing.schemeimport.SchemeEnumReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.iso.currency.ISO4217;

public class IsoCurrencySchemeEnumReader
implements SchemeEnumReader {
    private final HttpClient httpClient = HttpClient.newHttpClient();

    @Override
    public List<RosettaEnumValue> generateEnumFromScheme(URL schemaLocationForEnum) {
        try {
            ISO4217 iso4217 = this.parseSchemaFile(schemaLocationForEnum);
            return this.transformToEnums(iso4217);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<RosettaEnumValue> transformToEnums(ISO4217 iso4217) {
        return iso4217.getCcyTbl().getCcyNtry().stream().filter(ccyNtry -> ccyNtry.getCcy() != null).map(ccyNtry -> new ImmutablePair((Object)ccyNtry.getCcy(), (Object)ccyNtry.getCcyNm().getValue())).distinct().map(pair -> this.createEnumValue((String)pair.getLeft(), (String)pair.getRight())).sorted(Comparator.comparing(RosettaNamed::getName)).collect(Collectors.toList());
    }

    private RosettaEnumValue createEnumValue(String currencyCode, String currencyName) {
        RosettaFactory factory = RosettaFactoryImpl.eINSTANCE;
        RosettaEnumValue ev = factory.createRosettaEnumValue();
        ev.setName(currencyCode);
        ev.setDefinition(currencyName);
        return ev;
    }

    private ISO4217 parseSchemaFile(URL schemaLocationForEnum) throws JAXBException, IOException, URISyntaxException, InterruptedException {
        String xmlContents = this.getXmlContents(schemaLocationForEnum);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ISO4217.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.removeLineBreaks(xmlContents).getBytes(StandardCharsets.UTF_8));
        return (ISO4217)jaxbUnmarshaller.unmarshal((InputStream)inputStream);
    }

    private String removeLineBreaks(String response) {
        return response.replace("\n", "").replace("\t", "");
    }

    private String getXmlContents(URL schemaLocationForEnum) throws URISyntaxException, IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(schemaLocationForEnum.toURI()).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Response from xml get: " + response.statusCode());
        }
        return response.body();
    }
}

