/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.schemeimport;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;

public class RosettaResourceWriter {
    public Map<String, String> generateRosettaFiles(Collection<Resource> resources) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Resource resource : resources) {
            try {
                String out = RosettaResourceWriter.removeDescriptionWhitespace(RosettaResourceWriter.removeEscapedQuotes(RosettaResourceWriter.rewriteProjectVersion(this.writeOut(resource))));
                String fileName = resource.getURI().lastSegment();
                results.put(fileName, out);
            }
            catch (IOException | InterruptedException | URISyntaxException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    public static String rewriteProjectVersion(String out) {
        return out.replaceAll("version \".*?\"", "version \"\\${project.version}\"");
    }

    private static String removeEscapedQuotes(String out) {
        return out.replace("\\'", "'");
    }

    private static String removeDescriptionWhitespace(String out) {
        return out.replace("< \"", "<\"").replace("\" >", "\">");
    }

    private String writeOut(Resource eResource) throws URISyntaxException, IOException, ExecutionException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(byteArrayOutputStream);
        eResource.save((OutputStream)out, null);
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byteArrayOutputStream.toByteArray())).toString();
    }
}

