/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.performance;

import com.google.common.base.Stopwatch;
import com.regnosys.testing.performance.PerformanceTest;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PerformanceTestHarness<I, O> {
    private final int threads;
    private final int runs;

    public static <I, O> void execute(int threads, int runs, PerformanceTest<I, O> performanceTest) {
        new PerformanceTestHarness<I, O>(threads, runs).execute(performanceTest);
    }

    public PerformanceTestHarness(int threads, int runs) {
        this.threads = threads;
        this.runs = runs;
    }

    void execute(PerformanceTest<I, O> test) {
        UncheckedPerformanceTest<I, O> performanceTest = new UncheckedPerformanceTest<I, O>(test);
        performanceTest.initState();
        List testData = performanceTest.loadData();
        performanceTest.run(testData.get(0));
        System.out.printf("Timing test using %s files and %s concurrent API calls%n", testData.size(), this.threads);
        System.out.print("Run #\t");
        System.out.printf("%s concurrent API calls (%s files)\t", this.threads, testData.size());
        System.out.printf("average run (1 file)%n", new Object[0]);
        double averageTime = IntStream.range(1, this.runs + 1).peek(i -> System.out.printf("%s\t", i)).mapToObj(x -> this.testRun(performanceTest, testData)).peek(i -> System.out.printf("%s\t", this.nanoToSeconds(i.toNanos()))).map(i -> i.dividedBy(testData.size())).peek(i -> System.out.printf("%s%n", this.nanoToMilliseconds(i.toNanos()))).mapToLong(Duration::getNano).average().orElseThrow(() -> new RuntimeException("No Data"));
        System.out.printf("%nTook average time of %s for a single run using %s concurrent API calls%n", this.nanoToMilliseconds((long)averageTime), this.threads);
    }

    private Duration testRun(PerformanceTest<I, O> performanceTest, List<I> testData) {
        ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
        List<Callable<O>> callables = testData.stream().map(data -> this.callable(performanceTest, data)).collect(Collectors.toList());
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<Future<O>> futures = this.invoke(executorService, callables);
        List results = futures.stream().map(this::dataFromFuture).collect(Collectors.toList());
        Duration elapsed = stopwatch.elapsed();
        executorService.shutdown();
        return elapsed;
    }

    private Callable<O> callable(PerformanceTest<I, O> performanceTest, I data) {
        return () -> performanceTest.run(data);
    }

    private List<Future<O>> invoke(ExecutorService executorService, List<Callable<O>> callables) {
        try {
            return executorService.invokeAll(callables);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private O dataFromFuture(Future<O> x) {
        try {
            return x.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private String nanoToSeconds(long nanos) {
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
        return String.format(Locale.ROOT, "%.2g", value) + "s";
    }

    private String nanoToMilliseconds(long nanos) {
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
        return String.format(Locale.ROOT, "%.3g", value) + "ms";
    }

    private static final class UncheckedPerformanceTest<I, O>
    implements PerformanceTest<I, O> {
        private final PerformanceTest<I, O> delegate;

        public UncheckedPerformanceTest(PerformanceTest<I, O> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void initState() {
            try {
                this.delegate.initState();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<I> loadData() {
            try {
                return this.delegate.loadData();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public O run(I data) {
            try {
                return this.delegate.run(data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

