/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.regnosys.rosetta.translate.synonymmap.SynonymCondition;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SynonymGroup {
    private final List<SynonymValue> synonymValues;
    private final List<SynonymCondition> conditions;
    private final String mapperName;
    private final String formatString;
    private final String patternMatcher;
    private final String patternReplace;
    private final boolean removeHtml;

    public SynonymGroup(List<SynonymValue> synonymValues, List<SynonymCondition> conditions, String mapperName, String formatString, String patternMatcher, String patternReplace, boolean removeHtml) {
        this.synonymValues = synonymValues;
        this.conditions = conditions;
        this.mapperName = mapperName;
        this.formatString = formatString;
        this.patternMatcher = patternMatcher;
        this.patternReplace = patternReplace;
        this.removeHtml = removeHtml;
    }

    public SynonymGroup(List<SynonymCondition> conditions) {
        this.synonymValues = Collections.emptyList();
        this.conditions = conditions;
        this.mapperName = null;
        this.formatString = null;
        this.patternMatcher = null;
        this.patternReplace = null;
        this.removeHtml = false;
    }

    public List<SynonymValue> getSynonymValues() {
        return this.synonymValues;
    }

    public List<SynonymCondition> getConditions() {
        return this.conditions;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String getPatternMatcher() {
        return this.patternMatcher;
    }

    public String getPatternReplace() {
        return this.patternReplace;
    }

    public boolean isRemoveHtml() {
        return this.removeHtml;
    }

    public String toString() {
        return String.format("SG[values=%s conditions=%s mapperName=%s, format=%s, pattern=%s/%s, removeHtml=%s]", this.synonymValues, this.conditions, this.mapperName, this.formatString, this.patternMatcher, this.patternReplace, this.removeHtml);
    }

    public String toPathsString() {
        return this.synonymValues.stream().map(sv -> sv.toPathString()).collect(Collectors.joining(", ")) + this.conditions.stream().map(c -> c.toString()).collect(Collectors.joining(","));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditions == null ? 0 : this.conditions.hashCode());
        result = 31 * result + (this.formatString == null ? 0 : this.formatString.hashCode());
        result = 31 * result + (this.mapperName == null ? 0 : this.mapperName.hashCode());
        result = 31 * result + (this.patternMatcher == null ? 0 : this.patternMatcher.hashCode());
        result = 31 * result + (this.patternReplace == null ? 0 : this.patternReplace.hashCode());
        result = 31 * result + (this.removeHtml ? 1231 : 1237);
        result = 31 * result + (this.synonymValues == null ? 0 : this.synonymValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymGroup other = (SynonymGroup)obj;
        if (this.conditions == null ? other.conditions != null : !this.conditions.equals(other.conditions)) {
            return false;
        }
        if (this.formatString == null ? other.formatString != null : !this.formatString.equals(other.formatString)) {
            return false;
        }
        if (this.mapperName == null ? other.mapperName != null : !this.mapperName.equals(other.mapperName)) {
            return false;
        }
        if (this.patternMatcher == null ? other.patternMatcher != null : !this.patternMatcher.equals(other.patternMatcher)) {
            return false;
        }
        if (this.patternReplace == null ? other.patternReplace != null : !this.patternReplace.equals(other.patternReplace)) {
            return false;
        }
        if (this.removeHtml != other.removeHtml) {
            return false;
        }
        return !(this.synonymValues == null ? other.synonymValues != null : !this.synonymValues.equals(other.synonymValues));
    }

    public long hashForGeneration() {
        long result = 0L;
        for (SynonymCondition cond : this.conditions) {
            result = result * 8191L + (long)cond.hashCode();
        }
        for (SynonymValue val : this.synonymValues) {
            result = result * 8191L + (long)val.getMapsTo();
            result = result * 8191L + (long)val.toPathString().hashCode();
        }
        if (this.mapperName != null) {
            result = result * 8191L + (long)this.mapperName.hashCode();
        }
        if (this.patternMatcher != null) {
            result = result * 8191L + (long)this.patternMatcher.hashCode();
        }
        if (this.patternReplace != null) {
            result = result * 8191L + (long)this.patternReplace.hashCode();
        }
        result = result * 8191L + (long)(this.removeHtml ? 1231 : 1237);
        return result;
    }
}

