/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ScopeReferenceHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingProcessorStep;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.regnosys.rosetta.common.util.SimpleBuilderProcessor;
import com.regnosys.rosetta.translate.HandlerFactory;
import com.regnosys.rosetta.translate.ParserResult;
import com.regnosys.rosetta.translate.SynonymToEnumMapBuilder;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.validation.Schema;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParserParent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserParent.class);
    private static final Path EMPTY_SCOPE = Path.valueOf((String)"emptyScope");
    protected final HandlerFactory factory;
    protected final SynonymToEnumMapBuilder synonymToEnumMap;
    private final ReferenceConfig referenceConfig;

    public ParserParent(HandlerFactory factory, SynonymToEnumMapBuilder synonymToEnumMap, ReferenceConfig referenceConfig) {
        this.factory = factory;
        this.synonymToEnumMap = synonymToEnumMap;
        this.referenceConfig = referenceConfig;
    }

    public <T extends RosettaModelObject> ParserResult parseDocument(Reader xml, Schema schema, Class<T> returnClass) {
        ParserResult resultDoc = this.parseTheDocument(xml, schema, returnClass);
        if (resultDoc.getRosettaInstance() != null) {
            LOGGER.debug("About to run conditional mapping post processor");
            resultDoc.getRosettaInstance().process((RosettaPath)new RosettaPath.NullPath(), (BuilderProcessor)new SimpleBuilderProcessor(this){

                public BuilderProcessor.Report report() {
                    return null;
                }

                public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
                    return true;
                }
            });
            LOGGER.debug("Finished running conditional mapping post processor");
        }
        Optional.ofNullable(resultDoc.getRosettaInstance()).ifPresent(builder -> {
            ParserResult.Context context = resultDoc.getContext();
            new MappingProcessorStep(context.getMappingProcessors().values(), context.getMappingContext()).runProcessStep(returnClass, (RosettaModelObject)builder);
        });
        if (resultDoc.getRosettaInstance() != null) {
            this.postProcessReferences(resultDoc);
        }
        return resultDoc;
    }

    private void postProcessReferences(ParserResult resultDoc) {
        RosettaModelObjectBuilder rosettaInstance = resultDoc.getRosettaInstance();
        KeyedCollector keyCollector = new KeyedCollector(this.referenceConfig);
        rosettaInstance.process((RosettaPath)new RosettaPath.NullPath(), (BuilderProcessor)keyCollector);
        Map modelPathToKeyMap = keyCollector.helper.getScopeToDataMap();
        Map<Path, Class<?>> keyPathToValueTypeMap = keyCollector.keyPathToTypeMap;
        ReferenceCollector referenceCollector = new ReferenceCollector(this.referenceConfig);
        rosettaInstance.process((RosettaPath)new RosettaPath.NullPath(), (BuilderProcessor)referenceCollector);
        Map<Path, Class<?>> referencePathToTypeMap = referenceCollector.referencePathToTypeMap;
        modelPathToKeyMap.entrySet().forEach(entry -> {
            Path currentScopePath = (Path)entry.getKey();
            Map scopedModelPathToKeyMap = (Map)entry.getValue();
            LOGGER.info("Building key/references for scope {}", (Object)currentScopePath);
            HashMap typeCounters = new HashMap();
            scopedModelPathToKeyMap.entrySet().forEach(k -> this.updateKeyBuilder((Path)k.getKey(), (GlobalKey.GlobalKeyBuilder)k.getValue(), typeCounters));
            List mappings = resultDoc.getContext().getMappingContext().getMappings();
            Multimap<Pair<Path, Path>, Reference.ReferenceBuilder> references = this.findReferences(mappings, currentScopePath);
            LOGGER.debug("Found reference model paths {}", (Object)references.keySet());
            references.entries().forEach(r -> {
                Path referenceSynonymPath = (Path)((Pair)r.getKey()).getLeft();
                Path referenceModelPath = (Path)((Pair)r.getKey()).getRight();
                Reference.ReferenceBuilder referenceBuilder = (Reference.ReferenceBuilder)r.getValue();
                Class referenceValueType = (Class)referencePathToTypeMap.get(referenceModelPath);
                if (referenceValueType != null) {
                    this.updateReferenceBuilder(referenceSynonymPath, referenceModelPath, referenceBuilder, referenceValueType, mappings, scopedModelPathToKeyMap, keyPathToValueTypeMap);
                } else {
                    LOGGER.debug("Path {} not found in reference model paths {}", (Object)referenceModelPath, referencePathToTypeMap.keySet());
                }
            });
        });
    }

    private void updateKeyBuilder(Path keyModelPath, GlobalKey.GlobalKeyBuilder keyBuilder, Map<String, Integer> typeCounters) {
        String name = keyModelPath.getLastElement().getPathName();
        Integer counter = typeCounters.compute(name, (n, i) -> i == null ? 1 : i + 1);
        String label = name + "-" + counter;
        keyBuilder.getMeta().getKey().stream().filter(k -> "DOCUMENT".equals(k.getScope())).forEach(k -> {
            LOGGER.debug("Adding key {} for model path [{}]", (Object)label, (Object)keyModelPath);
            k.setKeyValue(label);
        });
    }

    private void updateReferenceBuilder(Path referenceSynonymPath, Path referenceModelPath, Reference.ReferenceBuilder referenceBuilder, Class<?> referenceValueType, List<Mapping> mappings, Map<Path, GlobalKey.GlobalKeyBuilder> modelPathToKeyMap, Map<Path, Class<?>> keyPathToValueTypeMap) {
        List mappingsWithReferenceSynonymPath = mappings.stream().filter(m -> m.getXmlPath().equals((Object)referenceSynonymPath)).filter(m -> m.getRosettaPath() != null && m.getError() == null).collect(Collectors.toList());
        for (Mapping mappingWithReferenceSynonymPath : mappingsWithReferenceSynonymPath) {
            Path modelPath = mappingWithReferenceSynonymPath.getRosettaPath();
            for (Map.Entry<Path, GlobalKey.GlobalKeyBuilder> keyed : modelPathToKeyMap.entrySet()) {
                Class<?> keyType = keyPathToValueTypeMap.get(keyed.getKey());
                if (!referenceValueType.equals(keyType)) {
                    LOGGER.trace("Key and reference types do no match [referenceType {}, keyType {}]", (Object)referenceValueType.getName(), (Object)keyType.getName());
                    continue;
                }
                Path keyModelPath = keyed.getKey().prefixWithWildcard();
                if (!keyModelPath.fullStartMatches(modelPath, true)) continue;
                GlobalKey.GlobalKeyBuilder keyBuilder = keyed.getValue();
                Key key = (Key)keyBuilder.getOrCreateMeta().getKey().stream().filter(k -> "DOCUMENT".equals(k.getScope())).findFirst().get();
                String label = key.getKeyValue();
                LOGGER.debug("Setting reference {} for type {} at path {}", new Object[]{label, referenceValueType.getName(), referenceModelPath});
                referenceBuilder.setReference(label);
                referenceBuilder.setScope("DOCUMENT");
            }
        }
    }

    private Multimap<Pair<Path, Path>, Reference.ReferenceBuilder> findReferences(List<Mapping> mappings, Path scopePath) {
        Optional<Path> filterPath = Optional.ofNullable(!scopePath.equals((Object)EMPTY_SCOPE) ? scopePath.prefixWithWildcard() : null);
        return (Multimap)mappings.stream().filter(m -> m.getRosettaValue() instanceof Reference.ReferenceBuilder).filter(m -> filterPath.map(p -> p.fullStartMatches(m.getRosettaPath(), true)).orElse(true)).collect(Multimaps.toMultimap(m -> Pair.of((Object)m.getXmlPath(), (Object)m.getRosettaPath().trimFirst()), m -> (Reference.ReferenceBuilder)m.getRosettaValue(), ArrayListMultimap::create));
    }

    protected abstract <T extends RosettaModelObject> ParserResult parseTheDocument(Reader var1, Schema var2, Class<T> var3);

    private static class KeyedCollector
    extends SimpleBuilderProcessor {
        private final Map<Path, Class<?>> keyPathToTypeMap = new HashMap();
        private final ScopeReferenceHelper<Map<Path, GlobalKey.GlobalKeyBuilder>> helper;

        private KeyedCollector(ReferenceConfig referenceConfig) {
            this.helper = new ScopeReferenceHelper(referenceConfig, () -> new HashMap());
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            this.helper.collectScopePath(path, rosettaType);
            if (builder instanceof GlobalKey.GlobalKeyBuilder) {
                GlobalKey.GlobalKeyBuilder keyBuilder = (GlobalKey.GlobalKeyBuilder)builder;
                if (builder.hasData()) {
                    Optional.of(keyBuilder).map(g -> g.getMeta()).map(k -> k.getKey()).map(k -> k.stream()).ifPresent(s -> s.filter(k -> "DOCUMENT".equals(k.getScope())).forEach(k -> {
                        Path keyPath = PathUtils.toPath((RosettaPath)path);
                        ((Map)this.helper.getDataForModelPath(keyPath)).put(keyPath, keyBuilder);
                        FieldWithMeta fieldWithMeta = (FieldWithMeta)builder;
                        Class valueType = fieldWithMeta.getValueType();
                        LOGGER.trace("Found key type {} at path {}", (Object)valueType.getName(), (Object)keyPath);
                        this.keyPathToTypeMap.put(keyPath, valueType);
                    }));
                }
            }
            return true;
        }

        public BuilderProcessor.Report report() {
            return null;
        }
    }

    private static class ReferenceCollector
    extends SimpleBuilderProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceCollector.class);
        private final Map<Path, Class<?>> referencePathToTypeMap;
        private final ReferenceConfig config;

        private ReferenceCollector(ReferenceConfig config) {
            this.config = config;
            this.referencePathToTypeMap = new HashMap();
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            if (this.config.getExcludedPaths().stream().anyMatch(endsWithPathElement -> path.endsWith(endsWithPathElement))) {
                return false;
            }
            if (builder instanceof ReferenceWithMeta.ReferenceWithMetaBuilder) {
                ReferenceWithMeta.ReferenceWithMetaBuilder referenceWithMetaBuilder = (ReferenceWithMeta.ReferenceWithMetaBuilder)builder;
                Path referencePath = PathUtils.toPath((RosettaPath)path).addElement("reference");
                Class valueType = referenceWithMetaBuilder.getValueType();
                LOGGER.trace("Found referenced type {} at path {}", (Object)valueType.getName(), (Object)referencePath);
                this.referencePathToTypeMap.put(referencePath, valueType);
            }
            return true;
        }

        public BuilderProcessor.Report report() {
            return null;
        }
    }
}

