/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.regnosys.ingest.test.framework.ingestor.GeneratedIngestionParserMapper;
import com.regnosys.ingest.test.framework.ingestor.postprocess.PostProcessorRunner;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionFactory;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.regnosys.ingest.test.framework.ingestor.service.RosettaIngestionService;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.JsonHandlerFactory;
import com.regnosys.rosetta.translate.SynonymToEnumMapGenerator;
import com.regnosys.rosetta.translate.Translator;
import com.regnosys.rosetta.translate.TranslatorOptions;
import com.regnosys.rosetta.translate.XmlHandlerFactory;
import com.rosetta.model.lib.process.PostProcessStep;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class IngestionTestDebugHelper {
    protected static IngestionService getIngestionService(String string, final Module module, final Module module2, Class<?> clazz, List<PostProcessStep> list, boolean bl) {
        try {
            TranslatorOptions translatorOptions = IngestionFactory.getInstance().getTranslateOptions(string);
            Injector injector = new RosettaStandaloneSetup(){

                public Injector createInjector() {
                    return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{module}).with(new Module[]{module2})});
                }
            }.createInjectorAndDoEMFRegistration();
            IngesterGenerator ingesterGenerator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
            SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
            Translator.GeneratedClasses<XmlHandlerFactory> generatedClasses = new Translator(translatorOptions, clazz.getClassLoader(), ingesterGenerator, synonymToEnumMapGenerator).generateClassesFromXmlSchema(Paths.get("target/" + string, new String[0]), bl);
            GeneratedIngestionParserMapper generatedIngestionParserMapper = new GeneratedIngestionParserMapper(generatedClasses.getHandlerFactory(), generatedClasses.getSynonymToEnumMap(), translatorOptions.getXmlExclusionsFilePath(), translatorOptions.isJson(), translatorOptions.preProcessJson(), injector);
            PostProcessorRunner postProcessorRunner = new PostProcessorRunner(new ArrayList<PostProcessStep>(list));
            RosettaTypeValidator rosettaTypeValidator = (RosettaTypeValidator)injector.getInstance(RosettaTypeValidator.class);
            return new RosettaIngestionService(postProcessorRunner, generatedIngestionParserMapper, rosettaTypeValidator, translatorOptions.getName());
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static IngestionService getJsonIngestionService(String string, final Module module, final Module module2, Class<?> clazz, List<PostProcessStep> list, boolean bl) {
        try {
            TranslatorOptions translatorOptions = IngestionFactory.getInstance().getTranslateOptions(string);
            Injector injector = new RosettaStandaloneSetup(){

                public Injector createInjector() {
                    return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{module}).with(new Module[]{module2})});
                }
            }.createInjectorAndDoEMFRegistration();
            IngesterGenerator ingesterGenerator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
            SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
            ClassLoader classLoader = clazz.getClassLoader();
            Translator.GeneratedClasses<JsonHandlerFactory> generatedClasses = new Translator(translatorOptions, classLoader, ingesterGenerator, synonymToEnumMapGenerator).generateClassesFromJsonSchema(Paths.get("target/" + clazz.getSimpleName(), new String[0]), bl);
            GeneratedIngestionParserMapper generatedIngestionParserMapper = new GeneratedIngestionParserMapper(generatedClasses.getHandlerFactory(), generatedClasses.getSynonymToEnumMap(), translatorOptions.getXmlExclusionsFilePath(), translatorOptions.isJson(), translatorOptions.preProcessJson(), injector);
            RosettaTypeValidator rosettaTypeValidator = (RosettaTypeValidator)injector.getInstance(RosettaTypeValidator.class);
            return new RosettaIngestionService(new PostProcessorRunner(new ArrayList<PostProcessStep>(list)), generatedIngestionParserMapper, rosettaTypeValidator, translatorOptions.getName());
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }
}

