/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel;

import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EntityImpl
implements Entity {
    private final NamespaceName name;
    private final List<Attribute> attributes;
    private Entity extendedEntity;
    private final boolean hasValue;
    private final List<Entity> extendingEntities;

    public EntityImpl(NamespaceName name, Entity extendedEntity, boolean hasValue) {
        this.name = name;
        this.extendedEntity = extendedEntity;
        this.hasValue = hasValue || extendedEntity != null && extendedEntity.hasData();
        this.attributes = new ArrayList<Attribute>();
        this.extendingEntities = new ArrayList<Entity>();
        if (extendedEntity != null) {
            extendedEntity.getKnownExtendingEntities().add(this);
        }
    }

    public EntityImpl(NamespaceName name, boolean hasValue) {
        this(name, null, hasValue);
    }

    protected void setExtended(Entity extended) {
        this.extendedEntity = extended;
    }

    @Override
    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void addAttribute(Attribute att) {
        this.attributes.add(att);
    }

    @Override
    public Entity getExtendedEntity() {
        return this.extendedEntity;
    }

    @Override
    public List<Entity> getKnownExtendingEntities() {
        return this.extendingEntities;
    }

    @Override
    public boolean hasChild() {
        return this.attributes.size() != 0;
    }

    @Override
    public boolean hasData() {
        return this.hasValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityImpl other = (EntityImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String toString(Set<String> alreadyWritten) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (!alreadyWritten.contains(this.getName().getName())) {
            builder.append("\n");
            alreadyWritten.add(this.getName().getName());
            for (Attribute att : this.attributes) {
                String attString = att.toString(alreadyWritten);
                attString = attString.replace("\n", "\n  ");
                builder.append("  ");
                builder.append(attString);
                builder.append("\n");
            }
        } else {
            builder.append(".../n");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(new HashSet<String>());
    }
}

