/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.synonym;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingResult;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MappingReport {
    private final List<MappingResult> mappingResults;
    private int inputPathCount;
    private Map<RosettaPath, Object> inputPaths;
    private int outputPathCount;
    private Map<RosettaPath, Object> outputPaths;

    public MappingReport(List<MappingResult> mappingResults) {
        this.mappingResults = mappingResults;
    }

    public MappingReport(int inputPathCount, Map<RosettaPath, Object> inputPaths, int outputPathCount, Map<RosettaPath, Object> outputPaths) {
        this(null);
        this.inputPathCount = inputPathCount;
        this.inputPaths = inputPaths;
        this.outputPathCount = outputPathCount;
        this.outputPaths = outputPaths;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.getSuccessCount() != 0L && this.getSuccessCount() == (long)this.getExternalPaths();
    }

    @JsonProperty
    public int getExternalPaths() {
        return this.mappingResults.stream().filter(result -> !result.isExcludedExternalPath()).collect(Collectors.toList()).size();
    }

    @JsonProperty
    public int getInputPathCount() {
        return this.inputPathCount;
    }

    @JsonProperty
    public Map<RosettaPath, Object> getInputPaths() {
        return this.inputPaths;
    }

    @JsonProperty
    public int getOutputPathCount() {
        return this.outputPathCount;
    }

    @JsonProperty
    public Map<RosettaPath, Object> getOutputPaths() {
        return this.outputPaths;
    }

    @JsonProperty
    public List<MappingResult> getMappingResults() {
        return this.mappingResults;
    }

    @JsonProperty
    public Set<MappingResult> getFailures() {
        return this.getMappingResults().stream().filter(mappingResult -> !mappingResult.isSuccess()).filter(failResult -> !failResult.isExcludedExternalPath()).collect(Collectors.toSet());
    }

    @JsonProperty
    public Set<MappingResult> getSuccesses() {
        return this.getMappingResults().stream().filter(MappingResult::isSuccess).filter(successResult -> !successResult.isExcludedExternalPath()).collect(Collectors.toSet());
    }

    @JsonProperty
    public List<String> getExcludedPaths() {
        return this.getMappingResults().stream().filter(MappingResult::isExcludedExternalPath).map(MappingResult::getExternalPathNoMeta).distinct().sorted().collect(Collectors.toList());
    }

    @JsonProperty
    public long getSuccessCount() {
        return this.getSuccesses().size();
    }

    @JsonProperty
    public double getCompleteness() {
        return (double)this.getSuccessCount() / (double)this.getExternalPaths() * 100.0;
    }

    public String toString() {
        return "MappingReport{mappingResults=" + String.valueOf(this.mappingResults) + ", inputPathCount=" + this.inputPathCount + ", inputPaths=" + String.valueOf(this.inputPaths) + ", outputPathCount=" + this.outputPathCount + ", outputPaths=" + String.valueOf(this.outputPaths) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingReport that = (MappingReport)o;
        return this.inputPathCount == that.inputPathCount && this.outputPathCount == that.outputPathCount && Objects.equals(this.mappingResults, that.mappingResults) && Objects.equals(this.inputPaths, that.inputPaths) && Objects.equals(this.outputPaths, that.outputPaths);
    }

    public int hashCode() {
        return Objects.hash(this.mappingResults, this.inputPathCount, this.inputPaths, this.outputPathCount, this.outputPaths);
    }
}

