/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.regnosys.ingest.test.framework.ingestor.ExpectationUtil;
import com.regnosys.ingest.test.framework.ingestor.IngestionReport;
import com.regnosys.ingest.test.framework.ingestor.IngestionTestExpectation;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReport;
import com.regnosys.ingest.test.framework.ingestor.testing.Expectation;
import com.regnosys.ingest.test.framework.util.MappingReportsSummaryWriter;
import com.rosetta.model.lib.RosettaModelObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpectationManager.class);
    private final boolean writeActualExpectations;
    private final Multimap<String, IngestionTestExpectation> actualExpectation;
    private final MappingReportsSummaryWriter mappingReportsSummaryWriter;

    public ExpectationManager(boolean bl) {
        this.writeActualExpectations = bl;
        this.actualExpectation = ArrayListMultimap.create();
        this.mappingReportsSummaryWriter = new MappingReportsSummaryWriter();
    }

    public void captureExpectation(String string, String string2, IngestionReport<? extends RosettaModelObject> ingestionReport, Expectation expectation) {
        if (this.writeActualExpectations) {
            this.actualExpectation.put((Object)string, (Object)new IngestionTestExpectation(string2, ExpectationUtil.actualExpectation(ingestionReport, expectation.getCategory(), expectation.getFileName(), expectation.getExcludedPaths())));
        }
    }

    public void captureMappingReport(String string, Expectation expectation, MappingReport mappingReport) {
        if (this.writeActualExpectations) {
            String string2 = this.summaryDirPath(string, expectation);
            this.mappingReportsSummaryWriter.capture(string2, expectation.getFileName(), mappingReport);
        }
    }

    public void writeMappingReportsSummary() {
        if (!this.writeActualExpectations) {
            return;
        }
        ExpectationUtil.TEST_WRITE_BASE_PATH.filter(path -> Files.exists(path, new LinkOption[0])).map(path -> {
            Path path2 = path.resolve("mapping-analytics");
            try {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return path2;
        }).ifPresent(path -> {
            try {
                this.mappingReportsSummaryWriter.writeSummaryCsvs((Path)path);
            }
            catch (IOException iOException) {
                LOGGER.error("Could not write CSV Mapping report", (Throwable)iOException);
            }
        });
    }

    public void printExpectations() throws IOException {
        if (!this.writeActualExpectations) {
            return;
        }
        ExpectationUtil.printExpectations(this.actualExpectation, true);
    }

    private String summaryDirPath(String string, Expectation expectation) {
        String string2 = expectation.getFileName().substring(0, expectation.getFileName().indexOf("/"));
        return string.substring(string.indexOf(string2) + string2.length() + 1, string.indexOf("/expectations.json")).replace("/", "-");
    }
}

