/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.transport.Channel;
import com.refinitiv.eta.transport.ChannelInfo;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.transport.WriteArgs;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueAck;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueData;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueDataExpired;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueRequest;
import com.refinitiv.eta.valueadd.reactor.AckRangeList;
import com.refinitiv.eta.valueadd.reactor.ClassOfService;
import com.refinitiv.eta.valueadd.reactor.ConsumerRole;
import com.refinitiv.eta.valueadd.reactor.QueueCloseImpl;
import com.refinitiv.eta.valueadd.reactor.QueueMsgImpl;
import com.refinitiv.eta.valueadd.reactor.QueueRefreshImpl;
import com.refinitiv.eta.valueadd.reactor.QueueRequestImpl;
import com.refinitiv.eta.valueadd.reactor.QueueStatusImpl;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.SlicedBufferPool;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamAcceptOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBigBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBigBufferPool;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamDefaultMsgCallback;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamInfoImpl;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamManager;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamMsg;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamMsgImpl;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamOpenOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamQueueMsgCallback;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRequestEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamStateInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamStatusEventCallback;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamUtil;
import com.refinitiv.eta.valueadd.reactor.TunnelSubstream;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WorkerEventTypes;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class TunnelStream {
    ReactorChannel _reactorChannel;
    Reactor _reactor;
    QueueData _queueData;
    QueueDataExpired _queueDataExpired;
    QueueAck _queueAck;
    ReactorErrorInfo _errorInfo;
    int _streamId;
    int _channelStreamId;
    int _domainType;
    int _serviceId;
    GenericMsg _genericMsg;
    DecodeIterator _dIter;
    EncodeIterator _eIter;
    State _state;
    TunnelStreamDefaultMsgCallback _defaultMsgCallback;
    TunnelStreamStatusEventCallback _statusEventCallback;
    TunnelStreamQueueMsgCallback _queueMsgCallback;
    LoginRequest _authLoginRequest;
    String _name;
    int _guaranteedOutputBuffers;
    Object _userSpecObject;
    boolean _isProvider;
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();
    WlInteger _tableKey;
    ReactorSubmitOptions _reactorSubmitOptions = ReactorFactory.createReactorSubmitOptions();
    static final int DEFAULT_RECV_WINDOW = 12288;
    static final int CONTAINER_TYPE_POSITION = 9;
    SlicedBufferPool _bufferPool;
    private TunnelStream _managerNext;
    private TunnelStream _managerPrev;
    static final ManagerLink MANAGER_LINK = new ManagerLink();
    private TunnelStream _dispatchNext;
    private TunnelStream _dispatchPrev;
    static final DispatchLink DISPATCH_LINK = new DispatchLink();
    private TunnelStream _timeoutNext;
    private TunnelStream _timeoutPrev;
    static final TimeoutLink TIMEOUT_LINK = new TimeoutLink();
    VaDoubleLinkList<TunnelStreamBuffer> _tunnelStreamBufferPool;
    VaDoubleLinkList<TunnelStreamBuffer> _outboundMsgAckList;
    VaDoubleLinkList<TunnelStreamBuffer> _outboundTransmitList;
    VaDoubleLinkList<TunnelStreamBuffer> _outboundTimeoutList;
    VaDoubleLinkList<TunnelStreamBuffer> _outboundImmediateList;
    WriteArgs _writeArgs;
    TunnelStreamMsg _tunnelStreamMsg;
    GenericMsg _tunnelStreamHdr;
    Buffer _tmpBuffer;
    AckRangeList _sendNakRangeList;
    AckRangeList _recvNakRangeList;
    AckRangeList _recvAckRangeList;
    int _outboundQueuedMsgCount;
    int _outboundUnackedAppMsgCount;
    boolean _notifying;
    TunnelStreamStateInfo.TunnelStreamState _tunnelStreamState;
    int _traceFlags = 0;
    AckRangeList _traceAckRangeList;
    AckRangeList _traceNakRangeList;
    Msg _traceMsg;
    Msg _traceSubMsg;
    DecodeIterator _traceIter;
    SimpleDateFormat _traceDateFormat;
    static final TimeZone _traceTimeZone = TimeZone.getTimeZone("UTC");
    Msg _xmlMsg = CodecFactory.createMsg();
    DecodeIterator _xmlIter = CodecFactory.createDecodeIterator();
    ChannelInfo _chnlInfo = TransportFactory.createChannelInfo();
    ClassOfService _classOfService = new ClassOfService();
    EncodeIterator _encIter;
    Msg _encMsg;
    Msg _decMsg;
    Msg _decSubMsg;
    Msg _decSubMsgForSubmit;
    DecodeIterator _decIter;
    DecodeIterator _decSubIter;
    QueueMsgImpl _queueSubstreamHeader;
    QueueRequestImpl _queueRequest;
    QueueRefreshImpl _queueRefresh;
    QueueCloseImpl _queueClose;
    QueueStatusImpl _queueStatus;
    LoginMsg _loginMsg;
    long _nextTimeoutNsec;
    int _responseTimeout;
    boolean _hasNextTimeout;
    boolean _streamOpen;
    int _sendBytes;
    int _sendLastSeqNum;
    int _sendLastSeqNumAcked;
    int _sendLastSeqNumNaked;
    int _recvBytes;
    int _recvLastSeqNum;
    int _recvLastSeqNumAckSent;
    boolean _firstIsSendWindowOpenCall;
    boolean _providerLoginRefreshSent;
    HashMap<Integer, TunnelSubstream> _streamIdtoQueueSubstreamTable;
    HashMap<WlInteger, TunnelStreamBigBuffer> _msgIdBigBufferMap;
    TransportBuffer _writeCallAgainBuffer;
    long finAckTimeout = 150L;
    int _max_num_timeout_retry = 3;
    int _sendFinSeqNum;
    boolean _hasFinSent = false;
    boolean _initialFinSent = false;
    int _finAckWaitCount = 0;
    int _ackOpcodeFin = 1;
    int _ackOpcodeFinAck = 1;
    boolean _receivedFinAck = false;
    boolean _receivedFinalFin = false;
    int _receivedFinalFinSeqNum;
    int _receivedLastFinSeqNum;
    boolean _finalStatusEvent;
    boolean _forceFileReset;
    boolean _enableQueueMsgTracing = false;
    TunnelStreamBigBufferPool _bigBufferPool;
    int _messageId;
    final int MAX_MSG_ID = 65535;
    VaDoubleLinkList<TunnelStreamBigBuffer> _pendingBigBufferList;
    boolean _jUnitSkipHandleTransmit;
    int _requestRetryCount;
    final int MAX_REQUEST_RETRIES = 1;
    Msg _tempMsg;

    public TunnelStream(ReactorChannel reactorChannel, TunnelStreamOpenOptions options) {
        this(reactorChannel);
        this._streamId = options.streamId();
        this._domainType = options.domainType();
        this._serviceId = options.serviceId();
        this._guaranteedOutputBuffers = options.guaranteedOutputBuffers();
        options.classOfService().copy(this._classOfService);
        this._defaultMsgCallback = options.defaultMsgCallback();
        this._statusEventCallback = options.statusEventCallback();
        this._queueMsgCallback = options.queueMsgCallback();
        this._authLoginRequest = options.authLoginRequest();
        if (this._authLoginRequest == null && reactorChannel.role() != null) {
            this._authLoginRequest = ((ConsumerRole)reactorChannel.role()).rdmLoginRequest();
        }
        this._name = options.name();
        this._userSpecObject = options.userSpecObject();
        this._responseTimeout = options.responseTimeout();
        this._bigBufferPool = new TunnelStreamBigBufferPool(options.classOfService().common().maxFragmentSize(), options.guaranteedOutputBuffers());
    }

    public TunnelStream(ReactorChannel reactorChannel, TunnelStreamRequestEvent event, TunnelStreamAcceptOptions options) {
        this(reactorChannel);
        this._streamId = event.streamId();
        this._domainType = event.domainType();
        this._serviceId = event.serviceId();
        this._guaranteedOutputBuffers = options.guaranteedOutputBuffers();
        options.classOfService().copy(this._classOfService);
        this._defaultMsgCallback = options.defaultMsgCallback();
        this._statusEventCallback = options.statusEventCallback();
        this._name = event.name();
        this._userSpecObject = options.userSpecObject();
        this._isProvider = true;
        this._bigBufferPool = new TunnelStreamBigBufferPool(options.classOfService().common().maxFragmentSize(), options.guaranteedOutputBuffers());
    }

    TunnelStream(ReactorChannel reactorChannel) {
        this._reactorChannel = reactorChannel;
        this._reactor = this._reactorChannel.reactor();
        this._queueData = QueueMsgFactory.createQueueData();
        this._queueDataExpired = QueueMsgFactory.createQueueDataExpired();
        this._queueAck = QueueMsgFactory.createQueueAck();
        this._errorInfo = ReactorFactory.createReactorErrorInfo();
        this._genericMsg = (GenericMsg)CodecFactory.createMsg();
        this._dIter = CodecFactory.createDecodeIterator();
        this._eIter = CodecFactory.createEncodeIterator();
        this._state = CodecFactory.createState();
        this._state.streamState(1);
        this._state.dataState(2);
        this._state.code(0);
        this._tunnelStreamBufferPool = new VaDoubleLinkList();
        this._outboundMsgAckList = new VaDoubleLinkList();
        this._outboundTransmitList = new VaDoubleLinkList();
        this._outboundImmediateList = new VaDoubleLinkList();
        this._outboundTimeoutList = new VaDoubleLinkList();
        this._tunnelStreamMsg = new TunnelStreamMsgImpl();
        this._queueRequest = (QueueRequestImpl)QueueMsgFactory.createQueueRequest();
        this._queueRefresh = (QueueRefreshImpl)QueueMsgFactory.createQueueRefresh();
        this._queueData = QueueMsgFactory.createQueueData();
        this._queueDataExpired = QueueMsgFactory.createQueueDataExpired();
        this._queueAck = QueueMsgFactory.createQueueAck();
        this._queueClose = (QueueCloseImpl)QueueMsgFactory.createQueueClose();
        this._queueStatus = (QueueStatusImpl)QueueMsgFactory.createQueueStatus();
        this._tunnelStreamHdr = (GenericMsg)CodecFactory.createMsg();
        this._tmpBuffer = CodecFactory.createBuffer();
        this._sendNakRangeList = new AckRangeList();
        this._recvAckRangeList = new AckRangeList();
        this._recvNakRangeList = new AckRangeList();
        this._writeArgs = TransportFactory.createWriteArgs();
        this._encIter = CodecFactory.createEncodeIterator();
        this._decIter = CodecFactory.createDecodeIterator();
        this._decSubIter = CodecFactory.createDecodeIterator();
        this._encMsg = CodecFactory.createMsg();
        this._decMsg = CodecFactory.createMsg();
        this._decSubMsg = CodecFactory.createMsg();
        this._decSubMsgForSubmit = CodecFactory.createMsg();
        this._loginMsg = LoginMsgFactory.createMsg();
        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
        this._traceIter = CodecFactory.createDecodeIterator();
        this._traceMsg = CodecFactory.createMsg();
        this._traceSubMsg = CodecFactory.createMsg();
        this._traceAckRangeList = new AckRangeList();
        this._traceNakRangeList = new AckRangeList();
        this._traceDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
        this._traceDateFormat.setTimeZone(_traceTimeZone);
        this._streamIdtoQueueSubstreamTable = new HashMap();
        this._msgIdBigBufferMap = new HashMap();
        this._receivedFinAck = false;
        this._receivedFinalFin = false;
        this._hasFinSent = false;
        this._receivedLastFinSeqNum = -1;
        this._finalStatusEvent = true;
        this._pendingBigBufferList = new VaDoubleLinkList();
        this._tempMsg = CodecFactory.createMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportBuffer getBuffer(int size, ReactorErrorInfo errorInfo) {
        if (this._reactor.isShutdown()) {
            this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.getBuffer", "Reactor is shutdown, getBuffer aborted");
            return null;
        }
        this._reactor._reactorLock.lock();
        try {
            TunnelStreamBuffer buffer = null;
            if (size > this._classOfService.common().maxMsgSize()) {
                this._reactor.populateErrorInfo(errorInfo, -6, "TunnelStream.getBuffer", "Message size is too large.");
                TransportBuffer transportBuffer = null;
                return transportBuffer;
            }
            if (size <= this._classOfService.common().maxFragmentSize()) {
                buffer = this.getBuffer(size, true, true, errorInfo.error());
                if (buffer != null) {
                    errorInfo.error().text("");
                    errorInfo.error().errorId(0);
                } else {
                    this._reactor.populateErrorInfo(errorInfo, errorInfo.error().errorId(), "TunnelStream.getBuffer", errorInfo.error().text());
                }
            } else {
                TunnelStreamBigBuffer tunnelStreamBigBuffer = this._bigBufferPool.getBuffer(size, errorInfo);
                return tunnelStreamBigBuffer;
            }
            TunnelStreamBuffer tunnelStreamBuffer = buffer;
            return tunnelStreamBuffer;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseBuffer(TransportBuffer buffer, ReactorErrorInfo errorInfo) {
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.releaseBuffer", "Reactor is shutdown, releaseBuffer aborted");
        }
        this._reactor._reactorLock.lock();
        try {
            int n = this.releaseBuffer((TunnelStreamBuffer)buffer, errorInfo.error());
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    public int info(TunnelStreamInfo tunnelStreamInfo, ReactorErrorInfo errorInfo) {
        assert (errorInfo != null) : "errorInfo cannot be null";
        if (tunnelStreamInfo == null) {
            return this._reactor.populateErrorInfo(errorInfo, -6, "TunnelStream.info", "tunnelStreamInfo cannot be null");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.info", "Reactor is shutdown, info aborted");
        }
        if (!(tunnelStreamInfo instanceof TunnelStreamInfoImpl)) {
            return this._reactor.populateErrorInfo(errorInfo, -6, "TunnelStream.info", "invalid tunnelStreamInfo parameter type");
        }
        ((TunnelStreamInfoImpl)tunnelStreamInfo).ordinaryBuffersUsed(this._bufferPool.getBuffersUsed());
        ((TunnelStreamInfoImpl)tunnelStreamInfo).bigBuffersUsed(this._bigBufferPool.getBuffersUsed());
        return 0;
    }

    public int submit(TransportBuffer buffer, TunnelStreamSubmitOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            return -1;
        }
        if (buffer == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "buffer cannot be null.");
        }
        if (options == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "options cannot be null.");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.submit", "Reactor is shutdown, submit aborted.");
        }
        return this.handleBufferSubmit(this._reactorChannel, buffer, options.containerType(), errorInfo);
    }

    public int submit(MsgBase rdmMsg, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            return -1;
        }
        if (rdmMsg == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "rdmMsg cannot be null.");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.submit", "Reactor is shutdown, submit aborted.");
        }
        if (this._classOfService.guarantee().type() != 1 || rdmMsg.domainType() == 1 || rdmMsg.domainType() == 4 || rdmMsg.domainType() == 5 || rdmMsg.domainType() == 10) {
            return this.handleRDMSubmit(this._reactorChannel, rdmMsg, errorInfo);
        }
        return this.handleQueueMsgRDMSubmit(this._reactorChannel, (QueueMsg)rdmMsg, errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleRDMSubmit(ReactorChannel reactorChannel, MsgBase rdmMsg, ReactorErrorInfo errorInfo) {
        block14: {
            int ret = 0;
            this._reactor._reactorLock.lock();
            try {
                if (reactorChannel.state() == ReactorChannel.State.CLOSED) {
                    ret = -1;
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "ReactorChannel is closed, aborting.");
                    return n;
                }
                int bufLength = this._reactor.getMaxFragmentSize(reactorChannel, errorInfo);
                if (bufLength < 0) {
                    int n = bufLength;
                    return n;
                }
                TransportBuffer buffer = this.getBuffer(bufLength, errorInfo);
                if (buffer != null) {
                    this._eIter.clear();
                    this._eIter.setBufferAndRWFVersion(buffer, this._reactorChannel.majorVersion(), this._reactorChannel.minorVersion());
                    ret = rdmMsg.encode(this._eIter);
                    if (ret != 0) {
                        this.releaseBuffer(buffer, errorInfo);
                        int n = this._reactor.populateErrorInfo(errorInfo, ret, "TunnelStream.submit", "Unable to encode RDM Msg");
                        return n;
                    }
                    ret = this.handleBufferSubmit(this._reactorChannel, buffer, 141, errorInfo);
                    if (ret < 0) {
                        this.releaseBuffer(buffer, errorInfo);
                        int n = this._reactor.populateErrorInfo(errorInfo, ret, "TunnelStream.submit", "TunnelStream.submit() failed");
                        return n;
                    }
                    break block14;
                }
                if (!this._reactor.sendWorkerEvent(WorkerEventTypes.FLUSH, reactorChannel)) {
                    this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this._reactor.sendAndHandleChannelEventCallback("TunnelStream.submit", 2, reactorChannel, errorInfo);
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "_reactor.sendWorkerEvent() failed");
                    return n;
                }
                this._reactor.populateErrorInfo(errorInfo, -3, "TunnelStream.submit", "channel out of buffers chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                int n = -3;
                return n;
            }
            finally {
                this._reactor._reactorLock.unlock();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleQueueMsgRDMSubmit(ReactorChannel reactorChannel, QueueMsg queueMsg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        this._reactor._reactorLock.lock();
        try {
            if (reactorChannel.state() == ReactorChannel.State.CLOSED) {
                ret = -1;
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "ReactorChannel is closed, aborting.");
                return n;
            }
            switch (queueMsg.rdmMsgType()) {
                case REQUEST: {
                    int n = this.openQueueMsgStream(reactorChannel, (QueueRequest)queueMsg, this._serviceId, errorInfo);
                    return n;
                }
                case CLOSE: 
                case REFRESH: 
                case STATUS: 
                case ACK: 
                case DATA: {
                    TransportBuffer buffer;
                    int bufLength;
                    int n = bufLength = queueMsg.rdmMsgType() == QueueMsgType.DATA ? ((QueueData)queueMsg).encodedDataBody().length() + this.queueDataHdrBufSize((QueueData)queueMsg) : 128;
                    if (bufLength > this._classOfService.common().maxMsgSize()) {
                        bufLength = this._classOfService.common().maxMsgSize();
                    }
                    if ((buffer = this.getBuffer(bufLength, errorInfo)) != null) {
                        this._eIter.clear();
                        this._eIter.setBufferAndRWFVersion(buffer, this._reactorChannel.majorVersion(), this._reactorChannel.minorVersion());
                        ret = queueMsg.encode(this._eIter);
                        if (ret != 0) {
                            this.releaseBuffer(buffer, errorInfo);
                            int n2 = this._reactor.populateErrorInfo(errorInfo, ret, "TunnelStream.submit", "Unable to encode QueueMsg");
                            return n2;
                        }
                        ret = this.handleBufferSubmit(this._reactorChannel, buffer, 141, errorInfo);
                        if (ret < 0) {
                            this.releaseBuffer(buffer, errorInfo);
                            int n3 = this._reactor.populateErrorInfo(errorInfo, ret, "TunnelStream.submit", "TunnelStream.submit() failed");
                            return n3;
                        }
                        break;
                    }
                    if (!this._reactor.sendWorkerEvent(WorkerEventTypes.FLUSH, reactorChannel)) {
                        this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this._reactor.sendAndHandleChannelEventCallback("TunnelStream.submit", 2, reactorChannel, errorInfo);
                        int n4 = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "_reactor.sendWorkerEvent() failed");
                        return n4;
                    }
                    this._reactor.populateErrorInfo(errorInfo, -3, "TunnelStream.submit", "channel out of buffers chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                    int n5 = -3;
                    return n5;
                }
                default: {
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "Unsupported QueueMsgType");
                    return n;
                }
            }
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
        return 0;
    }

    int queueDataHdrBufSize(QueueData queueMsg) {
        return 128 + queueMsg.sourceName().length() + queueMsg.destName().length();
    }

    public int submit(Msg msg, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            return -1;
        }
        if (msg == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "msg cannot be null.");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.submit", "Reactor is shutdown, submit aborted.");
        }
        return this.handleMsgSubmit(this._reactorChannel, msg, errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleMsgSubmit(ReactorChannel reactorChannel, Msg msg, ReactorErrorInfo errorInfo) {
        block12: {
            int ret = 0;
            this._reactor._reactorLock.lock();
            try {
                if (reactorChannel.state() == ReactorChannel.State.CLOSED) {
                    ret = -1;
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "ReactorChannel is closed, aborting.");
                    return n;
                }
                int bufLength = this.encodedMsgSize(msg);
                TransportBuffer buffer = this.getBuffer(bufLength, errorInfo);
                if (buffer != null) {
                    this._eIter.clear();
                    this._eIter.setBufferAndRWFVersion(buffer, this._reactorChannel.majorVersion(), this._reactorChannel.minorVersion());
                    ret = msg.encode(this._eIter);
                    if (ret != 0) {
                        this.releaseBuffer(buffer, errorInfo);
                        int n = this._reactor.populateErrorInfo(errorInfo, ret, "TunnelStream.submit", "Unable to encode Msg");
                        return n;
                    }
                    ret = this.handleBufferSubmit(this._reactorChannel, buffer, 141, errorInfo);
                    if (ret < 0) {
                        this.releaseBuffer(buffer, errorInfo);
                        int n = this._reactor.populateErrorInfo(errorInfo, ret, "TunnelStream.submit", "TunnelStream.submit() failed");
                        return n;
                    }
                    break block12;
                }
                if (!this._reactor.sendWorkerEvent(WorkerEventTypes.FLUSH, reactorChannel)) {
                    this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this._reactor.sendAndHandleChannelEventCallback("TunnelStream.submit", 2, reactorChannel, errorInfo);
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "_reactor.sendWorkerEvent() failed");
                    return n;
                }
                this._reactor.populateErrorInfo(errorInfo, -3, "TunnelStream.submit", "channel out of buffers chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                int n = -3;
                return n;
            }
            finally {
                this._reactor._reactorLock.unlock();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleBufferSubmit(ReactorChannel reactorChannel, TransportBuffer buffer, int containerType, ReactorErrorInfo errorInfo) {
        int ret = 0;
        this._reactor._reactorLock.lock();
        try {
            if (reactorChannel.state() == ReactorChannel.State.CLOSED) {
                ret = -1;
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "ReactorChannel is closed, aborting.");
                return n;
            }
            ret = this.submit((TunnelStreamBuffer)buffer, containerType, errorInfo.error());
            if (ret < 0) {
                int n = ret;
                return n;
            }
            if (reactorChannel.tunnelStreamManager().needsDispatchNow() && !this._reactor.sendDispatchNowEvent(reactorChannel)) {
                this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
                reactorChannel.state(ReactorChannel.State.DOWN);
                this._reactor.sendAndHandleChannelEventCallback("TunnelStream.submit", 2, reactorChannel, errorInfo);
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "_reactor.sendDispatchNowEvent() failed");
                return n;
            }
            if (reactorChannel.tunnelStreamManager().hasNextDispatchTime() && !this._reactor.sendWorkerEvent(WorkerEventTypes.START_DISPATCH_TIMER, reactorChannel, reactorChannel.tunnelStreamManager().nextDispatchTime())) {
                this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
                reactorChannel.state(ReactorChannel.State.DOWN);
                this._reactor.sendAndHandleChannelEventCallback("TunnelStream.dispatchChannel", 2, reactorChannel, errorInfo);
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.submit", "_reactor.sendWorkerEvent() failed");
                return n;
            }
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
        return 0;
    }

    public int close(boolean finalStatusEvent, ReactorErrorInfo errorInfo) {
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "TunnelStream.close", "Reactor is shutdown, close aborted.");
        }
        this._state.streamState(1);
        this._state.dataState(2);
        this._state.code(0);
        this.close(finalStatusEvent, errorInfo.error());
        this._tempWlInteger.value(this._streamId);
        if (this._reactorChannel.streamIdtoTunnelStreamTable().containsKey(this._tempWlInteger) && this._reactorChannel.tunnelStreamManager().needsDispatchNow() && !this._reactor.sendDispatchNowEvent(this._reactorChannel)) {
            this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, this._reactorChannel);
            this._reactorChannel.state(ReactorChannel.State.DOWN);
            return 0;
        }
        return 0;
    }

    int openQueueMsgStream(ReactorChannel reactorChannel, QueueRequest queueRequest, int serviceId, ReactorErrorInfo errorInfo) {
        int retval = 0;
        retval = this.openSubstream(queueRequest, errorInfo.error());
        if (retval < 0) {
            return this._reactor.populateErrorInfo(errorInfo, retval, "TunnelStream.openQueueMsgStream", "TunnelStream.openSubstream() failed <" + errorInfo.error().text() + ">");
        }
        if (this._enableQueueMsgTracing) {
            this.enableTrace(7);
        }
        if (reactorChannel.tunnelStreamManager().needsDispatchNow() && !this._reactor.sendDispatchNowEvent(reactorChannel)) {
            this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
            reactorChannel.state(ReactorChannel.State.DOWN);
            this._reactor.sendAndHandleChannelEventCallback("TunnelStream.openQueueMsgStream", 2, reactorChannel, errorInfo);
            return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.openQueueMsgStream", "_reactor.sendDispatchNowEvent() failed");
        }
        return 0;
    }

    int queueMsgReceived(QueueMsg queueMsg, Msg msg) {
        int retval = 0;
        retval = this._reactor.sendAndHandleQueueMsgCallback("TunnelStream.queueMsgReceived", this._reactorChannel, this, null, msg, queueMsg, this._errorInfo);
        if (retval == -2) {
            retval = this._reactor.sendAndHandleTunnelStreamMsgCallback("TunnelStream.queueMsgReceived", this._reactorChannel, this, null, msg, 141, this._errorInfo);
        }
        return retval;
    }

    int queueMsgAcknowledged(QueueAck queueAck, Msg msg) {
        int retval = 0;
        retval = this._reactor.sendAndHandleQueueMsgCallback("TunnelStream.queueMsgAcknowledged", this._reactorChannel, this, null, msg, queueAck, this._errorInfo);
        if (retval == -2) {
            retval = this._reactor.sendAndHandleTunnelStreamMsgCallback("TunnelStream.queueMsgAcknowledged", this._reactorChannel, this, null, msg, 141, this._errorInfo);
        }
        return retval;
    }

    int queueMsgExpired(TunnelStreamBuffer buffer, Msg msg, int code) {
        int retval = 0;
        buffer.setAsInnerReadBuffer();
        this._decIter.clear();
        this._decIter.setBufferAndRWFVersion((TransportBuffer)buffer, this._reactorChannel.majorVersion(), this._reactorChannel.minorVersion());
        this._decSubMsg.decode(this._decIter);
        this._queueData.clear();
        this._queueData.decode(this._decIter, this._decSubMsg);
        this._queueDataExpired.clear();
        this._queueDataExpired.streamId(this._queueData.streamId());
        this._queueDataExpired.identifier(this._queueData.identifier());
        this._queueDataExpired.serviceId(this._queueData.serviceId());
        this._queueDataExpired.sourceName().data(this._queueData.destName().data(), this._queueData.destName().position(), this._queueData.destName().length());
        this._queueDataExpired.destName().data(this._queueData.sourceName().data(), this._queueData.sourceName().position(), this._queueData.sourceName().length());
        this._queueDataExpired.undeliverableCode(code);
        this._queueDataExpired.encodedDataBody(this._queueData.encodedDataBody());
        this._queueDataExpired.domainType(this._queueData.domainType());
        this._queueDataExpired.containerType(this._queueData.containerType());
        retval = this._reactor.sendAndHandleQueueMsgCallback("TunnelStream.queueMsgExpired", this._reactorChannel, this, buffer, msg, this._queueDataExpired, this._errorInfo);
        if (retval == -2) {
            retval = this._reactor.sendAndHandleTunnelStreamMsgCallback("TunnelStream.queueMsgExpired", this._reactorChannel, this, buffer, msg, 141, this._errorInfo);
        }
        return retval;
    }

    int msgReceived(TunnelStreamBuffer buffer, Msg msg, int containerType) {
        return this._reactor.sendAndHandleTunnelStreamMsgCallback("TunnelStream.msgReceived", this._reactorChannel, this, buffer, msg, containerType, this._errorInfo);
    }

    public int streamId() {
        return this._streamId;
    }

    public int domainType() {
        return this._domainType;
    }

    public int serviceId() {
        return this._serviceId;
    }

    public ClassOfService classOfService() {
        return this._classOfService;
    }

    public int guaranteedOutputBuffers() {
        return this._guaranteedOutputBuffers;
    }

    public TunnelStreamStatusEventCallback statusEventCallback() {
        return this._statusEventCallback;
    }

    public TunnelStreamDefaultMsgCallback defaultMsgCallback() {
        return this._defaultMsgCallback;
    }

    public TunnelStreamQueueMsgCallback queueMsgCallback() {
        return this._queueMsgCallback;
    }

    LoginRequest authLoginRequest() {
        return this._authLoginRequest;
    }

    public String name() {
        return this._name;
    }

    TunnelStreamManager tunnelStreamManager() {
        return this._reactorChannel.tunnelStreamManager();
    }

    public Object userSpecObject() {
        return this._userSpecObject;
    }

    public State state() {
        return this._state;
    }

    public ReactorChannel reactorChannel() {
        return this._reactorChannel;
    }

    public boolean isProvider() {
        return this._isProvider;
    }

    boolean xmlTracing() {
        return this._reactor._reactorOptions.xmlTracing();
    }

    void notifying(boolean notifying) {
        this._notifying = notifying;
    }

    boolean notifying() {
        return this._notifying;
    }

    int openStream(Error error) {
        this._streamOpen = true;
        this._firstIsSendWindowOpenCall = true;
        if (this.isProvider()) {
            this.setupBufferPool();
        }
        if (this._tunnelStreamState != TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN) {
            error.errorId(-6);
            error.text("Tunnel stream is already opened.");
            return -6;
        }
        if (this._reactorChannel.tunnelStreamManager().reactorChannel().channel() != null) {
            if (!this.isProvider()) {
                this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_REQUEST;
            } else {
                this._recvLastSeqNumAckSent = this._recvLastSeqNum;
                this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.STREAM_OPEN;
            }
        } else assert (this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN);
        this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
        return 0;
    }

    void setupBufferPool() {
        this._bufferPool = new SlicedBufferPool(this._classOfService.common().maxFragmentSize(), this.guaranteedOutputBuffers());
    }

    void forceFileReset(boolean forceFileReset) {
        this._forceFileReset = forceFileReset;
    }

    boolean forceFileReset() {
        return this._forceFileReset;
    }

    int openSubstream(QueueRequest requestMsg, Error error) {
        int ret = 0;
        TunnelSubstream substreamSession = null;
        try {
            if (this._classOfService.guarantee().type() != 1) {
                return -1;
            }
            if (requestMsg.sourceName().length() > 200) {
                error.errorId(-5);
                error.text("sourceName is too long.");
                return -5;
            }
            if (!this._streamIdtoQueueSubstreamTable.containsKey(requestMsg.streamId())) {
                if (this._classOfService.guarantee().persistLocally()) {
                    substreamSession = new TunnelSubstream(requestMsg.sourceName(), requestMsg.streamId(), requestMsg.domainType(), this.serviceId(), this._classOfService.guarantee().persistenceFilePath(), this, error);
                    this.updateTimeout(System.nanoTime());
                } else {
                    substreamSession = new TunnelSubstream(requestMsg.sourceName(), requestMsg.streamId(), requestMsg.domainType(), this.serviceId(), this, error);
                    this._hasNextTimeout = false;
                }
                if (error.errorId() != 0) {
                    return error.errorId();
                }
            } else {
                error.errorId(-6);
                error.text("Substream with stream id " + requestMsg.streamId() + " is already open");
                return -6;
            }
            this._streamIdtoQueueSubstreamTable.put(requestMsg.streamId(), substreamSession);
            ret = substreamSession.sendSubstreamRequest(requestMsg, error);
            if (this.isStreamOpen()) {
                this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
            }
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.openSubstream() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.openSubstream() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
        return ret;
    }

    private boolean isStreamOpen() {
        return this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.STREAM_OPEN || this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.WAITING_AUTHENTICATION;
    }

    int streamClosed(Error error) {
        int ret = 0;
        try {
            TunnelStreamBuffer tunnelStreamBuffer;
            while ((tunnelStreamBuffer = this._outboundTransmitList.pop(TunnelStreamBuffer.RETRANS_LINK)) != null) {
                this.releaseBuffer(tunnelStreamBuffer, error);
            }
            while ((tunnelStreamBuffer = this._outboundMsgAckList.pop(TunnelStreamBuffer.RETRANS_LINK)) != null) {
                this.releaseBuffer(tunnelStreamBuffer, error);
            }
            this._outboundTimeoutList.clear();
            this._outboundImmediateList.clear();
            this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
            this._sendLastSeqNum = 0;
            this._recvLastSeqNum = 0;
            this._recvLastSeqNumAckSent = 0;
            this._sendLastSeqNumNaked = 0;
            this._sendNakRangeList.count(0);
            this._firstIsSendWindowOpenCall = false;
            for (TunnelSubstream substreamSession : this._streamIdtoQueueSubstreamTable.values()) {
                ret = substreamSession.close(error);
            }
            this._streamIdtoQueueSubstreamTable.clear();
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.streamClosed() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.streamClosed() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
        return ret;
    }

    int close(boolean finalStatusEvent, Error error) {
        this._streamOpen = false;
        if (this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN) {
            return 0;
        }
        this._finalStatusEvent = finalStatusEvent;
        this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromTimeoutList(this);
        this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_FIN;
        this._sendFinSeqNum = -1;
        this._hasFinSent = false;
        this._messageId = 0;
        this._requestRetryCount = 0;
        this._classOfService.common().streamVersion(2);
        return 0;
    }

    int closeSubstream(int substreamId, Error error) {
        try {
            TunnelSubstream substreamSession = this._streamIdtoQueueSubstreamTable.get(substreamId);
            if (substreamSession == null) {
                error.errorId(-6);
                error.text("Substream is not open.");
                return -6;
            }
            int ret = substreamSession.close(error);
            if (ret != 0) {
                return ret;
            }
            this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.closeSubstream() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.closeSubstream() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    int releaseBuffer(TunnelStreamBuffer buffer, Error error) {
        if (!buffer.isBigBuffer()) {
            buffer.persistenceBuffer(null, null);
            this._bufferPool.releaseBufferSlice(buffer);
            this._tunnelStreamBufferPool.push(buffer, TunnelStreamBuffer.RETRANS_LINK);
        } else {
            this._bigBufferPool.releaseBuffer((TunnelStreamBigBuffer)buffer);
        }
        return 0;
    }

    TunnelStreamBuffer getBuffer(int length, boolean isForUser, boolean addTunnelStreamHeader, Error error) {
        TunnelStreamBuffer tunnelBuffer = null;
        if (length > this._classOfService.common().maxFragmentSize()) {
            error.errorId(-6);
            error.text("Fragment size is too large.");
            return null;
        }
        tunnelBuffer = this._tunnelStreamBufferPool.pop(TunnelStreamBuffer.RETRANS_LINK);
        if (tunnelBuffer == null) {
            tunnelBuffer = new TunnelStreamBuffer();
        }
        tunnelBuffer.clear(length);
        this._bufferPool.getBufferSlice(tunnelBuffer, length + (addTunnelStreamHeader ? 128 : 0), isForUser);
        if (tunnelBuffer.data() == null) {
            this._tunnelStreamBufferPool.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
            error.errorId(-3);
            error.text("TunnelStream is out of buffers");
            return null;
        }
        if (addTunnelStreamHeader) {
            this._encIter.clear();
            this._encIter.setBufferAndRWFVersion((TransportBuffer)tunnelBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
            this._tunnelStreamHdr.clear();
            this._tunnelStreamHdr.msgClass(7);
            this._tunnelStreamHdr.streamId(this._channelStreamId);
            this._tunnelStreamHdr.domainType(this.domainType());
            this._tunnelStreamHdr.containerType(141);
            this._tunnelStreamHdr.applyHasExtendedHdr();
            this._tunnelStreamHdr.applyMessageComplete();
            this._tunnelStreamHdr.applyHasSeqNum();
            this._tunnelStreamHdr.seqNum((long)this._sendLastSeqNum);
            tunnelBuffer.seqNum(this._sendLastSeqNum);
            int ret = this._tunnelStreamHdr.encodeInit(this._encIter, 0);
            if (ret != 12) {
                this.releaseBuffer(tunnelBuffer, error);
                error.errorId(ret);
                error.text("Unable to encode TunnelStream header");
                return null;
            }
            ret = this._encIter.encodeNonRWFInit(this._tmpBuffer);
            if (ret != 0) {
                this.releaseBuffer(tunnelBuffer, error);
                error.errorId(ret);
                error.text("Unable to encode TunnelStream header");
                return null;
            }
            if (this._tmpBuffer.length() < 1) {
                this.releaseBuffer(tunnelBuffer, error);
                error.errorId(-1);
                error.text("Unable to encode TunnelStream header");
                return null;
            }
            this._tmpBuffer.data().put((byte)1);
            if (this._classOfService.common().streamVersion() >= 2) {
                this._tmpBuffer.data().put((byte)0);
            }
            if ((ret = this._encIter.encodeNonRWFComplete(this._tmpBuffer, true)) != 0) {
                this.releaseBuffer(tunnelBuffer, error);
                error.errorId(ret);
                error.text("Unable to encode TunnelStream header");
                return null;
            }
            ret = this._tunnelStreamHdr.encodeExtendedHeaderComplete(this._encIter, true);
            if (ret < 0) {
                this.releaseBuffer(tunnelBuffer, error);
                error.errorId(ret);
                error.text("Unable to encode TunnelStream header");
                return null;
            }
            tunnelBuffer.tunnelStreamHeaderLen(tunnelBuffer.length());
            tunnelBuffer.setCurrentPositionAsEndOfEncoding();
            tunnelBuffer.setToInnerWriteBuffer();
        }
        return tunnelBuffer;
    }

    TunnelStreamBuffer getBufferForFragmentation(int length, int totalMsgLen, int fragmentNumber, int msgId, int containerType, boolean msgComplete, Error error) {
        TunnelStreamBuffer tunnelBuffer = null;
        tunnelBuffer = this._tunnelStreamBufferPool.pop(TunnelStreamBuffer.RETRANS_LINK);
        if (tunnelBuffer == null) {
            tunnelBuffer = new TunnelStreamBuffer();
        }
        tunnelBuffer.clear(length);
        this._bufferPool.getBufferSlice(tunnelBuffer, length + 128, true);
        if (tunnelBuffer.data() == null) {
            this._tunnelStreamBufferPool.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
            error.errorId(-3);
            error.text("TunnelStream is out of buffers");
            return null;
        }
        this._encIter.clear();
        this._encIter.setBufferAndRWFVersion((TransportBuffer)tunnelBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
        this._tunnelStreamHdr.clear();
        this._tunnelStreamHdr.msgClass(7);
        this._tunnelStreamHdr.streamId(this._channelStreamId);
        this._tunnelStreamHdr.domainType(this.domainType());
        if (totalMsgLen > this._classOfService.common().maxFragmentSize()) {
            this._tunnelStreamHdr.containerType(130);
        } else {
            this._tunnelStreamHdr.containerType(containerType);
        }
        this._tunnelStreamHdr.applyHasExtendedHdr();
        if (msgComplete) {
            this._tunnelStreamHdr.applyMessageComplete();
        }
        this._tunnelStreamHdr.applyHasSeqNum();
        this._tunnelStreamHdr.seqNum((long)this._sendLastSeqNum);
        tunnelBuffer.seqNum(this._sendLastSeqNum);
        int ret = this._tunnelStreamHdr.encodeInit(this._encIter, 0);
        if (ret != 12) {
            this.releaseBuffer(tunnelBuffer, error);
            error.errorId(ret);
            error.text("Unable to encode TunnelStream header");
            return null;
        }
        ret = this._encIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            this.releaseBuffer(tunnelBuffer, error);
            error.errorId(ret);
            error.text("Unable to encode TunnelStream header");
            return null;
        }
        if (this._tmpBuffer.length() < 1) {
            this.releaseBuffer(tunnelBuffer, error);
            error.errorId(-1);
            error.text("Unable to encode TunnelStream header");
            return null;
        }
        this._tmpBuffer.data().put((byte)1);
        if (totalMsgLen > this._classOfService.common().maxFragmentSize()) {
            this._tmpBuffer.data().put((byte)1);
            this._tmpBuffer.data().putInt(totalMsgLen);
            this._tmpBuffer.data().putInt(fragmentNumber);
            this._tmpBuffer.data().putShort((short)msgId);
            this._tmpBuffer.data().put((byte)(containerType - 128));
        } else {
            this._tmpBuffer.data().put((byte)0);
        }
        ret = this._encIter.encodeNonRWFComplete(this._tmpBuffer, true);
        if (ret != 0) {
            this.releaseBuffer(tunnelBuffer, error);
            error.errorId(ret);
            error.text("Unable to encode TunnelStream header");
            return null;
        }
        ret = this._tunnelStreamHdr.encodeExtendedHeaderComplete(this._encIter, true);
        if (ret < 0) {
            this.releaseBuffer(tunnelBuffer, error);
            error.errorId(ret);
            error.text("Unable to encode TunnelStream header");
            return null;
        }
        tunnelBuffer.tunnelStreamHeaderLen(tunnelBuffer.length());
        tunnelBuffer.setCurrentPositionAsEndOfEncoding();
        tunnelBuffer.setToInnerWriteBuffer();
        return tunnelBuffer;
    }

    int submit(TunnelStreamBuffer tunnelBuffer, int containerType, Error error) {
        TunnelSubstream substreamSession = null;
        try {
            if (!this.isStreamOpen()) {
                error.text("TunnelStream is not in the open state");
                error.errorId(-1);
                return -1;
            }
            if (tunnelBuffer.length() > this._classOfService.common().maxMsgSize()) {
                error.errorId(-5);
                error.text("Submitted buffer cannot be larger than maxMsgSize of " + this._classOfService.common().maxMsgSize());
                return -5;
            }
            tunnelBuffer.setCurrentPositionAsEndOfEncoding();
            if (containerType == 141) {
                tunnelBuffer.setAsInnerReadBuffer();
                this._decSubMsgForSubmit.clear();
                if (this.decodeSubstreamMsg(tunnelBuffer, this._decSubMsgForSubmit, error) < 0) {
                    return -8;
                }
                substreamSession = this._streamIdtoQueueSubstreamTable.get(this._decSubMsgForSubmit.streamId());
            }
            if (!tunnelBuffer.isBigBuffer()) {
                tunnelBuffer.setToFullWritebuffer();
            }
            if (substreamSession != null) {
                switch (this._decSubMsgForSubmit.msgClass()) {
                    case 7: {
                        long currentTimeNsec;
                        this._queueData.clear();
                        this._queueData.decode(this._decSubIter, this._decSubMsgForSubmit);
                        if (substreamSession._state != TunnelSubstream.TunnelSubstreamState.OPEN) {
                            error.errorId(-1);
                            error.text("Substream is not in open state");
                            return -1;
                        }
                        if (this._queueData.sourceName().length() > 200) {
                            error.errorId(-5);
                            error.text("sourceName is too long.");
                            return -5;
                        }
                        if (this._queueData.destName().length() > 200) {
                            error.errorId(-5);
                            error.text("destName is too long.");
                            return -5;
                        }
                        tunnelBuffer.containerType(this._queueData.containerType());
                        long timeout = this._queueData.timeout();
                        if (timeout > 0L) {
                            currentTimeNsec = System.nanoTime();
                            tunnelBuffer.timeoutIsCode(false);
                            tunnelBuffer.timeQueuedNsec(currentTimeNsec);
                            tunnelBuffer.timeoutNsec(timeout * 1000000L + currentTimeNsec);
                        } else {
                            currentTimeNsec = 0L;
                            tunnelBuffer.timeoutIsCode(true);
                            tunnelBuffer.timeoutNsec(timeout);
                        }
                        int ret = substreamSession.saveMsg(tunnelBuffer, error);
                        if (ret < 0) {
                            return ret;
                        }
                        if (timeout > 0L) {
                            this.insertTimeoutBuffer(tunnelBuffer, currentTimeNsec);
                            this._reactorChannel.tunnelStreamManager().addTunnelStreamToTimeoutList(this, this._nextTimeoutNsec);
                        } else if (timeout == 0L) {
                            this._outboundImmediateList.push(tunnelBuffer, TunnelStreamBuffer.TIMEOUT_LINK);
                        }
                        tunnelBuffer.isQueueData(true);
                        this._outboundTransmitList.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
                        break;
                    }
                    case 5: {
                        tunnelBuffer.isQueueClose(true);
                        tunnelBuffer.persistenceBuffer(substreamSession, null);
                        this._outboundTransmitList.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
                        this._streamIdtoQueueSubstreamTable.remove(substreamSession._streamId);
                        break;
                    }
                    default: {
                        error.errorId(-1);
                        error.text("Submitted buffer sub MsgClass invalid: " + this._decSubMsgForSubmit.msgClass());
                        return -1;
                    }
                }
                error.text("");
                error.errorId(0);
                if (this.isStreamOpen() || this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN && this._outboundImmediateList.count() > 0) {
                    this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                    return 1;
                }
                return 0;
            }
            if (containerType == 141 && this._classOfService.guarantee().type() == 1 && this._decSubMsgForSubmit.domainType() != 1 && this._decSubMsgForSubmit.domainType() != 4 && this._decSubMsgForSubmit.domainType() != 5 && this._decSubMsgForSubmit.domainType() != 10) {
                if (this._decSubMsgForSubmit.msgClass() == 1) {
                    this._queueRequest.clear();
                    this._queueRequest.decode(this._decSubIter, this._decSubMsgForSubmit);
                    this.releaseBuffer(tunnelBuffer, error);
                    error.text("");
                    error.errorId(0);
                    return this.openSubstream(this._queueRequest, error);
                }
                error.errorId(-1);
                error.text("No Queue open for stream id: " + this._decSubMsgForSubmit.streamId());
                return -1;
            }
            if (this.isProvider() && this._classOfService.authentication().type() == 1 && !this._providerLoginRefreshSent) {
                if (this._decSubMsgForSubmit.domainType() != 1 || this._decSubMsgForSubmit.msgClass() != 2) {
                    error.errorId(-1);
                    error.text("Authentication needs to complete before submitting other data");
                    return -1;
                }
                this._providerLoginRefreshSent = true;
            }
            if (!tunnelBuffer.isBigBuffer()) {
                if (containerType != 141) {
                    tunnelBuffer.setAsFullReadBuffer();
                    tunnelBuffer.data().put(tunnelBuffer.data().position() + 9, (byte)(containerType - 128));
                }
                tunnelBuffer.setToFullWritebuffer();
                this._outboundTransmitList.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
                error.text("");
                error.errorId(0);
                if (this.isStreamOpen()) {
                    this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                    return 1;
                }
                return 0;
            }
            int ret = this.fragmentBuffer((TunnelStreamBigBuffer)tunnelBuffer, containerType, error);
            if (ret == 0) {
                error.text("");
                error.errorId(0);
                if (this.isStreamOpen()) {
                    this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                    ret = 1;
                }
            }
            return ret;
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.submit() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.submit() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
    }

    private int fragmentBuffer(TunnelStreamBigBuffer tunnelBigBuffer, int containerType, Error error) {
        int bytesRemainingToSend;
        int messageId;
        int totalMsgLength = tunnelBigBuffer.length();
        int fragmentNumber = !tunnelBigBuffer.fragmentationInProgress() ? 1 : tunnelBigBuffer.lastFragmentId();
        int n = messageId = !tunnelBigBuffer.fragmentationInProgress() ? this.messageId() : tunnelBigBuffer.messageId();
        if (this._pendingBigBufferList.count() == 0 || tunnelBigBuffer.fragmentationInProgress()) {
            int lengthOfFragment;
            for (bytesRemainingToSend = !tunnelBigBuffer.fragmentationInProgress() ? totalMsgLength : tunnelBigBuffer.bytesRemainingToSend(); bytesRemainingToSend > 0; bytesRemainingToSend -= lengthOfFragment) {
                boolean msgComplete;
                lengthOfFragment = bytesRemainingToSend >= this._classOfService.common().maxFragmentSize() ? this._classOfService.common().maxFragmentSize() : bytesRemainingToSend;
                TunnelStreamBuffer tunnelBuffer = this.getBufferForFragmentation(lengthOfFragment, totalMsgLength, fragmentNumber++, messageId, containerType, msgComplete = bytesRemainingToSend <= this._classOfService.common().maxFragmentSize(), error);
                if (tunnelBuffer != null) {
                    tunnelBuffer.setToFullWritebuffer();
                    tunnelBuffer.data().put(tunnelBigBuffer.data().array(), totalMsgLength - bytesRemainingToSend, lengthOfFragment);
                    tunnelBuffer.setCurrentPositionAsEndOfEncoding();
                    this._outboundTransmitList.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
                    continue;
                }
                tunnelBigBuffer.saveWriteProgress(totalMsgLength, bytesRemainingToSend, fragmentNumber - 1, messageId, containerType);
                if (this._pendingBigBufferList.contains(tunnelBigBuffer, TunnelStreamBigBuffer.BIG_BUFFER_LINK)) break;
                this._pendingBigBufferList.push(tunnelBigBuffer, TunnelStreamBigBuffer.BIG_BUFFER_LINK);
                break;
            }
            if (bytesRemainingToSend == 0) {
                if (this._pendingBigBufferList.count() > 0) {
                    this._pendingBigBufferList.remove(tunnelBigBuffer, TunnelStreamBigBuffer.BIG_BUFFER_LINK);
                }
                this.releaseBuffer(tunnelBigBuffer, error);
            }
        } else {
            tunnelBigBuffer.saveWriteProgress(totalMsgLength, bytesRemainingToSend, fragmentNumber, messageId, containerType);
            if (!this._pendingBigBufferList.contains(tunnelBigBuffer, TunnelStreamBigBuffer.BIG_BUFFER_LINK)) {
                this._pendingBigBufferList.push(tunnelBigBuffer, TunnelStreamBigBuffer.BIG_BUFFER_LINK);
            }
        }
        return 0;
    }

    private int decodeMsg(TunnelStreamBuffer buffer, Error error) {
        this._decIter.clear();
        this._decIter.setBufferAndRWFVersion((TransportBuffer)buffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
        this._decMsg.clear();
        return this._decMsg.decode(this._decIter);
    }

    private int decodeSubstreamMsg(TunnelStreamBuffer buffer, Msg decodeSubMsg, Error error) {
        this._decSubIter.clear();
        this._decSubIter.setBufferAndRWFVersion((TransportBuffer)buffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
        return decodeSubMsg.decode(this._decSubIter);
    }

    int dispatch(Error error) {
        int ret = 0;
        try {
            if (this._writeCallAgainBuffer != null && (ret = this.writeChannelBuffer(this._writeCallAgainBuffer, error)) < 0) {
                return ret;
            }
            int pendingBigBufferListCount = this._pendingBigBufferList.count();
            for (int i = 0; i < pendingBigBufferListCount; ++i) {
                TunnelStreamBigBuffer bigBuffer = this._pendingBigBufferList.peek();
                ret = this.fragmentBuffer(bigBuffer, bigBuffer.containerType(), error);
                if (ret != 0) continue;
                error.text("");
                error.errorId(0);
                if (!this.isStreamOpen()) continue;
                this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
            }
            switch (this._tunnelStreamState) {
                case NOT_OPEN: {
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    if (this._streamOpen && this._reactorChannel.tunnelStreamManager().reactorChannel().channel() != null) {
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_REQUEST;
                    } else {
                        return 0;
                    }
                }
                case SEND_REQUEST: {
                    TransportBuffer tBuffer;
                    TunnelStreamMsg.TunnelStreamRequest requestHeader = (TunnelStreamMsg.TunnelStreamRequest)((Object)this._tunnelStreamMsg);
                    requestHeader.clearRequest();
                    this._tunnelStreamMsg.streamId(this._streamId);
                    this._tunnelStreamMsg.domainType(this._domainType);
                    this._tunnelStreamMsg.serviceId(this._serviceId);
                    if (this._name != null) {
                        this._tunnelStreamMsg.name(this._name);
                    } else {
                        this._tunnelStreamMsg.name("TunnelStream");
                    }
                    if (this._requestRetryCount > 0) {
                        this._classOfService.common().streamVersion(this._classOfService.common().streamVersion() - 1);
                    }
                    this._tunnelStreamMsg.classOfService(this._classOfService);
                    if (this._reactorChannel.watchlist() == null) {
                        tBuffer = this.getChannelBuffer(requestHeader.requestBufferSize(), false, error);
                        if (tBuffer == null) {
                            return error.errorId();
                        }
                        this._encIter.clear();
                        this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                        ret = requestHeader.encodeRequest(this._encIter, (RequestMsg)this._encMsg);
                        if (ret != 0) {
                            error.errorId(ret);
                            error.text("Failed to encode TunnelStream request message.");
                            return -1;
                        }
                        if ((this._traceFlags & 2) > 0) {
                            this.traceBufferToXml(tBuffer);
                        }
                        if ((ret = this.writeChannelBuffer(tBuffer, error)) != 0) {
                            return ret;
                        }
                        if (ret > 0) {
                            this._reactorChannel.tunnelStreamManager().setNeedsFlush();
                        }
                    } else {
                        this._reactorChannel.tunnelStreamManager()._tunnelStreamTempByteBuffer.clear();
                        this._reactorChannel.tunnelStreamManager()._tunnelStreamTempBuffer.data(this._reactorChannel.tunnelStreamManager()._tunnelStreamTempByteBuffer);
                        ret = requestHeader.encodeRequestAsMsg(this._encIter, this._reactorChannel.tunnelStreamManager()._tunnelStreamTempBuffer, (RequestMsg)this._encMsg);
                        if (ret != 0) {
                            error.errorId(ret);
                            error.text("Failed to encode TunnelStream request message.");
                            return -1;
                        }
                        if ((this._traceFlags & 2) > 0) {
                            this.traceMsgtoXml(this._traceMsg, true);
                        }
                        this._reactorSubmitOptions.clear();
                        ret = this._reactorChannel.submit(this._encMsg, this._reactorSubmitOptions, this._errorInfo);
                        if (ret < 0) {
                            this.errorInfoToError(this._errorInfo, error);
                            return ret;
                        }
                    }
                    this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.WAITING_REFRESH;
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    this.startRequestTimer();
                    return 0;
                }
                case WAITING_REFRESH: {
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    return 0;
                }
                case WAITING_AUTHENTICATION: 
                case STREAM_OPEN: {
                    TransportBuffer tBuffer;
                    if (this._recvLastSeqNum != this._recvLastSeqNumAckSent || this._sendNakRangeList.count() > 0) {
                        TunnelStreamMsg.TunnelStreamAck ackHeader = (TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg);
                        ackHeader.clearAck();
                        this._tunnelStreamMsg.streamId(this._channelStreamId);
                        this._tunnelStreamMsg.domainType(this._domainType);
                        ackHeader.seqNum(this._recvLastSeqNum);
                        ackHeader.recvWindow(this._classOfService.flowControl().recvWindowSize());
                        tBuffer = this.getChannelBuffer(ackHeader.ackBufferSize(this._sendNakRangeList), false, error);
                        if (tBuffer == null) {
                            return error.errorId();
                        }
                        this._encIter.clear();
                        this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                        ret = ackHeader.encodeAck(this._encIter, null, this._sendNakRangeList, 0);
                        if (ret != 0) {
                            error.errorId(ret);
                            error.text("Failed to encode TunnelStream ACK message.");
                            this.releaseChannelBuffer(tBuffer, error);
                            return -1;
                        }
                        if ((this._traceFlags & 1) > 0) {
                            System.out.println("<!-- TunnelTrace: Writing ack. Ack state: " + this._recvLastSeqNum + " in, " + this._recvLastSeqNum + " acked in, " + this._sendLastSeqNum + " out, " + this._sendLastSeqNumAcked + " acked out, " + this._classOfService.flowControl().recvWindowSize() + " recvWindow -->");
                        }
                        if ((this._traceFlags & 2) > 0) {
                            this.traceBufferToXml(tBuffer);
                        }
                        if ((ret = this.writeChannelBuffer(tBuffer, error)) != 0) {
                            return ret;
                        }
                        this._recvLastSeqNumAckSent = this._recvLastSeqNum;
                        if (ret > 0) {
                            this._reactorChannel.tunnelStreamManager().setNeedsFlush();
                        }
                        this._sendNakRangeList.count(0);
                    }
                    if (!this._jUnitSkipHandleTransmit) {
                        ret = this.handleTransmit(error);
                        if (ret != 0) {
                            return ret;
                        }
                        if (this._writeCallAgainBuffer != null) {
                            this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                        } else {
                            this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                        }
                    } else {
                        this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    }
                    if (this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.STREAM_OPEN) {
                        this.updateTimeout(System.nanoTime());
                    }
                    return 0;
                }
                case CLOSING: {
                    if (!this.isProvider()) {
                        ret = this.sendCloseMsg(error);
                        this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
                        this._finAckWaitCount = 0;
                        if (this._finalStatusEvent) {
                            if (error.text() == null) {
                                error.text("Completed");
                            }
                            this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                        }
                    } else {
                        ret = this.sendCloseMsg(error);
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
                        this._finAckWaitCount = 0;
                        if (this._finalStatusEvent) {
                            if (error.text() == null) {
                                error.text("Completed");
                            }
                            this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusClose(this, error);
                        }
                    }
                    for (Integer substreamId : this._streamIdtoQueueSubstreamTable.keySet()) {
                        ret = this.closeSubstream(substreamId, error);
                        if (ret == 0) continue;
                        return ret;
                    }
                    this._streamIdtoQueueSubstreamTable.clear();
                    return 0;
                }
                case SEND_FIN: {
                    ret = this.handleTransmit(error);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to handle retransmit");
                        return -1;
                    }
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    long currentTimeNsec = System.nanoTime();
                    this._nextTimeoutNsec = (long)Math.pow(2.0, this._finAckWaitCount) * this.finAckTimeout * 1000000L + currentTimeNsec;
                    TunnelStreamMsg.TunnelStreamAck ackHeader = (TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg);
                    ackHeader.clearAck();
                    this._tunnelStreamMsg.streamId(this._channelStreamId);
                    this._tunnelStreamMsg.domainType(this._domainType);
                    if (this._hasFinSent) {
                        ackHeader.seqNum(this._sendFinSeqNum);
                    } else {
                        this._sendFinSeqNum = ++this._sendLastSeqNum;
                        ackHeader.seqNum(this._sendLastSeqNum);
                        this._hasFinSent = true;
                    }
                    ackHeader.recvWindow(this._classOfService.flowControl().recvWindowSize());
                    TransportBuffer tBuffer = this.getChannelBuffer(ackHeader.ackBufferSize(this._sendNakRangeList), false, error);
                    if (tBuffer == null) {
                        return error.errorId();
                    }
                    this._encIter.clear();
                    this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                    ret = ackHeader.encodeAck(this._encIter, null, null, this._ackOpcodeFin);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to encode TunnelStream ACK message.");
                        this.releaseChannelBuffer(tBuffer, error);
                        return -1;
                    }
                    this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.WAIT_FIN_ACK;
                    ret = this.writeChannelBuffer(tBuffer, error);
                    if (ret != 0) {
                        return ret;
                    }
                    return 0;
                }
                case SEND_FIN_ACK: {
                    ret = this.handleTransmit(error);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to handle retransmit");
                        return -1;
                    }
                    if (!this.isSendWindowOpen(null)) {
                        return 0;
                    }
                    TunnelStreamMsg.TunnelStreamAck ackHeader = (TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg);
                    ackHeader.clearAck();
                    this._tunnelStreamMsg.streamId(this._channelStreamId);
                    this._tunnelStreamMsg.domainType(this._domainType);
                    ackHeader.seqNum(this._recvLastSeqNum);
                    ackHeader.recvWindow(this._classOfService.flowControl().recvWindowSize());
                    TransportBuffer tBuffer = this.getChannelBuffer(ackHeader.ackBufferSize(this._sendNakRangeList), false, error);
                    if (tBuffer == null) {
                        return error.errorId();
                    }
                    this._encIter.clear();
                    this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                    ret = ackHeader.encodeAck(this._encIter, null, this._sendNakRangeList, 0);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to encode TunnelStream ACK message.");
                        this.releaseChannelBuffer(tBuffer, error);
                        return -1;
                    }
                    ret = this.writeChannelBuffer(tBuffer, error);
                    if (ret != 0) {
                        return ret;
                    }
                    ackHeader = (TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg);
                    ackHeader.clearAck();
                    this._tunnelStreamMsg.streamId(this._channelStreamId);
                    this._tunnelStreamMsg.domainType(this._domainType);
                    if (this._hasFinSent) {
                        ackHeader.seqNum(this._sendFinSeqNum);
                    } else {
                        this._sendFinSeqNum = ++this._sendLastSeqNum;
                        ackHeader.seqNum(this._sendLastSeqNum);
                        this._hasFinSent = true;
                    }
                    ackHeader.recvWindow(this._classOfService.flowControl().recvWindowSize());
                    tBuffer = this.getChannelBuffer(ackHeader.ackBufferSize(this._sendNakRangeList), false, error);
                    if (tBuffer == null) {
                        return error.errorId();
                    }
                    this._encIter.clear();
                    this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                    ret = ackHeader.encodeAck(this._encIter, null, null, this._ackOpcodeFin);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to encode TunnelStream ACK message.");
                        this.releaseChannelBuffer(tBuffer, error);
                        return -1;
                    }
                    this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.WAIT_FINAL_FIN_ACK;
                    ret = this.writeChannelBuffer(tBuffer, error);
                    if (ret != 0) {
                        return ret;
                    }
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    long currentTimeNsec = System.nanoTime();
                    this._finAckWaitCount = 0;
                    this._nextTimeoutNsec = (long)Math.pow(2.0, this._finAckWaitCount) * this.finAckTimeout * 1000000L + currentTimeNsec;
                    this._reactorChannel.tunnelStreamManager().addTunnelStreamToTimeoutList(this, this._nextTimeoutNsec);
                    return 0;
                }
                case SEND_FINAL_FIN: {
                    ret = this.handleTransmit(error);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to handle retransmit");
                        return -1;
                    }
                    if (!this.isSendWindowOpen(null)) {
                        return 0;
                    }
                    TunnelStreamMsg.TunnelStreamAck ackHeader = (TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg);
                    ackHeader.clearAck();
                    this._tunnelStreamMsg.streamId(this._channelStreamId);
                    this._tunnelStreamMsg.domainType(this._domainType);
                    if (this._hasFinSent) {
                        ackHeader.seqNum(this._sendFinSeqNum);
                    } else {
                        ackHeader.seqNum(this._sendLastSeqNum);
                    }
                    ackHeader.recvWindow(this._classOfService.flowControl().recvWindowSize());
                    TransportBuffer tBuffer = this.getChannelBuffer(ackHeader.ackBufferSize(this._sendNakRangeList), false, error);
                    if (tBuffer == null) {
                        return error.errorId();
                    }
                    this._encIter.clear();
                    this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                    ret = ackHeader.encodeAck(this._encIter, null, null, this._ackOpcodeFin);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to encode TunnelStream ACK message.");
                        this.releaseChannelBuffer(tBuffer, error);
                        return -1;
                    }
                    this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.WAIT_FINAL_FIN_ACK;
                    ret = this.writeChannelBuffer(tBuffer, error);
                    if (ret != 0) {
                        return ret;
                    }
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                    long currentTimeNsec = System.nanoTime();
                    this._nextTimeoutNsec = (long)Math.pow(2.0, this._finAckWaitCount) * this.finAckTimeout * 1000000L + currentTimeNsec;
                    this._reactorChannel.tunnelStreamManager().addTunnelStreamToTimeoutList(this, this._nextTimeoutNsec);
                    return 0;
                }
                case SEND_FINAL_FIN_ACK_AND_CLOSING: {
                    ret = this.handleTransmit(error);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to handle retransmit");
                        return -1;
                    }
                    if (!this.isSendWindowOpen(null)) {
                        return 0;
                    }
                    TunnelStreamMsg.TunnelStreamAck ackHeader = (TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg);
                    ackHeader.clearAck();
                    this._tunnelStreamMsg.streamId(this._channelStreamId);
                    this._tunnelStreamMsg.domainType(this._domainType);
                    ackHeader.seqNum(this._receivedFinalFinSeqNum);
                    ackHeader.recvWindow(this._classOfService.flowControl().recvWindowSize());
                    TransportBuffer tBuffer = this.getChannelBuffer(ackHeader.ackBufferSize(this._sendNakRangeList), false, error);
                    if (tBuffer == null) {
                        return error.errorId();
                    }
                    this._encIter.clear();
                    this._encIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                    ret = ackHeader.encodeAck(this._encIter, null, this._sendNakRangeList, 0);
                    if (ret != 0) {
                        error.errorId(ret);
                        error.text("Failed to encode TunnelStream ACK message.");
                        this.releaseChannelBuffer(tBuffer, error);
                        return -1;
                    }
                    ret = this.writeChannelBuffer(tBuffer, error);
                    if (ret != 0) {
                        return ret;
                    }
                    if (!this.isProvider()) {
                        ret = this.sendCloseMsg(error);
                        this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromDispatchList(this);
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
                        this._finAckWaitCount = 0;
                        if (this._finalStatusEvent) {
                            this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                        } else {
                            this._reactorChannel.tunnelStreamManager().removeTunnelStream(this);
                        }
                        return 0;
                    }
                    ret = this.sendCloseMsg(error);
                    this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
                    this._finAckWaitCount = 0;
                    if (this._finalStatusEvent) {
                        this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusClose(this, error);
                    } else {
                        this._reactorChannel.tunnelStreamManager().removeTunnelStream(this);
                    }
                    return 0;
                }
                case WAIT_FIN_ACK: {
                    long currentTimeNsec = System.nanoTime();
                    if (currentTimeNsec > this.nextTimeoutNsec()) {
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_FIN;
                        ++this._finAckWaitCount;
                        this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromTimeoutList(this);
                        if (this._finAckWaitCount > this._max_num_timeout_retry) {
                            this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.CLOSING;
                        }
                    }
                    return 0;
                }
                case WAIT_FINAL_FIN_ACK: {
                    long currentTimeNsec = System.nanoTime();
                    if (currentTimeNsec > this.nextTimeoutNsec()) {
                        this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromTimeoutList(this);
                        ++this._finAckWaitCount;
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_FINAL_FIN;
                        if (this._finAckWaitCount > this._max_num_timeout_retry) {
                            this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.CLOSING;
                        }
                    }
                    return 0;
                }
            }
            error.errorId(-1);
            error.text("Unknown state.");
            return -1;
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.dispatch() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.dispatch() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
    }

    public void startRequestTimer() {
        this._nextTimeoutNsec = (long)this._responseTimeout * 1000000000L + System.nanoTime();
        this._reactorChannel.tunnelStreamManager().addTunnelStreamToTimeoutList(this, this._nextTimeoutNsec);
    }

    int handleTransmit(Error error) {
        TunnelStreamBuffer tunnelBuffer;
        int ret = 0;
        while ((tunnelBuffer = this._outboundTransmitList.peek()) != null && this._writeCallAgainBuffer == null && this.isSendWindowOpen(tunnelBuffer)) {
            if (tunnelBuffer.isRetransmit()) {
                assert (tunnelBuffer.isTransmitted());
                tunnelBuffer.setToFullWritebuffer();
                if (this.decodeMsg(tunnelBuffer, error) < 0) {
                    return -8;
                }
                this._decMsg.extendedHeader().data().put(this._decMsg.extendedHeader().position(), (byte)3);
            } else if (!tunnelBuffer.isTransmitted()) {
                if (tunnelBuffer.tunnelSubstream() != null) {
                    if (tunnelBuffer.isQueueData()) {
                        ret = tunnelBuffer.tunnelSubstream().setBufferAsTransmitted(tunnelBuffer, error);
                        if (ret != 0) {
                            return ret;
                        }
                        tunnelBuffer.isTransmitted(true);
                        if (!tunnelBuffer.timeoutIsCode()) {
                            this._outboundTimeoutList.remove(tunnelBuffer, TunnelStreamBuffer.TIMEOUT_LINK);
                        } else if (tunnelBuffer.timeoutNsec() == 0L) {
                            this._outboundImmediateList.remove(tunnelBuffer, TunnelStreamBuffer.TIMEOUT_LINK);
                        }
                    } else if (tunnelBuffer.isQueueClose()) {
                        ret = tunnelBuffer.tunnelSubstream().close(error);
                        if (ret != 0) {
                            return ret;
                        }
                        tunnelBuffer.persistenceBuffer(null, null);
                    }
                }
                ++this._sendLastSeqNum;
                tunnelBuffer.seqNum(this._sendLastSeqNum);
                tunnelBuffer.setAsFullReadBuffer();
                this._encIter.clear();
                this._encIter.setBufferAndRWFVersion((TransportBuffer)tunnelBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                ret = this._encIter.replaceSeqNum((long)tunnelBuffer.seqNum());
                if (ret != 0) {
                    error.errorId(ret);
                    error.text("Failed to update sequence number on TunnelStream header.");
                    return -1;
                }
            }
            tunnelBuffer.setToFullWritebuffer();
            TransportBuffer tBuffer = this.getChannelBuffer(tunnelBuffer.length(), false, error);
            if (tBuffer == null) {
                return error.errorId();
            }
            tunnelBuffer.copyFullBuffer(tBuffer.data());
            if ((this._traceFlags & 1) > 0) {
                System.out.printf("<!-- TunnelTrace: Writing message sentBytes: %d -->\n", this._sendBytes);
            }
            if ((this._traceFlags & 2) > 0) {
                this.traceBufferToXml(tBuffer);
            }
            if ((ret = this.writeChannelBuffer(tBuffer, error)) != 0) {
                return ret;
            }
            this._sendBytes += tunnelBuffer.innerWriteBufferLength();
            this._outboundTransmitList.remove(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
            this._outboundMsgAckList.push(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
            error.text("");
            error.errorId(0);
        }
        return ret;
    }

    int sendCloseMsg(Error error) {
        TunnelStreamStateInfo.TunnelStreamState tunnelStreamState = this._tunnelStreamState;
        int ret = this.streamClosed(error);
        if (ret != 0) {
            return ret;
        }
        if (tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.SEND_REQUEST || tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN) {
            return 0;
        }
        this._encMsg.clear();
        this._encMsg.streamId(this._streamId);
        this._encMsg.domainType(this._domainType);
        if (!this.isProvider()) {
            this._encMsg.msgClass(5);
            this._encMsg.containerType(128);
        } else {
            this._encMsg.msgClass(3);
            this._encMsg.containerType(128);
            StatusMsg statusMsg = (StatusMsg)this._encMsg;
            statusMsg.applyPrivateStream();
            statusMsg.applyQualifiedStream();
            statusMsg.applyHasMsgKey();
            statusMsg.msgKey().applyHasServiceId();
            statusMsg.msgKey().serviceId(this.serviceId());
            statusMsg.msgKey().applyHasName();
            statusMsg.msgKey().name().data(this.name());
            statusMsg.applyHasState();
            statusMsg.state().streamState(4);
            statusMsg.state().dataState(2);
            statusMsg.state().code(0);
            statusMsg.state().text().data("VAProvider TunnelStream Closed");
        }
        if ((this._traceFlags & 2) > 0) {
            this.traceMsgtoXml(this._traceMsg, true);
        }
        this._reactorSubmitOptions.clear();
        ret = this._reactorChannel.submit(this._encMsg, this._reactorSubmitOptions, this._errorInfo);
        if (ret < 0) {
            this.errorInfoToError(this._errorInfo, error);
            return ret;
        }
        return 0;
    }

    int encodeTunnelStreamHeaderInit(EncodeIterator eIter, int seqNum) {
        this._tunnelStreamHdr.clear();
        this._tunnelStreamHdr.msgClass(7);
        this._tunnelStreamHdr.streamId(this._channelStreamId);
        this._tunnelStreamHdr.domainType(this._domainType);
        this._tunnelStreamHdr.containerType(141);
        this._tunnelStreamHdr.applyHasExtendedHdr();
        this._tunnelStreamHdr.applyMessageComplete();
        this._tunnelStreamHdr.applyHasSeqNum();
        this._tunnelStreamHdr.seqNum((long)seqNum);
        int ret = this._tunnelStreamHdr.encodeInit(eIter, 0);
        if (ret != 12) {
            return ret;
        }
        ret = eIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            return ret;
        }
        if (this._tmpBuffer.length() < 1) {
            return ret;
        }
        this._tmpBuffer.data().put((byte)1);
        ret = eIter.encodeNonRWFComplete(this._tmpBuffer, true);
        if (ret != 0) {
            return ret;
        }
        ret = this._tunnelStreamHdr.encodeExtendedHeaderComplete(eIter, true);
        if (ret < 0) {
            return ret;
        }
        return 0;
    }

    private void dumpTimestamp() {
        System.out.println("<!-- " + this._traceDateFormat.format(Calendar.getInstance().getTime()) + " (UTC) -->");
    }

    void traceBufferToXml(TransportBuffer tBuffer) {
        assert ((this._traceFlags & 2) > 0);
        this.dumpTimestamp();
        this._traceIter.clear();
        this._traceIter.setBufferAndRWFVersion(tBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
        int ret = this._traceMsg.decode(this._traceIter);
        if (ret != 0) {
            System.out.printf("<!-- TunnelTrace: Failed to decode message (%d) -->\n", ret);
            return;
        }
        this.traceMsgtoXml(this._traceMsg, false);
    }

    void traceMsgtoXml(Msg msg, boolean timestamp) {
        assert ((this._traceFlags & 2) > 0);
        if (timestamp) {
            this.dumpTimestamp();
        }
        if (msg.msgClass() == 7) {
            this._traceIter.clear();
            int ret = this._tunnelStreamMsg.decode(this._traceIter, (GenericMsg)msg, this._traceAckRangeList, this._traceNakRangeList);
            if (ret != 0) {
                System.out.printf("<!-- TunnelTrace: Failed to decode stream header (%d) -->\n", ret);
            } else {
                System.out.print(this._tunnelStreamMsg.xmlDumpBegin(this._traceAckRangeList, this._traceNakRangeList));
                switch (this._tunnelStreamMsg.opCode()) {
                    case 1: 
                    case 3: {
                        this._traceIter.clear();
                        this._traceIter.setBufferAndRWFVersion(msg.encodedDataBody(), this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                        ret = this._traceSubMsg.decode(this._traceIter);
                        if (ret < 0) {
                            System.out.printf("<!-- TunnelTrace: Failed to decode stream header (%d) -->\n", ret);
                            break;
                        }
                        QueueMsg queueSubHeader = this.substreamBind(this._traceSubMsg);
                        if (queueSubHeader == null) {
                            System.out.printf("<!-- TunnelTrace: Failed to decode substream header, unrecognized opCode", new Object[0]);
                            return;
                        }
                        ret = queueSubHeader.decode(this._traceIter, this._traceSubMsg);
                        if (ret != 0) {
                            System.out.printf("<!-- TunnelTrace: Failed to decode substream header (%d) -->\n", ret);
                            break;
                        }
                        System.out.print("    " + ((QueueMsgImpl)queueSubHeader).xmlDump());
                        break;
                    }
                }
                System.out.println(this._tunnelStreamMsg.xmlDumpEnd());
            }
        }
        if ((this._traceFlags & 4) > 0) {
            this._traceIter.clear();
            this._traceIter.setBufferAndRWFVersion(msg.encodedMsgBuffer(), this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
            System.out.println("<!-- TunnelTrace: Full message: -->");
            System.out.println(this._traceSubMsg.decodeToXml(this._traceIter));
        } else {
            System.out.println();
        }
    }

    int readMsg(Msg deliveredMsg, Error error) {
        try {
            int ret;
            if ((this._traceFlags & 1) > 0) {
                System.out.println("<!-- TunnelTrace: Received message, state(" + this._state.toString() + ") -->");
            }
            if ((this._traceFlags & 2) > 0) {
                this.traceMsgtoXml(deliveredMsg, true);
            }
            if (deliveredMsg.msgClass() == 7) {
                this._decIter.clear();
                this._tunnelStreamMsg.classOfService(this._classOfService);
                ret = this._tunnelStreamMsg.decode(this._decIter, (GenericMsg)deliveredMsg, this._recvAckRangeList, this._recvNakRangeList);
                if (ret != 0) {
                    error.errorId(ret);
                    error.text("Failed to decode TunnelStream header");
                    return -1;
                }
            }
            switch (this._tunnelStreamState) {
                case NOT_OPEN: {
                    return 0;
                }
                case WAITING_REFRESH: {
                    State state;
                    switch (deliveredMsg.msgClass()) {
                        case 2: {
                            state = ((RefreshMsg)deliveredMsg).state();
                            break;
                        }
                        case 3: {
                            state = ((StatusMsg)deliveredMsg).state();
                            break;
                        }
                        default: {
                            error.errorId(-1);
                            error.text("Received unexpected MsgClass " + deliveredMsg.msgClass() + " while establishing stream.");
                            return -1;
                        }
                    }
                    switch (state.streamState()) {
                        case 1: {
                            if (state.dataState() == 1) break;
                            return 0;
                        }
                        default: {
                            error.errorId(-1);
                            error.text("Received non-open stream state (" + state.toString() + ")");
                            return -1;
                        }
                    }
                    if ((this._traceFlags & 1) > 0) {
                        System.out.println("<!-- TunnelTrace: Stream " + deliveredMsg.streamId() + " established, opening substream -->");
                    }
                    this._recvLastSeqNumAckSent = this._recvLastSeqNum;
                    this._tunnelStreamState = this._classOfService.authentication().type() == 1 ? TunnelStreamStateInfo.TunnelStreamState.WAITING_AUTHENTICATION : TunnelStreamStateInfo.TunnelStreamState.STREAM_OPEN;
                    this._nextTimeoutNsec = 0L;
                    this._reactorChannel.tunnelStreamManager().removeTunnelStreamFromTimeoutList(this);
                    this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                    return 0;
                }
                case WAITING_AUTHENTICATION: 
                case STREAM_OPEN: 
                case SEND_FIN: 
                case SEND_FIN_ACK: 
                case WAIT_FIN_ACK: 
                case WAIT_FINAL_FIN_ACK: {
                    if (deliveredMsg.msgClass() == 5) {
                        if (this.isProvider()) {
                            if (this._finalStatusEvent) {
                                this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusClose(this, error);
                            }
                        } else if (this._finalStatusEvent) {
                            this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                        }
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
                        this._finAckWaitCount = 0;
                        this._reactorChannel.tunnelStreamManager().removeTunnelStream(this);
                    }
                    if (deliveredMsg.msgClass() != 7) {
                        error.errorId(-1);
                        error.text("Unhandled message class: " + deliveredMsg.msgClass());
                        return -1;
                    }
                    switch (this._tunnelStreamMsg.opCode()) {
                        case 1: 
                        case 3: {
                            TunnelSubstream substreamSession = null;
                            TunnelStreamMsg.TunnelStreamData dataHeader = (TunnelStreamMsg.TunnelStreamData)((Object)this._tunnelStreamMsg);
                            int seqCompare = TunnelStreamUtil.seqNumCompare(dataHeader.seqNum(), this._recvLastSeqNum);
                            if (seqCompare != 1) {
                                if (seqCompare <= 0) {
                                    if ((this._traceFlags & 1) > 0) {
                                        System.out.println("<!-- TunnelTrace: Discarding duplicate/old message (SeqNum: " + dataHeader.seqNum() + " vs. expected " + (this._recvLastSeqNum + 1) + "-->");
                                    }
                                    error.errorId(0);
                                    return 0;
                                }
                                if ((this._traceFlags & 1) > 0) {
                                    System.out.println("<!-- TunnelTrace: Message indicates gap (SeqNum: " + dataHeader.seqNum() + " vs. expected " + (this._recvLastSeqNum + 1) + "-->");
                                }
                                this._sendNakRangeList.rangeArray()[0] = this._recvLastSeqNum + 1;
                                if (dataHeader.seqNum() > this._sendLastSeqNumNaked) {
                                    this._sendLastSeqNumNaked = dataHeader.seqNum();
                                }
                                this._sendNakRangeList.rangeArray()[1] = this._sendLastSeqNumNaked;
                                this._sendNakRangeList.count(1);
                                this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                                error.errorId(0);
                                return 0;
                            }
                            this._recvLastSeqNum = dataHeader.seqNum();
                            this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                            this._decSubMsg.clear();
                            if (deliveredMsg.containerType() == 141) {
                                this._decIter.clear();
                                this._decIter.setBufferAndRWFVersion(deliveredMsg.encodedDataBody(), this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                                ret = this._decSubMsg.decode(this._decIter);
                                if (ret < 0) {
                                    error.errorId(ret);
                                    error.text("Failed to decode stream header (" + ret + ")");
                                    return -1;
                                }
                                substreamSession = this._streamIdtoQueueSubstreamTable.get(this._decSubMsg.streamId());
                            }
                            if (substreamSession != null) {
                                return substreamSession.readMsg(deliveredMsg, error);
                            }
                            if (!this.isProvider()) {
                                if (this._classOfService.authentication().type() == 1 && this._decSubMsg.domainType() == 1) {
                                    if (this._decSubMsg.msgClass() == 2) {
                                        this._loginMsg.clear();
                                        this._loginMsg.rdmMsgType(LoginMsgType.REFRESH);
                                        this._loginMsg.decode(this._decIter, this._decSubMsg);
                                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.STREAM_OPEN;
                                        this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatus(this, ((RefreshMsg)this._decSubMsg).state(), this._decSubMsg, this._loginMsg);
                                        return 0;
                                    }
                                    if (this._decSubMsg.msgClass() != 3) break;
                                    ret = 0;
                                    State state = null;
                                    if (((StatusMsg)this._decSubMsg).checkHasState()) {
                                        state = ((StatusMsg)this._decSubMsg).state();
                                    }
                                    this._loginMsg.clear();
                                    this._loginMsg.rdmMsgType(LoginMsgType.STATUS);
                                    this._loginMsg.decode(this._decIter, this._decSubMsg);
                                    this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatus(this, state, this._decSubMsg, this._loginMsg);
                                    if (state != null && (state.streamState() == 4 || state.streamState() == 3)) {
                                        ret = this.sendCloseMsg(error);
                                    }
                                    return ret;
                                }
                                TunnelStreamBuffer buffer = this.getBuffer(deliveredMsg.encodedDataBody().length(), false, false, error);
                                if (buffer != null) {
                                    deliveredMsg.encodedDataBody().copy(buffer.data());
                                    ret = 0;
                                    ret = (((TunnelStreamMsgImpl)this._tunnelStreamMsg).dataMsgFlag() & 1) == 0 ? this.msgReceived(buffer, deliveredMsg.containerType() == 141 ? this._decSubMsg : null, deliveredMsg.containerType()) : this.handleTunnelStreamFragmentedMsg(dataHeader, buffer.data(), dataHeader.containerType(), this._errorInfo);
                                    this.releaseBuffer(buffer, error);
                                    return ret;
                                }
                                return error.errorId();
                            }
                            TunnelStreamBuffer buffer = this.getBuffer(deliveredMsg.encodedDataBody().length(), false, false, error);
                            if (buffer != null) {
                                deliveredMsg.encodedDataBody().copy(buffer.data());
                                ret = 0;
                                ret = (((TunnelStreamMsgImpl)this._tunnelStreamMsg).dataMsgFlag() & 1) == 0 ? this.msgReceived(buffer, deliveredMsg.containerType() == 141 ? this._decSubMsg : null, deliveredMsg.containerType()) : this.handleTunnelStreamFragmentedMsg(dataHeader, buffer.data(), dataHeader.containerType(), this._errorInfo);
                                this.releaseBuffer(buffer, error);
                                return ret;
                            }
                            return error.errorId();
                        }
                        case 2: {
                            ret = this.processAck((TunnelStreamMsg.TunnelStreamAck)((Object)this._tunnelStreamMsg), this._recvAckRangeList, this._recvNakRangeList, error);
                            if (ret != 0) {
                                return ret;
                            }
                            if (this._outboundTransmitList.peek() != null) {
                                this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                            }
                            error.errorId(0);
                            return 0;
                        }
                        default: {
                            error.errorId(-1);
                            error.text("Received unhandled TunnelStream header op code " + this._tunnelStreamMsg.opCode() + " while establishing substream.");
                            return -1;
                        }
                    }
                    return 0;
                }
                case CLOSING: {
                    if (deliveredMsg.msgClass() == 5) {
                        if (this.isProvider()) {
                            if (this._finalStatusEvent) {
                                this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusClose(this, error);
                            }
                        } else if (this._finalStatusEvent) {
                            this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                        }
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.NOT_OPEN;
                        this._finAckWaitCount = 0;
                        this._reactorChannel.tunnelStreamManager().removeTunnelStream(this);
                    }
                    return 0;
                }
            }
            error.errorId(-1);
            error.text("Unknown TunnelStream state.");
            return -1;
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.readMsg() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.readMsg() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
    }

    int processAck(TunnelStreamMsg.TunnelStreamAck ackHeader, AckRangeList ackRangeList, AckRangeList nakRangeList, Error error) {
        try {
            if ((ackHeader.flag() & this._ackOpcodeFin) > 0) {
                int seqCompare = TunnelStreamUtil.seqNumCompare(ackHeader.seqNum(), this._recvLastSeqNum);
                if (seqCompare == 1) {
                    this._recvLastSeqNum = ackHeader.seqNum();
                }
                this._classOfService.flowControl().sendWindowSize(ackHeader.recvWindow());
                if (this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.WAIT_FIN_ACK) {
                    this._receivedFinalFin = true;
                    if (TunnelStreamUtil.seqNumCompare(ackHeader.seqNum(), this._receivedFinalFinSeqNum) > 0) {
                        this._receivedFinalFinSeqNum = ackHeader.seqNum();
                        if (this._receivedFinAck && this._receivedFinalFin) {
                            for (Integer substreamId : this._streamIdtoQueueSubstreamTable.keySet()) {
                                int ret = this.closeSubstream(substreamId, error);
                                if (ret == 0) continue;
                                return ret;
                            }
                            this._streamIdtoQueueSubstreamTable.clear();
                            this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_FINAL_FIN_ACK_AND_CLOSING;
                        }
                    }
                } else if (this.isStreamOpen() || this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.SEND_REQUEST || this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.WAITING_REFRESH || this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.WAIT_FINAL_FIN_ACK) {
                    this._finAckWaitCount = 0;
                    this._sendFinSeqNum = -1;
                    this._hasFinSent = false;
                    if (TunnelStreamUtil.seqNumCompare(ackHeader.seqNum(), this._receivedLastFinSeqNum) > 0) {
                        this._receivedLastFinSeqNum = ackHeader.seqNum();
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_FIN_ACK;
                        if (this._finalStatusEvent) {
                            this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusPendingClose(this, error);
                        }
                    }
                } else {
                    System.out.println("Unkown FIN/ACK flag ");
                    return 0;
                }
                this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
            } else {
                TunnelStreamBuffer buffer;
                this._classOfService.flowControl().sendWindowSize(ackHeader.recvWindow());
                if (TunnelStreamUtil.seqNumCompare(ackHeader.seqNum(), this._sendLastSeqNumAcked) > 0) {
                    this._sendLastSeqNumAcked = ackHeader.seqNum();
                    if (this._sendLastSeqNumAcked == this._sendFinSeqNum) {
                        this._receivedFinAck = true;
                    }
                    if (this._receivedFinAck && this._receivedFinalFin) {
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_FINAL_FIN_ACK_AND_CLOSING;
                        for (Integer substreamId : this._streamIdtoQueueSubstreamTable.keySet()) {
                            int ret = this.closeSubstream(substreamId, error);
                            if (ret == 0) continue;
                            return ret;
                        }
                        this._streamIdtoQueueSubstreamTable.clear();
                        this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                    }
                    if (this._tunnelStreamState == TunnelStreamStateInfo.TunnelStreamState.WAIT_FINAL_FIN_ACK) {
                        this._finAckWaitCount = 0;
                        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.CLOSING;
                    }
                }
                if (TunnelStreamUtil.seqNumCompare(this._sendLastSeqNumAcked, this._sendLastSeqNum) > 0) {
                    this._sendLastSeqNumAcked = this._sendLastSeqNum;
                }
                while ((buffer = this._outboundMsgAckList.peek()) != null && TunnelStreamUtil.seqNumCompare(buffer.seqNum(), this._sendLastSeqNumAcked) <= 0) {
                    this.freeAckedWriteBuffer(buffer);
                }
                if (ackRangeList.count() > 0) {
                    int[] ackRanges = ackRangeList.rangeArray();
                    buffer = this._outboundMsgAckList.start(TunnelStreamBuffer.RETRANS_LINK);
                    for (int i = 0; i < ackRangeList.count() * 2; i += 2) {
                        while (buffer != null && buffer.seqNum() <= ackRanges[i + 1]) {
                            if (buffer.seqNum() >= ackRanges[i]) {
                                this.freeAckedWriteBuffer(buffer);
                            }
                            buffer = this._outboundMsgAckList.forth(TunnelStreamBuffer.RETRANS_LINK);
                        }
                    }
                }
                if (nakRangeList.count() > 0) {
                    int[] nakRanges = nakRangeList.rangeArray();
                    buffer = this._outboundMsgAckList.start(TunnelStreamBuffer.RETRANS_LINK);
                    for (int i = 0; i < nakRangeList.count() * 2; i += 2) {
                        while (buffer != null && buffer.seqNum() <= nakRanges[i + 1]) {
                            if (buffer.seqNum() >= nakRanges[i]) {
                                this._sendBytes -= buffer.innerWriteBufferLength();
                                buffer.isRetransmit(true);
                                this._outboundMsgAckList.remove(buffer, TunnelStreamBuffer.RETRANS_LINK);
                                this._outboundTransmitList.push(buffer, TunnelStreamBuffer.RETRANS_LINK);
                            } else {
                                this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                            }
                            buffer = this._outboundMsgAckList.forth(TunnelStreamBuffer.RETRANS_LINK);
                        }
                    }
                }
                if (this.isSendWindowOpen(null) && this._outboundTransmitList.peek() != null) {
                    this.tunnelStreamManager().addTunnelStreamToDispatchList(this);
                }
            }
        }
        catch (Exception e) {
            error.errorId(-1);
            error.text("TunnelStream.processAck() Exception: " + e.getLocalizedMessage());
            return -1;
        }
        catch (InternalError e) {
            error.errorId(-1);
            error.text("TunnelStream.processAck() InternalError: " + e.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    void freeAckedWriteBuffer(TunnelStreamBuffer buffer) {
        this._sendBytes -= buffer.innerWriteBufferLength();
        if (buffer.isApplicationBuffer()) {
            --this._outboundUnackedAppMsgCount;
        }
        this._outboundMsgAckList.remove(buffer, TunnelStreamBuffer.RETRANS_LINK);
        this.releaseBuffer(buffer, this._errorInfo.error());
    }

    boolean isSendWindowOpen(TunnelStreamBuffer buffer) {
        boolean retVal = true;
        if (this._classOfService.flowControl().type() == 1) {
            if (this._firstIsSendWindowOpenCall) {
                this._firstIsSendWindowOpenCall = false;
                if (this._classOfService.authentication().type() == 1) {
                    return retVal;
                }
            }
            return this._sendBytes + (buffer != null ? buffer.innerWriteBufferLength() : 0) <= this._classOfService.flowControl().sendWindowSize();
        }
        return retVal;
    }

    TransportBuffer getChannelBuffer(int length, boolean packedBuffer, Error error) {
        assert (this._reactorChannel.tunnelStreamManager().reactorChannel().channel() != null);
        Channel channel = this._reactorChannel.tunnelStreamManager().reactorChannel().channel();
        TransportBuffer tBuffer = null;
        while ((tBuffer = channel.getBuffer(length, packedBuffer, error)) == null) {
            if (error.errorId() != -3) {
                error.errorId(-7);
                return null;
            }
            this._chnlInfo.clear();
            if (channel.info(this._chnlInfo, error) < 0) {
                error.errorId(-7);
                return null;
            }
            int newNumberOfBuffers = this._chnlInfo.guaranteedOutputBuffers() + 10;
            if (channel.ioctl(2, newNumberOfBuffers, error) >= 0) continue;
            error.errorId(-7);
            return null;
        }
        return tBuffer;
    }

    int releaseChannelBuffer(TransportBuffer buffer, Error error) {
        assert (this._reactorChannel.tunnelStreamManager().reactorChannel().channel() != null);
        Channel channel = this._reactorChannel.tunnelStreamManager().reactorChannel().channel();
        return channel.releaseBuffer(buffer, error);
    }

    int writeChannelBuffer(TransportBuffer tBuffer, Error error) {
        assert (this._reactorChannel.tunnelStreamManager().reactorChannel().channel() != null);
        Channel channel = this._reactorChannel.tunnelStreamManager().reactorChannel().channel();
        if (this.xmlTracing()) {
            this._xmlIter.clear();
            this._xmlIter.setBufferAndRWFVersion(tBuffer, this.reactorChannel().channel().majorVersion(), this.reactorChannel().channel().minorVersion());
            System.out.print("\n<!-- Outgoing Reactor message -->\n");
            System.out.print("<!-- " + channel.selectableChannel().toString() + " -->\n");
            System.out.print("<!-- " + new Date() + " -->");
            System.out.println(this._xmlMsg.decodeToXml(this._xmlIter, null));
        }
        this._writeArgs.clear();
        int ret = channel.write(tBuffer, this._writeArgs, error);
        if (ret > 0) {
            this._reactorChannel.tunnelStreamManager().setNeedsFlush();
            this._writeCallAgainBuffer = null;
            return 0;
        }
        switch (ret) {
            case 0: {
                this._writeCallAgainBuffer = null;
                return 0;
            }
            case -10: {
                this._writeCallAgainBuffer = tBuffer;
                this._reactorChannel.tunnelStreamManager().setNeedsFlush();
                return 0;
            }
        }
        channel.releaseBuffer(tBuffer, error);
        return -7;
    }

    int enableTrace(int traceFlags) {
        this._traceFlags = traceFlags;
        return 0;
    }

    int getStateInfo(TunnelStreamStateInfo info) {
        try {
            info.set(this._tunnelStreamState, this._outboundTransmitList.count(), this._outboundMsgAckList.count(), this._classOfService.flowControl().sendWindowSize() - this._sendBytes, this._classOfService.flowControl().recvWindowSize() - this._recvBytes);
        }
        catch (Exception e) {
            return -1;
        }
        catch (InternalError e) {
            return -1;
        }
        return 0;
    }

    int handleTimer(long currentTimeNsec, Error error) {
        switch (this._tunnelStreamState) {
            case WAITING_REFRESH: {
                if (System.nanoTime() <= this._nextTimeoutNsec) break;
                error.text("Open TunnelStream timeout has occurred");
                this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                return 0;
            }
            case WAITING_AUTHENTICATION: {
                if (System.nanoTime() <= this._nextTimeoutNsec) break;
                this.sendCloseMsg(error);
                error.text("Timed out waiting for provider authentication response");
                this._reactorChannel.tunnelStreamManager().sendTunnelStreamStatusCloseRecover(this, error);
                return 0;
            }
            default: {
                try {
                    this.expireTimeoutMessages(currentTimeNsec, error);
                    break;
                }
                catch (Exception e) {
                    error.errorId(-1);
                    error.text("TunnelStream.handleTimer() Exception: " + e.getLocalizedMessage());
                    return -1;
                }
                catch (InternalError e) {
                    error.errorId(-1);
                    error.text("TunnelStream.handleTimer() InternalError: " + e.getLocalizedMessage());
                    return -1;
                }
            }
        }
        return 0;
    }

    void insertTimeoutBuffer(TunnelStreamBuffer tunnelBuffer, long currentTimeNsec) {
        assert (tunnelBuffer.timeoutNsec() > 0L);
        long timeout = tunnelBuffer.timeoutNsec();
        TunnelStreamBuffer tmpBuffer = this._outboundTimeoutList.peekTail();
        while (tmpBuffer != null && timeout - tmpBuffer.timeoutNsec() <= 0L) {
            tmpBuffer = TunnelStreamBuffer.TIMEOUT_LINK.getPrev(tmpBuffer);
        }
        if (tmpBuffer != null) {
            this._outboundTimeoutList.insertAfter(tmpBuffer, tunnelBuffer, TunnelStreamBuffer.TIMEOUT_LINK);
        } else {
            this._outboundTimeoutList.pushBack(tunnelBuffer, TunnelStreamBuffer.TIMEOUT_LINK);
        }
        tmpBuffer = this._outboundTimeoutList.peek();
        this._nextTimeoutNsec = tmpBuffer.timeoutNsec() - currentTimeNsec > 0L ? tmpBuffer.timeoutNsec() : currentTimeNsec;
        this.updateTimeout(currentTimeNsec);
    }

    void expireTimeoutMessages(long currentTimeNsec, Error error) {
        TunnelStreamBuffer tunnelBuffer = this._outboundTimeoutList.start(TunnelStreamBuffer.TIMEOUT_LINK);
        while (tunnelBuffer != null && tunnelBuffer.timeoutNsec() - currentTimeNsec < 0L) {
            assert (tunnelBuffer.isQueueData());
            this._outboundTimeoutList.remove(tunnelBuffer, TunnelStreamBuffer.TIMEOUT_LINK);
            this.queueMsgExpired(tunnelBuffer, null, 1);
            if (tunnelBuffer.persistenceBuffer() != null) {
                tunnelBuffer.tunnelSubstream().releasePersistenceBuffer(tunnelBuffer.persistenceBuffer());
            }
            this._outboundTransmitList.remove(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
            this.releaseBuffer(tunnelBuffer, error);
            tunnelBuffer = this._outboundTimeoutList.forth(TunnelStreamBuffer.TIMEOUT_LINK);
        }
        this.updateTimeout(currentTimeNsec);
    }

    void expireImmediateMessages(Error error) {
        TunnelStreamBuffer tunnelBuffer;
        while ((tunnelBuffer = this._outboundImmediateList.pop(TunnelStreamBuffer.TIMEOUT_LINK)) != null) {
            this.queueMsgExpired(tunnelBuffer, null, 1);
            if (tunnelBuffer.persistenceBuffer() != null) {
                tunnelBuffer.tunnelSubstream().releasePersistenceBuffer(tunnelBuffer.persistenceBuffer());
            }
            this._outboundTransmitList.remove(tunnelBuffer, TunnelStreamBuffer.RETRANS_LINK);
            this.releaseBuffer(tunnelBuffer, error);
        }
    }

    void updateTimeout(long currentTimeNsec) {
        TunnelStreamBuffer tunnelBuffer = this._outboundTimeoutList.peek();
        if (tunnelBuffer != null) {
            this._nextTimeoutNsec = tunnelBuffer.timeoutNsec();
            this.tunnelStreamManager().addTunnelStreamToTimeoutList(this, this._nextTimeoutNsec);
        } else {
            this.tunnelStreamManager().removeTunnelStreamFromTimeoutList(this);
        }
    }

    int traceFlags() {
        return this._traceFlags;
    }

    long nextTimeoutNsec() {
        return this._nextTimeoutNsec;
    }

    boolean hasNextTimeout() {
        return this._hasNextTimeout;
    }

    void hasNextTimeout(boolean hasNextTimeout) {
        this._hasNextTimeout = hasNextTimeout;
    }

    TunnelStreamStateInfo.TunnelStreamState tunnelStreamState() {
        return this._tunnelStreamState;
    }

    QueueMsg substreamBind(Msg tmpSubMsg) {
        switch (tmpSubMsg.msgClass()) {
            case 7: {
                GenericMsg genericMsg = (GenericMsg)tmpSubMsg;
                ByteBuffer tmpByteBuf = genericMsg.extendedHeader().data();
                int tmpPos = tmpByteBuf.position();
                int tmpLimit = tmpByteBuf.limit();
                tmpByteBuf.position(genericMsg.extendedHeader().position());
                byte opCode = tmpByteBuf.get();
                tmpByteBuf.limit(tmpLimit);
                tmpByteBuf.position(tmpPos);
                switch (opCode) {
                    case 1: {
                        return this._queueData;
                    }
                    case 4: {
                        return this._queueDataExpired;
                    }
                    case 2: {
                        return this._queueAck;
                    }
                }
                return null;
            }
            case 1: {
                return this._queueRequest;
            }
            case 2: {
                return this._queueRefresh;
            }
            case 5: {
                return this._queueClose;
            }
            case 3: {
                return this._queueStatus;
            }
        }
        return null;
    }

    void channelStreamId(int channelStreamId) {
        this._channelStreamId = channelStreamId;
    }

    private void errorInfoToError(ReactorErrorInfo errorInfo, Error error) {
        error.clear();
        error.channel(errorInfo.error().channel());
        error.errorId(errorInfo.error().errorId());
        error.sysError(errorInfo.error().sysError());
        if (errorInfo.error().text() != null) {
            error.text(errorInfo.error().text());
        }
    }

    void tableKey(WlInteger tableKey) {
        this._tableKey = tableKey;
    }

    WlInteger tableKey() {
        return this._tableKey;
    }

    int messageId() {
        int msgId;
        if ((msgId = ++this._messageId) > 65535) {
            this._messageId = 1;
            msgId = 1;
        }
        return msgId;
    }

    private int encodedMsgSize(Msg msg) {
        int msgSize = 128;
        MsgKey key = msg.msgKey();
        msgSize += msg.encodedDataBody().length();
        if (key != null) {
            if (key.checkHasName()) {
                msgSize += key.name().length();
            }
            if (key.checkHasAttrib()) {
                msgSize += key.encodedAttrib().length();
            }
        }
        return msgSize;
    }

    int handleTunnelStreamFragmentedMsg(TunnelStreamMsg.TunnelStreamData dataHeader, ByteBuffer fragmentedBuffer, int containerType, ReactorErrorInfo errorInfo) {
        int ret = 0;
        this._tempWlInteger.value(dataHeader.messageId());
        if (dataHeader.fragmentNumber() > 1L) {
            if (!this._msgIdBigBufferMap.containsKey(this._tempWlInteger)) {
                return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.handleTunnelStreamFragmentedMsg", "Received fragmented message with fragmentNumber > 1 but never received fragmentNumber of 1.");
            }
            TunnelStreamBigBuffer bigBuffer = this._msgIdBigBufferMap.get(this._tempWlInteger);
            bigBuffer.data().put(fragmentedBuffer);
            bigBuffer._bytesAlreadyCopied = bigBuffer.data().position();
            if ((long)bigBuffer._bytesAlreadyCopied >= dataHeader.totalMsgLength()) {
                bigBuffer.setCurrentPositionAsEndOfEncoding();
                bigBuffer.setAsFullReadBuffer();
                if (dataHeader.containerType() != 141) {
                    ret = this.msgReceived(bigBuffer, null, containerType);
                } else {
                    this._decIter.clear();
                    this._decIter.setBufferAndRWFVersion((TransportBuffer)bigBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
                    ret = this._tempMsg.decode(this._decIter);
                    if (ret != 0) {
                        return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.handleTunnelStreamFragmentedMsg", "Failed to decode re-assembled message.");
                    }
                    ret = this.msgReceived(bigBuffer, this._tempMsg, containerType);
                }
                this._msgIdBigBufferMap.remove(this._tempWlInteger);
                this.releaseBuffer((TransportBuffer)bigBuffer, errorInfo);
            }
        } else {
            TunnelStreamBigBuffer bigBuffer;
            if (this._msgIdBigBufferMap.containsKey(this._tempWlInteger)) {
                bigBuffer = this._msgIdBigBufferMap.get(this._tempWlInteger);
                bigBuffer.clear(bigBuffer.capacity());
            } else {
                bigBuffer = this._bigBufferPool.getBuffer((int)dataHeader.totalMsgLength() <= this._classOfService.common().maxFragmentSize() ? this._classOfService.common().maxFragmentSize() + 1 : (int)dataHeader.totalMsgLength(), errorInfo);
                this._msgIdBigBufferMap.put(this._tempWlInteger, bigBuffer);
                if (bigBuffer == null) {
                    return this._reactor.populateErrorInfo(errorInfo, -1, "TunnelStream.handleTunnelStreamFragmentedMsg", "Unable to acquire a big buffer.");
                }
            }
            bigBuffer.data().put(fragmentedBuffer);
            bigBuffer._bytesAlreadyCopied = bigBuffer.data().position();
        }
        return ret;
    }

    boolean handleRequestRetry() {
        if (this._tunnelStreamState != TunnelStreamStateInfo.TunnelStreamState.WAITING_REFRESH || this._requestRetryCount >= 1) {
            this._requestRetryCount = 0;
            return false;
        }
        this._tunnelStreamState = TunnelStreamStateInfo.TunnelStreamState.SEND_REQUEST;
        ++this._requestRetryCount;
        this._reactorChannel.tunnelStreamManager().addTunnelStreamToDispatchList(this);
        return true;
    }

    static class TimeoutLink
    implements VaDoubleLinkList.Link<TunnelStream> {
        TimeoutLink() {
        }

        @Override
        public TunnelStream getPrev(TunnelStream thisPrev) {
            return thisPrev._timeoutPrev;
        }

        @Override
        public void setPrev(TunnelStream thisPrev, TunnelStream thatPrev) {
            thisPrev._timeoutPrev = thatPrev;
        }

        @Override
        public TunnelStream getNext(TunnelStream thisNext) {
            return thisNext._timeoutNext;
        }

        @Override
        public void setNext(TunnelStream thisNext, TunnelStream thatNext) {
            thisNext._timeoutNext = thatNext;
        }
    }

    static class DispatchLink
    implements VaDoubleLinkList.Link<TunnelStream> {
        DispatchLink() {
        }

        @Override
        public TunnelStream getPrev(TunnelStream thisPrev) {
            return thisPrev._dispatchPrev;
        }

        @Override
        public void setPrev(TunnelStream thisPrev, TunnelStream thatPrev) {
            thisPrev._dispatchPrev = thatPrev;
        }

        @Override
        public TunnelStream getNext(TunnelStream thisNext) {
            return thisNext._dispatchNext;
        }

        @Override
        public void setNext(TunnelStream thisNext, TunnelStream thatNext) {
            thisNext._dispatchNext = thatNext;
        }
    }

    static class ManagerLink
    implements VaDoubleLinkList.Link<TunnelStream> {
        ManagerLink() {
        }

        @Override
        public TunnelStream getPrev(TunnelStream thisPrev) {
            return thisPrev._managerPrev;
        }

        @Override
        public void setPrev(TunnelStream thisPrev, TunnelStream thatPrev) {
            thisPrev._managerPrev = thatPrev;
        }

        @Override
        public TunnelStream getNext(TunnelStream thisNext) {
            return thisNext._managerNext;
        }

        @Override
        public void setNext(TunnelStream thisNext, TunnelStream thatNext) {
            thisNext._managerNext = thatNext;
        }
    }
}

