/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.ProtocolVersion;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class RestResponse {
    private int _statusCode;
    private String _statusText;
    private HashMap<String, String> _headerAttribute = new HashMap();
    private Object _bodyInJSon;
    private ProtocolVersion _protocolVersion;
    private String _contentType;

    RestResponse() {
    }

    public int statusCode() {
        return this._statusCode;
    }

    public String statusText() {
        return this._statusText;
    }

    public Map<String, String> headerAttribute() {
        return this._headerAttribute;
    }

    public JSONObject jsonObject() {
        if (this._bodyInJSon instanceof JSONObject) {
            return (JSONObject)this._bodyInJSon;
        }
        return null;
    }

    public JSONArray jsonArray() {
        if (this._bodyInJSon instanceof JSONArray) {
            return (JSONArray)this._bodyInJSon;
        }
        return null;
    }

    public Object body() {
        return this._bodyInJSon;
    }

    public String protocolVersion() {
        return this._protocolVersion.toString();
    }

    public String contentType() {
        return this._contentType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(50);
        builder.append("\nStatusCode : " + this._statusCode + "\n");
        builder.append("StatusText : " + this._statusText + "\n");
        if (this._protocolVersion != null) {
            builder.append("Protocol Version : " + this.protocolVersion() + "\n");
        }
        if (!this._headerAttribute.isEmpty()) {
            builder.append("Message Headers : \n");
        }
        for (Map.Entry<String, String> entry : this._headerAttribute.entrySet()) {
            builder.append(entry.getKey() + " : " + entry.getValue()).append("\n");
        }
        if (this.jsonObject() != null) {
            builder.append("\n");
            builder.append("Message body : \n");
            builder.append(((JSONObject)this._bodyInJSon).toString(2));
        } else if (this.jsonArray() != null) {
            builder.append("\n");
            builder.append("Message body : \n");
            builder.append(((JSONArray)this._bodyInJSon).toString(2));
        }
        return builder.toString();
    }

    void body(String respString, ReactorErrorInfo errorInfo) {
        block3: {
            if (respString == null) {
                return;
            }
            try {
                this._bodyInJSon = this.entityStringToJSON(respString, errorInfo);
            }
            catch (JSONException e) {
                errorInfo.clear();
                errorInfo.code(-1).location("RestResponse.body");
                errorInfo.error().errorId(-1);
                if (e.getLocalizedMessage() == null) break block3;
                errorInfo.error().text(e.getLocalizedMessage());
            }
        }
    }

    void statusCode(int statusCode) {
        this._statusCode = statusCode;
    }

    void statusText(String statusText) {
        this._statusText = statusText;
    }

    void headerAttribute(Header[] headers) {
        if (headers.length == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : this._headerAttribute.entrySet()) {
            this._headerAttribute.put(entry.getKey(), entry.getValue());
        }
    }

    void protocolVersion(ProtocolVersion protocolVersion) {
        this._protocolVersion = new ProtocolVersion(protocolVersion.getProtocol(), protocolVersion.getMajor(), protocolVersion.getMinor());
    }

    void contentType(String contentType) {
        this._contentType = contentType;
    }

    Object entityStringToJSON(String entityString, ReactorErrorInfo errorInfo) {
        try {
            switch (entityString.trim().charAt(0)) {
                case '[': {
                    return new JSONArray(entityString);
                }
                case '{': {
                    return new JSONObject(entityString);
                }
            }
            return null;
        }
        catch (Exception e) {
            errorInfo.clear();
            errorInfo.code(-1).location("RestResponse.entityStringToJSON");
            errorInfo.error().errorId(-1);
            if (e.getLocalizedMessage() != null) {
                errorInfo.error().text(e.getLocalizedMessage());
            }
            return null;
        }
    }
}

