/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRefresh;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWLSubmitMsgOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroup;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ReactorWarmStandbyHandler {
    private VaNode reactorQueueLink;
    private List<ReactorChannel> channelList;
    private List<ReactorWLSubmitMsgOptions> submitMsgQueue;
    private List<ReactorWLSubmitMsgOptions> freeSubmitMsgQueue;
    private ReactorChannel activeReactorChannel;
    private ReactorChannel nextActiveReactorChannel;
    private ReactorChannel mainReactorChannelImpl;
    private ReactorChannel startingReactorChannel;
    private int mainChannelState;
    private ReactorConnectOptions connectionOptions;
    private int currentWarmStandbyGroupIndex;
    private int previousWarmStandbyGroupIndex;
    private int warmStandbyHandlerState;
    private Reactor reactor;
    private LoginRefresh rdmLoginRefresh = (LoginRefresh)LoginMsgFactory.createMsg();
    private State rdmLoginState = CodecFactory.createState();
    private boolean hasConnectionList;
    private ReactorChannel readMsgChannel;
    private boolean queuedRecoveryMessage;
    private boolean enableSessionMgnt;
    private boolean watchlistSentFirstRequests;
    private Lock warmStandByHandlerLock = new ReentrantLock();
    private int ioCtlCodes;
    private int maxNumBuffers;
    private int numGuaranteedBuffers;
    private int highWaterMark;
    private int systemReadBuffers;
    private int systemWriteBuffers;
    private int compressionThreshold;
    private int rdmFieldVersion;
    private int rdmEnumTypeVersion;
    boolean isPHTimersStartedByChannelUp;
    long latestMsgSubmissionTime;
    long lastMsgRecoveryCheckTime;

    ReactorWarmStandbyHandler() {
        this.clear();
    }

    void clear() {
        if (this.reactorQueueLink == null) {
            this.reactorQueueLink = new VaNode();
        }
        if (this.channelList == null) {
            this.channelList = new ArrayList<ReactorChannel>();
        }
        this.channelList.clear();
        if (this.submitMsgQueue == null) {
            this.submitMsgQueue = new LinkedList<ReactorWLSubmitMsgOptions>();
        }
        this.submitMsgQueue.clear();
        if (this.freeSubmitMsgQueue == null) {
            this.freeSubmitMsgQueue = new LinkedList<ReactorWLSubmitMsgOptions>();
        }
        this.freeSubmitMsgQueue.clear();
        this.mainChannelState(0);
        this.warmStandbyHandlerState(0);
        this.rdmLoginRefresh().clear();
        this.rdmLoginRefresh.rdmMsgType(LoginMsgType.REFRESH);
        this.connectionOptions = null;
        this.currentWarmStandbyGroupIndex = -1;
        this.previousWarmStandbyGroupIndex = -1;
        this.reactor(null);
        this.rdmLoginState().clear();
        if (this.readMsgChannel() != null) {
            this.readMsgChannel = null;
        }
        this.queuedRecoveryMessage(false);
        this.enableSessionMgnt(false);
        this.ioCtlCodes(0);
        this.maxNumBuffers = 0;
        this.highWaterMark = 0;
        this.systemReadBuffers = 0;
        this.systemWriteBuffers = 0;
        this.compressionThreshold = 0;
        this.hasConnectionList = false;
        this.isPHTimersStartedByChannelUp = false;
        this.latestMsgSubmissionTime = 0L;
        this.lastMsgRecoveryCheckTime = 0L;
    }

    VaNode reactorQueueLink() {
        return this.reactorQueueLink;
    }

    List<ReactorChannel> channelList() {
        return this.channelList;
    }

    List<ReactorWLSubmitMsgOptions> submitMsgQueue() {
        return this.submitMsgQueue;
    }

    List<ReactorWLSubmitMsgOptions> freeSubmitMsgQueue() {
        return this.freeSubmitMsgQueue;
    }

    ReactorChannel activeReactorChannel() {
        return this.activeReactorChannel;
    }

    void activeReactorChannel(ReactorChannel activeReactorChannel) {
        this.activeReactorChannel = activeReactorChannel;
    }

    ReactorChannel nextActiveReactorChannel() {
        return this.nextActiveReactorChannel;
    }

    void nextActiveReactorChannel(ReactorChannel nextActiveReactorChannel) {
        this.nextActiveReactorChannel = nextActiveReactorChannel;
    }

    ReactorChannel mainReactorChannelImpl() {
        return this.mainReactorChannelImpl;
    }

    void mainReactorChannelImpl(ReactorChannel mainReactorChannelImpl) {
        this.mainReactorChannelImpl = mainReactorChannelImpl;
    }

    ReactorChannel startingReactorChannel() {
        return this.startingReactorChannel;
    }

    void startingReactorChannel(ReactorChannel startingReactorChannel) {
        this.startingReactorChannel = startingReactorChannel;
    }

    int mainChannelState() {
        return this.mainChannelState;
    }

    void mainChannelState(int mainChannelState) {
        this.mainChannelState = mainChannelState;
    }

    void connectionOptions(ReactorConnectOptions opts) {
        this.connectionOptions = opts;
    }

    ReactorConnectOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    ReactorWarmStandbyGroupImpl currentWarmStandbyGroupImpl() {
        if (this.currentWarmStandbyGroupIndex != -1) {
            return (ReactorWarmStandbyGroupImpl)this.connectionOptions._reactorWarmStandyGroupList.get(this.currentWarmStandbyGroupIndex);
        }
        return null;
    }

    ReactorWarmStandbyGroupImpl previousWarmStandbyGroupImpl() {
        if (this.previousWarmStandbyGroupIndex != -1) {
            return (ReactorWarmStandbyGroupImpl)this.connectionOptions._reactorWarmStandyGroupList.get(this.previousWarmStandbyGroupIndex);
        }
        return null;
    }

    List<ReactorWarmStandbyGroup> warmStandbyGroupList() {
        return this.connectionOptions._reactorWarmStandyGroupList;
    }

    int currentWarmStandbyGroupIndex() {
        return this.currentWarmStandbyGroupIndex;
    }

    int previousWarmStandbyGroupIndex() {
        return this.previousWarmStandbyGroupIndex;
    }

    void currentWarmStandbyGroupIndex(int currentWarmStandbyGroupIndex) {
        this.currentWarmStandbyGroupIndex = currentWarmStandbyGroupIndex;
    }

    void previousWarmStandbyGroupIndex(int previousWarmStandbyGroupIndex) {
        this.previousWarmStandbyGroupIndex = previousWarmStandbyGroupIndex;
    }

    void incrementWarmStandbyGroupIndex() {
        ++this.currentWarmStandbyGroupIndex;
    }

    int warmStandbyHandlerState() {
        return this.warmStandbyHandlerState;
    }

    void warmStandbyHandlerState(int warmStandbyHandlerState) {
        this.warmStandbyHandlerState = warmStandbyHandlerState;
    }

    void setPrimaryLoginResponseState() {
        this.warmStandbyHandlerState |= 1;
    }

    void setPrimaryDirectoryResponseState() {
        this.warmStandbyHandlerState |= 2;
    }

    void setSecondaryDirectoryResponseState() {
        this.warmStandbyHandlerState |= 4;
    }

    void setConnectingToStartingServerState() {
        this.warmStandbyHandlerState |= 8;
    }

    void setMoveToChannelListState() {
        this.warmStandbyHandlerState |= 0x10;
    }

    void setClosingStandbyChannelsState() {
        this.warmStandbyHandlerState |= 0x20;
    }

    void setMoveToNextWSBGroupState() {
        this.warmStandbyHandlerState |= 0x40;
    }

    void setReceivedPrimaryFieldDictionaryState() {
        this.warmStandbyHandlerState |= 0x80;
    }

    void setReceivedPrimaryEnumDictionaryState() {
        this.warmStandbyHandlerState |= 0x100;
    }

    void setClosingState() {
        this.warmStandbyHandlerState |= 0x200;
    }

    void setInactiveState() {
        this.warmStandbyHandlerState |= 0x400;
    }

    void setMovedToChannelList() {
        this.warmStandbyHandlerState |= 0x800;
    }

    Reactor reactor() {
        return this.reactor;
    }

    void reactor(Reactor reactor) {
        this.reactor = reactor;
    }

    LoginRefresh rdmLoginRefresh() {
        return this.rdmLoginRefresh;
    }

    void rdmLoginRefresh(LoginRefresh rdmLoginRefresh) {
        rdmLoginRefresh.copy(this.rdmLoginRefresh);
    }

    State rdmLoginState() {
        return this.rdmLoginState;
    }

    void rdmLoginState(State rdmLoginState) {
        this.rdmLoginState = rdmLoginState;
    }

    int rdmFieldVersion() {
        return this.rdmFieldVersion;
    }

    void rdmFieldVersion(int rdmFieldVersion) {
        this.rdmFieldVersion = rdmFieldVersion;
    }

    int rdmEnumTypeVersion() {
        return this.rdmEnumTypeVersion;
    }

    void rdmEnumTypeVersion(int rdmEnumTypeVersion) {
        this.rdmEnumTypeVersion = rdmEnumTypeVersion;
    }

    ReactorChannel readMsgChannel() {
        return this.readMsgChannel;
    }

    void readMsgChannel(ReactorChannel readMsgChannel) {
        this.readMsgChannel = readMsgChannel;
    }

    boolean queuedRecoveryMessage() {
        return this.queuedRecoveryMessage;
    }

    void queuedRecoveryMessage(boolean queuedRecoveryMessage) {
        this.queuedRecoveryMessage = queuedRecoveryMessage;
    }

    boolean enableSessionMgnt() {
        return this.enableSessionMgnt;
    }

    void enableSessionMgnt(boolean enableSessionMgnt) {
        this.enableSessionMgnt = enableSessionMgnt;
    }

    int ioCtlCodes() {
        return this.ioCtlCodes;
    }

    void ioCtlCodes(int ioCtlCodes) {
        this.ioCtlCodes = ioCtlCodes;
    }

    int maxNumBuffers() {
        return this.maxNumBuffers;
    }

    void maxNumBuffers(int maxNumBuffers) {
        this.ioCtlCodes |= 1;
        this.maxNumBuffers = maxNumBuffers;
    }

    int numGuaranteedBuffers() {
        return this.numGuaranteedBuffers;
    }

    void numGuaranteedBuffers(int numGuaranteedBuffers) {
        this.ioCtlCodes |= 2;
        this.numGuaranteedBuffers = numGuaranteedBuffers;
    }

    int highWaterMark() {
        return this.highWaterMark;
    }

    void highWaterMark(int highWaterMark) {
        this.ioCtlCodes |= 4;
        this.highWaterMark = highWaterMark;
    }

    int systemReadBuffers() {
        return this.systemReadBuffers;
    }

    void systemReadBuffers(int systemReadBuffers) {
        this.ioCtlCodes |= 0x10;
        this.systemReadBuffers = systemReadBuffers;
    }

    int systemWriteBuffers() {
        return this.systemWriteBuffers;
    }

    void systemWriteBuffers(int systemWriteBuffers) {
        this.ioCtlCodes |= 8;
        this.systemWriteBuffers = systemWriteBuffers;
    }

    int compressionThreshold() {
        return this.compressionThreshold;
    }

    void compressionThreshold(int compressionThreshold) {
        this.ioCtlCodes |= 0x20;
        this.compressionThreshold = compressionThreshold;
    }

    boolean hasConnectionList() {
        return this.hasConnectionList;
    }

    void hasConnectionList(boolean hasConnectionList) {
        this.hasConnectionList = hasConnectionList;
    }

    boolean watchlistSentFirstRequests() {
        return this.watchlistSentFirstRequests;
    }

    void watchlistSentFirstRequests(boolean watchlistSentFirstRequests) {
        this.watchlistSentFirstRequests = watchlistSentFirstRequests;
    }

    Lock warmStandByHandlerLock() {
        return this.warmStandByHandlerLock;
    }
}

