/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;

interface ReactorDebugger {
    public static final String CONNECTION_SERVER_ACCEPT = "Reactor@%d, Server@%d accepts reactor channel@%d on channel fd=%d.]\n";
    public static final String CONNECTION_CHANNEL_DOWN = "Reactor@%d, Reactor channel@%d is DOWN on channel fd=%d.]\n";
    public static final String CONNECTION_CHANNEL_CLOSE = "Reactor@%d, closing reactor channel@%d on channel fd=%d.]\n";
    public static final String CONNECTION_CHANNEL_CLOSE_NUM_OF_CALLS = "Reactor@%d, Reactor channel@%d, number of closing call %d and number of dispatching per channel call %d.]\n";
    public static final String CONNECTION_CHANNEL_UP = "Reactor@%d, Reactor channel@%d is UP on channel fd=%d.]\n";
    public static final String CONNECTION_SESSION_STARTUP_DONE = "Reactor@%d, Reactor channel@%d session startup executed on channel fd=%d, session management enabled: %b]\n";
    public static final String CONNECTION_CONNECTING_PERFORMED = "Reactor@%d, Reactor channel@%d connection executed on channel fd=%d.]\n";
    public static final String CONNECTION_DISCONNECT = "Reactor@%d, Reactor channel@%d disconnected with status = %s on channel fd=%d.]\n";
    public static final String CONNECTION_RECONNECT = "Reactor@%d, Reactor channel@%d reconnecting on channel fd=%d.]\n";
    public static final String CONNECTION_RECONNECT_RDP = "Reactor@%d, Reactor channel@%d reconnecting to LDP on channel fd=%d.]\n";
    public static final String EVENTQUEUE_COUNT_REACTOR = "Reactor@%d, reactor event count %d to be dispatched.]\n";
    public static final String EVENTQUEUE_COUNT_ALL = "Reactor@%d, %d events to be dispatched from active channels event queue.]\n";
    public static final String EVENTQUEUE_COUNT_SPECIFIED = "Reactor@%d, Per Reactor channel@%d event count %d to be dispatched on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_ACCEPT = "Reactor@%d, Reactor channel@%d accepts a tunnel stream request (stream ID=%d) on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_DISPATCH_NOW = "Reactor@%d, Reactor channel@%d put a tunnel stream DISPATCH_NOW event on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_STREAM_REQUEST = "Reactor@%d, Reactor channel@%d receives a tunnel stream request (stream ID=%d) on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_STREAM_REJECT = "Reactor@%d, Reactor channel@%d rejects a tunnel stream request (stream ID=%d) on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_SEND_STREAM_OPEN = "Reactor@%d, Reactor channel@%d submitted a tunnel stream open response (stream ID=%d) on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_STREAM_ESTABLISHED = "Reactor@%d, Reactor channel@%d, Tunnel stream established (stream ID=%d) on channel fd=%d.]\n";
    public static final String TUNNELSTREAM_STREAM_CLOSE = "Reactor@%d, Reactor channel@%d handles tunnel stream closes (stream ID=%d) on channel fd=%d.]\n";
    public static final String PREFERRED_HOST_ALREADY_CONNECTED = "Reactor@%d, Reactor channel@%d is already connected to the preferred host.]\\n";
    public static final String PREFERRED_HOST_IGNORE_SWITCH_DURING_RECONNECTING = "Reactor@%d, Reactor channel@%d ignores fallback to preferred host during reconnection or down state.]\\n";

    public static int getChannelId(ReactorChannel reactorChannel) {
        try {
            if (reactorChannel.selectableChannel() != null) {
                Integer fd = (Integer)((Method)Arrays.stream(Introspector.getBeanInfo(reactorChannel.selectableChannel().getClass()).getPropertyDescriptors()).filter(pd -> pd.getDisplayName().equals("FDVal")).map(PropertyDescriptor::getReadMethod).findFirst().orElse(null)).invoke((Object)reactorChannel.selectableChannel(), new Object[0]);
                return fd != null ? fd : -1;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void writeDebugInfo(String var1, Object ... var2);

    public void incNumOfCloseCalls();

    public int getNumOfCloseCalls();

    public void incNumOfDispatchCalls();

    public int getNumOfDispatchCalls();

    public OutputStream getOutputStream();

    public byte[] toByteArray();
}

