/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.transport.Channel;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.InProgInfo;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.valueadd.common.SelectableBiDirectionalQueue;
import com.refinitiv.eta.valueadd.common.VaIteratableQueue;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyServerInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStream;
import com.refinitiv.eta.valueadd.reactor.WorkerEvent;
import com.refinitiv.eta.valueadd.reactor.WorkerEventTypes;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;

class Worker
implements Runnable {
    int SELECT_TIME = 100;
    SelectableBiDirectionalQueue _queue = null;
    Selector _selector = null;
    ReactorChannel _workerReactorChannel = null;
    ReactorChannel _reactorReactorChannel = null;
    Error _error = TransportFactory.createError();
    InProgInfo _inProg = TransportFactory.createInProgInfo();
    VaIteratableQueue _initChannelQueue = new VaIteratableQueue();
    VaIteratableQueue _activeChannelQueue = new VaIteratableQueue();
    VaIteratableQueue _reconnectingChannelQueue = new VaIteratableQueue();
    volatile boolean _running = true;
    VaIteratableQueue _timerEventQueue = new VaIteratableQueue();
    Reactor _reactor;

    Worker(ReactorChannel reactorChannel, SelectableBiDirectionalQueue queue) {
        if (reactorChannel == null) {
            throw new UnsupportedOperationException("reactorChannel cannot be null");
        }
        if (queue == null) {
            throw new UnsupportedOperationException("queue cannot be null");
        }
        this._reactorReactorChannel = reactorChannel;
        this._queue = queue;
        this._reactor = reactorChannel.reactor();
    }

    @Override
    public void run() {
        if (this.initializeWorker() != 0) {
            System.out.println("Worker.run(): failed to initialize, shutting down");
            this.shutdown();
            return;
        }
        while (this._running || this._queue.readQueueSize() > 0) {
            try {
                ReactorChannel reactorChannel;
                int selectorCount = this._selector.select(this.SELECT_TIME);
                if (selectorCount > 0 || !this._selector.selectedKeys().isEmpty()) {
                    Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        ReactorChannel reactorChannel2;
                        SelectionKey key = iter.next();
                        iter.remove();
                        if (!key.isValid()) continue;
                        if (key.isConnectable()) {
                            reactorChannel2 = (ReactorChannel)key.attachment();
                            if (reactorChannel2.channel() != null && (reactorChannel2.channel().state() == 0 || reactorChannel2.channel().state() == 1)) {
                                this.initializeChannel(reactorChannel2);
                            }
                            if (!key.isValid()) continue;
                        }
                        if (key.isReadable()) {
                            reactorChannel2 = (ReactorChannel)key.attachment();
                            if (this._workerReactorChannel == reactorChannel2) {
                                this.processWorkerEvent();
                            } else {
                                if (reactorChannel2.channel() != null && (reactorChannel2.channel().state() == 0 || reactorChannel2.channel().state() == 1)) {
                                    this.initializeChannel(reactorChannel2);
                                }
                                if (!key.isValid()) continue;
                            }
                        }
                        if (!key.isWritable()) continue;
                        this.processChannelFlush((ReactorChannel)key.attachment());
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    this._running = false;
                }
                this._timerEventQueue.rewind();
                while (this._timerEventQueue.hasNext()) {
                    WorkerEvent event = (WorkerEvent)this._timerEventQueue.next();
                    if (System.nanoTime() < event.timeout()) continue;
                    if (event.eventType() == WorkerEventTypes.TOKEN_MGNT) {
                        ReactorTokenSession tokenSession = event._tokenSession;
                        if (tokenSession != null && (tokenSession.authTokenInfo().tokenVersion() != ReactorAuthTokenInfo.TokenVersion.V2 || event._reactorChannel != null && event._reactorChannel.state() != ReactorChannel.State.READY && event._reactorChannel.state() != ReactorChannel.State.UP)) {
                            tokenSession.handleTokenReissue();
                        }
                        if (tokenSession != null) {
                            tokenSession.tokenReissueEvent(null);
                        }
                        this._timerEventQueue.remove(event);
                        event.returnToPool();
                        continue;
                    }
                    WorkerEventTypes eventType = WorkerEventTypes.TUNNEL_STREAM_DISPATCH_TIMEOUT;
                    if (event.eventType() == WorkerEventTypes.START_WATCHLIST_TIMER) {
                        eventType = WorkerEventTypes.WATCHLIST_TIMEOUT;
                    }
                    this.sendWorkerEvent(event.reactorChannel(), eventType, event.tunnelStream(), 0, null, null);
                    this._timerEventQueue.remove(event);
                    event.returnToPool();
                }
                this._initChannelQueue.rewind();
                while (this._initChannelQueue.hasNext()) {
                    reactorChannel = (ReactorChannel)this._initChannelQueue.next();
                    if (reactorChannel.state() != ReactorChannel.State.INITIALIZING || reactorChannel.channel() == null || reactorChannel.channel().state() != 0 && reactorChannel.channel().state() != 1) continue;
                    this.initializeChannel(reactorChannel);
                }
                this._activeChannelQueue.rewind();
                while (this._activeChannelQueue.hasNext()) {
                    reactorChannel = (ReactorChannel)this._activeChannelQueue.next();
                    if (reactorChannel == null || reactorChannel.channel() == null || reactorChannel.channel().state() != 2 || reactorChannel.state() == ReactorChannel.State.DOWN_RECONNECTING || reactorChannel.state() == ReactorChannel.State.DOWN || reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.EDP_RT || reactorChannel.state() == ReactorChannel.State.EDP_RT_DONE || reactorChannel.state() == ReactorChannel.State.EDP_RT_FAILED || reactorChannel.pingHandler().handlePings(reactorChannel, this._error) >= 0) continue;
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.run()", "Ping error for channel: " + this._error.text());
                }
                this._reconnectingChannelQueue.rewind();
                while (this._reconnectingChannelQueue.hasNext()) {
                    reactorChannel = (ReactorChannel)this._reconnectingChannelQueue.next();
                    if (reactorChannel == null || reactorChannel.nextRecoveryTime() > System.currentTimeMillis()) continue;
                    Channel channel = null;
                    if (this._reactor.reactorHandlesWarmStandby(reactorChannel)) {
                        ReactorWarmStandbyServerInfo wsbServerImpl;
                        ++reactorChannel._reconnectAttempts;
                        ReactorWarmStandbyGroupImpl wsbGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                        if (reactorChannel.isStartingServerConfig) {
                            wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer();
                            reactorChannel.setCurrentReactorConnectInfo(wsbGroup.startingActiveServer().reactorConnectInfo());
                            reactorChannel.setCurrentConnectOptionsInfo(wsbGroup.startingConnectOptionsInfo);
                            reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                            reactorChannel.standByGroupListIndex = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex();
                            if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x20) != 0) {
                                continue;
                            }
                        } else {
                            wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().get(reactorChannel.standByServerListIndex);
                            reactorChannel.setCurrentReactorConnectInfo(wsbGroup.standbyServerList().get(reactorChannel.standByServerListIndex).reactorConnectInfo());
                            reactorChannel.setCurrentConnectOptionsInfo(wsbGroup.standbyConnectOptionsInfoList.get(reactorChannel.standByServerListIndex));
                            reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                        }
                        if (!wsbServerImpl.isActiveChannelConfig()) {
                            this._reconnectingChannelQueue.remove(reactorChannel);
                        }
                    } else if (reactorChannel.state() != ReactorChannel.State.EDP_RT && reactorChannel.state() != ReactorChannel.State.EDP_RT_DONE && reactorChannel.state() != ReactorChannel.State.EDP_RT_FAILED) {
                        ++reactorChannel._reconnectAttempts;
                        if (++reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                            reactorChannel._listIndex = 0;
                        }
                        reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                        reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                    }
                    if (reactorChannel.state() != ReactorChannel.State.EDP_RT && reactorChannel.state() != ReactorChannel.State.EDP_RT_DONE && reactorChannel.state() != ReactorChannel.State.EDP_RT_FAILED) {
                        channel = reactorChannel.reconnectReactorChannel(this._error);
                    }
                    if (reactorChannel.state() == ReactorChannel.State.EDP_RT || reactorChannel.state() == ReactorChannel.State.EDP_RT_DONE || reactorChannel.state() == ReactorChannel.State.EDP_RT_FAILED) {
                        channel = reactorChannel.reconnectEDP(this._error);
                    }
                    if (channel == null && reactorChannel.state() != ReactorChannel.State.EDP_RT) {
                        this._reconnectingChannelQueue.remove(reactorChannel);
                        if (reactorChannel.tokenSession() != null && reactorChannel.tokenSession().sessionMgntState() == ReactorTokenSession.SessionState.STOP_TOKEN_REQUEST) {
                            reactorChannel.getReactorConnectOptions().reconnectAttemptLimit(0);
                        }
                        this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.run()", "Reconnection failed: " + this._error.text());
                        continue;
                    }
                    if (reactorChannel.state() == ReactorChannel.State.EDP_RT) continue;
                    reactorChannel.selectableChannelFromChannel(channel);
                    reactorChannel.state(ReactorChannel.State.INITIALIZING);
                    this._reconnectingChannelQueue.remove(reactorChannel);
                    this.processChannelInit(reactorChannel);
                }
            }
            catch (CancelledKeyException e) {
            }
            catch (IOException e) {
                System.out.println("Worker.run() exception=" + e.getLocalizedMessage());
                this.sendWorkerEvent(this._reactorReactorChannel, WorkerEventTypes.SHUTDOWN, -1, "Worker.run", "exception occurred, " + e.getLocalizedMessage());
                break;
            }
        }
        this.shutdown();
    }

    private void processWorkerEvent() {
        WorkerEvent event = (WorkerEvent)this._queue.read();
        WorkerEventTypes eventType = event.eventType();
        ReactorChannel reactorChannel = event.reactorChannel();
        switch (eventType) {
            case CHANNEL_INIT: {
                this.processChannelInit(reactorChannel);
                break;
            }
            case CHANNEL_DOWN: {
                this.processChannelClose(reactorChannel);
                if (reactorChannel.server() != null || event.reactorChannel().recoveryAttemptLimitReached()) break;
                reactorChannel.calculateNextReconnectTime();
                if (reactorChannel.tokenSession() != null && reactorChannel.tokenSession().authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2 && !reactorChannel.tokenSession().hasAccessToken()) {
                    reactorChannel.tokenSession().resetSessionMgntState();
                }
                this._reconnectingChannelQueue.add(reactorChannel);
                break;
            }
            case CHANNEL_CLOSE: {
                this.processChannelClose(reactorChannel);
                if (reactorChannel.warmStandByHandlerImpl != null) {
                    this._reactor.removeReactorChannel(reactorChannel);
                }
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_CLOSE_ACK, 0, null, null);
                break;
            }
            case SHUTDOWN: {
                this._running = false;
                break;
            }
            case FLUSH: {
                this.processChannelFlush(reactorChannel);
                break;
            }
            case FD_CHANGE: {
                this.processChannelFDChange(reactorChannel);
                break;
            }
            case TOKEN_MGNT: {
                ReactorTokenSession tokenSession = event._tokenSession;
                if (tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.REQUEST_TOKEN_FAILURE) {
                    event.timeout(tokenSession.nextTokenReissueAttemptReqTime());
                } else if (tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.AUTHENTICATE_USING_PASSWD_GRANT) {
                    event.timeout(System.nanoTime());
                } else {
                    tokenSession.calculateNextAuthTokenRequestTime(tokenSession.authTokenInfo().expiresIn());
                    event.timeout(tokenSession.nextAuthTokenRequestTime());
                }
                if (tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                    if (tokenSession.tokenReissueEvent() != null && tokenSession.tokenReissueEvent() != event) {
                        tokenSession.tokenReissueEvent()._tokenSession = null;
                        tokenSession.tokenReissueEvent().timeout(System.nanoTime());
                        tokenSession.tokenReissueEvent(event);
                    } else {
                        tokenSession.tokenReissueEvent(event);
                    }
                }
                this._timerEventQueue.add(event);
                return;
            }
            case START_DISPATCH_TIMER: 
            case START_WATCHLIST_TIMER: {
                this._timerEventQueue.add(event);
                return;
            }
            default: {
                System.out.println("Worker.processWorkerEvent(): received unexpected eventType=" + (Object)((Object)eventType));
            }
        }
        event.returnToPool();
    }

    private void processChannelInit(ReactorChannel reactorChannel) {
        this._initChannelQueue.add(reactorChannel);
        try {
            if (reactorChannel.selectableChannel() != null) {
                reactorChannel.selectableChannel().register(this._selector, 9, reactorChannel);
            }
        }
        catch (ClosedChannelException e) {
            if (reactorChannel.state() != ReactorChannel.State.CLOSED) {
                reactorChannel.state(ReactorChannel.State.CLOSED);
            }
            this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelInit", "Exception=" + e.getLocalizedMessage());
        }
    }

    private void processChannelClose(ReactorChannel reactorChannel) {
        if (reactorChannel == null) {
            return;
        }
        if (reactorChannel.channel() != null && reactorChannel.channel().state() != 0) {
            reactorChannel.channel().close(this._error);
            reactorChannel.selectableChannelFromChannel(null);
            reactorChannel.flushRequested(false);
        }
        if (!this._activeChannelQueue.remove(reactorChannel) && !this._initChannelQueue.remove(reactorChannel)) {
            this._reconnectingChannelQueue.remove(reactorChannel);
        }
    }

    private void processChannelFlush(ReactorChannel reactorChannel) {
        if (reactorChannel == null) {
            return;
        }
        Channel channel = reactorChannel.channel();
        if (channel != null && channel.state() != 0 && channel.state() != -1) {
            int retval = channel.flush(this._error);
            if (retval > 0) {
                if (!this.addSelectOption(reactorChannel, 4) && reactorChannel.state() != ReactorChannel.State.CLOSED && reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFlush", "failed to add OP_WRITE to selectableChannel.");
                }
            } else if (retval == 0) {
                if (!this.removeSelectOption(reactorChannel, 4) && reactorChannel.state() != ReactorChannel.State.CLOSED && reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFlush", "failed to remove OP_WRITE to selectableChannel.");
                }
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.FLUSH_DONE, 0, null, null);
            } else if (retval < 0 && retval != -9 && retval != -10 && reactorChannel.state() != ReactorChannel.State.CLOSED && reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFlush", "failed to flush selectableChannel, errorId=" + this._error.errorId() + " errorText=" + this._error.text());
            }
        }
    }

    private void processChannelFDChange(ReactorChannel reactorChannel) {
        block6: {
            int options = 0;
            try {
                SelectionKey key = reactorChannel.oldSelectableChannel().keyFor(this._selector);
                if (key != null) {
                    options = key.interestOps();
                    key.cancel();
                }
            }
            catch (Exception key) {
                // empty catch block
            }
            try {
                if (options != 0) {
                    reactorChannel.selectableChannel().register(this._selector, options, reactorChannel);
                }
            }
            catch (Exception e) {
                if (reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.DOWN || reactorChannel.state() == ReactorChannel.State.DOWN_RECONNECTING) break block6;
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFDChange", "selector register failed.");
            }
        }
    }

    private void initializeChannel(ReactorChannel reactorChannel) {
        Channel channel = reactorChannel.channel();
        int retval = channel.init(this._inProg, this._error);
        if (retval < 0) {
            this.cancelRegister(reactorChannel);
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error initializing channel: errorId=" + this._error.errorId() + " text=" + this._error.text());
            return;
        }
        switch (retval) {
            case 2: {
                if (this._inProg.flags() == 1) {
                    retval = this.reRegister(this._inProg, reactorChannel, this._error);
                    if (retval == 0) break;
                    this.cancelRegister(reactorChannel);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error - failed to re-register on SCKT_CHNL_CHANGE: " + this._error.text());
                    break;
                }
                if (System.currentTimeMillis() <= reactorChannel.initializationEndTimeMs()) break;
                this.cancelRegister(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error - exceeded initialization timeout (" + reactorChannel.initializationTimeout() + " s)");
                break;
            }
            case 0: {
                this.cancelRegister(reactorChannel);
                reactorChannel.pingHandler().initPingHandler(channel.pingTimeout());
                reactorChannel.resetCurrentChannelRetryCount();
                this._initChannelQueue.remove(reactorChannel);
                this._activeChannelQueue.add(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_UP, 0, null, null);
                break;
            }
            default: {
                this.cancelRegister(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error - invalid return code: " + retval);
            }
        }
    }

    private void cancelRegister(ReactorChannel reactorChannel) {
        try {
            SelectionKey key = reactorChannel.channel().selectableChannel().keyFor(this._selector);
            if (key != null) {
                key.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean addSelectOption(ReactorChannel reactorChannel, int options) {
        if (reactorChannel == null || reactorChannel.state() != ReactorChannel.State.INITIALIZING && reactorChannel.state() != ReactorChannel.State.UP && reactorChannel.state() != ReactorChannel.State.READY) {
            return false;
        }
        Channel channel = reactorChannel.channel();
        if (channel == null) {
            return false;
        }
        SelectionKey key = channel.selectableChannel().keyFor(this._selector);
        if (key != null) {
            if ((key.interestOps() & options) != 0) {
                return true;
            }
            options |= key.interestOps();
        }
        try {
            channel.selectableChannel().register(this._selector, options, reactorChannel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean removeSelectOption(ReactorChannel reactorChannel, int options) {
        block8: {
            if (reactorChannel == null || reactorChannel.state() != ReactorChannel.State.INITIALIZING && reactorChannel.state() != ReactorChannel.State.UP && reactorChannel.state() != ReactorChannel.State.READY) {
                return false;
            }
            Channel channel = reactorChannel.channel();
            if (channel == null) {
                return false;
            }
            SelectionKey key = channel.selectableChannel().keyFor(this._selector);
            if (key != null) {
                try {
                    int newOptions = key.interestOps() - options;
                    if (newOptions != 0) {
                        try {
                            channel.selectableChannel().register(this._selector, newOptions, reactorChannel);
                            break block8;
                        }
                        catch (ClosedChannelException e) {
                            return false;
                        }
                    }
                    key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private int reRegister(InProgInfo inProg, ReactorChannel reactorChannel, Error error) {
        try {
            SelectionKey key = inProg.oldSelectableChannel().keyFor(this._selector);
            if (key != null) {
                key.cancel();
            }
        }
        catch (Exception e) {
            error.text(e.getMessage());
            return -1;
        }
        try {
            reactorChannel.channel().selectableChannel().register(this._selector, 1, reactorChannel);
        }
        catch (Exception e) {
            error.text(e.getMessage());
            return -1;
        }
        reactorChannel.selectableChannelFromChannel(reactorChannel.channel());
        reactorChannel.oldSelectableChannel(inProg.oldSelectableChannel());
        return 0;
    }

    private void sendWorkerEvent(ReactorChannel reactorChannel, WorkerEventTypes eventType, int reactorReturnCode, String location, String text) {
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.reactorChannel(reactorChannel);
        event.eventType(eventType);
        event.errorInfo().code(reactorReturnCode);
        event.errorInfo().error().errorId(reactorReturnCode);
        if (location != null) {
            event.errorInfo().location(location);
        }
        if (text != null) {
            event.errorInfo().error().text(text);
        }
        this._queue.write(event);
    }

    private void sendWorkerEvent(ReactorChannel reactorChannel, WorkerEventTypes eventType, TunnelStream tunnelStream, int reactorReturnCode, String location, String text) {
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.reactorChannel(reactorChannel);
        event.eventType(eventType);
        event.tunnelStream(tunnelStream);
        event.errorInfo().code(reactorReturnCode);
        event.errorInfo().error().errorId(reactorReturnCode);
        if (location != null) {
            event.errorInfo().location(location);
        }
        if (text != null) {
            event.errorInfo().error().text(text);
        }
        this._queue.write(event);
    }

    private void shutdown() {
        this._running = false;
        if (this._selector != null) {
            ReactorChannel reactorChannel;
            Set<SelectionKey> keys = this._selector.keys();
            if (keys != null) {
                for (SelectionKey key : keys) {
                    key.cancel();
                    ReactorChannel reactorChannel2 = (ReactorChannel)key.attachment();
                    if (reactorChannel2 == null) continue;
                    if (reactorChannel2.channel() != null) {
                        reactorChannel2.channel().close(this._error);
                        if (!this._activeChannelQueue.remove(reactorChannel2) && !this._initChannelQueue.remove(reactorChannel2)) {
                            this._reconnectingChannelQueue.remove(reactorChannel2);
                        }
                    } else if (reactorChannel2 == this._workerReactorChannel) {
                        this._queue = null;
                        this._workerReactorChannel = null;
                    }
                    reactorChannel2.returnToPool();
                }
            }
            try {
                this._selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._selector = null;
            while (this._initChannelQueue.size() > 0) {
                reactorChannel = (ReactorChannel)this._initChannelQueue.poll();
                if (reactorChannel == null) continue;
                if (reactorChannel.channel() != null) {
                    reactorChannel.channel().close(this._error);
                }
                reactorChannel.reactor().removeReactorChannel(reactorChannel);
                reactorChannel.returnToPool();
            }
            while (this._activeChannelQueue.size() > 0) {
                reactorChannel = (ReactorChannel)this._activeChannelQueue.poll();
                if (reactorChannel == null) continue;
                if (reactorChannel.channel() != null) {
                    reactorChannel.channel().close(this._error);
                }
                reactorChannel.reactor().removeReactorChannel(reactorChannel);
                reactorChannel.returnToPool();
            }
            while (this._reconnectingChannelQueue.size() > 0) {
                reactorChannel = (ReactorChannel)this._reconnectingChannelQueue.poll();
                if (reactorChannel == null) continue;
                if (reactorChannel.channel() != null) {
                    reactorChannel.channel().close(this._error);
                }
                reactorChannel.reactor().removeReactorChannel(reactorChannel);
                reactorChannel.returnToPool();
            }
            if (this._reactor.numberOfTokenSession() != 0) {
                this._reactor.removeAllTokenSession();
            }
        }
        this._error = null;
    }

    private int initializeWorker() {
        try {
            this._selector = SelectorProvider.provider().openSelector();
            this._workerReactorChannel = ReactorFactory.createReactorChannel(this._reactor);
            this._workerReactorChannel.selectableChannel(this._queue.readChannel());
            this._queue.readChannel().register(this._selector, 1, this._workerReactorChannel);
        }
        catch (IOException e) {
            this._running = false;
            System.out.println("Worker.initializeWorker() failed, exception=" + e.getLocalizedMessage());
            return -1;
        }
        return 0;
    }
}

