/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEventCallback;

public class ReactorOAuthCredentialRenewalOptions {
    private Buffer _proxyHostName = CodecFactory.createBuffer();
    private Buffer _proxyPort = CodecFactory.createBuffer();
    private Buffer _proxyUserName = CodecFactory.createBuffer();
    private Buffer _proxyPassword = CodecFactory.createBuffer();
    private Buffer _proxyDomain = CodecFactory.createBuffer();
    private Buffer _proxyLocalHostName = CodecFactory.createBuffer();
    private Buffer _proxyKrb5ConfigFile = CodecFactory.createBuffer();
    private int _renewalModes = 0;
    private ReactorAuthTokenEventCallback _reactorAuthTokenEventCallback;

    ReactorOAuthCredentialRenewalOptions() {
        this.clear();
    }

    public void clear() {
        this._renewalModes = 0;
        this._proxyHostName.clear();
        this._proxyPort.clear();
        this._proxyUserName.clear();
        this._proxyPassword.clear();
        this._proxyDomain.clear();
    }

    public void renewalModes(int renewalModes) {
        this._renewalModes = renewalModes;
    }

    public int renewalModes() {
        return this._renewalModes;
    }

    public int reactorAuthTokenEventCallback(ReactorAuthTokenEventCallback callback) {
        if (callback == null) {
            return -5;
        }
        this._reactorAuthTokenEventCallback = callback;
        return 0;
    }

    public ReactorAuthTokenEventCallback reactorAuthTokenEventCallback() {
        return this._reactorAuthTokenEventCallback;
    }

    public void proxyHostName(Buffer proxyHostName) {
        assert (proxyHostName != null) : "proxyHostName can not be null";
        this.proxyHostName().data(proxyHostName.data(), proxyHostName.position(), proxyHostName.length());
    }

    public Buffer proxyHostName() {
        return this._proxyHostName;
    }

    public void proxyPort(Buffer proxyPort) {
        this._proxyPort = proxyPort;
    }

    public Buffer proxyPort() {
        return this._proxyPort;
    }

    public void proxyUserName(Buffer proxyUserName) {
        assert (proxyUserName != null) : "proxyUserName can not be null";
        this.proxyUserName().data(proxyUserName.data(), proxyUserName.position(), proxyUserName.length());
    }

    public Buffer proxyUserName() {
        return this._proxyUserName;
    }

    public void proxyPassword(Buffer proxyPassword) {
        assert (proxyPassword != null) : "proxyPassword can not be null";
        this.proxyPassword().data(proxyPassword.data(), proxyPassword.position(), proxyPassword.length());
    }

    public Buffer proxyPassword() {
        return this._proxyPassword;
    }

    public void proxyDomain(Buffer proxyDomain) {
        assert (proxyDomain != null) : "proxyDomain can not be null";
        this.proxyDomain().data(proxyDomain.data(), proxyDomain.position(), proxyDomain.length());
    }

    public Buffer proxyDomain() {
        return this._proxyDomain;
    }

    public void proxyLocalHostName(Buffer proxyLocalHostName) {
        assert (proxyLocalHostName != null) : "proxyLocalHostName can not be null";
        this.proxyLocalHostName().data(proxyLocalHostName.data(), proxyLocalHostName.position(), proxyLocalHostName.length());
    }

    public Buffer proxyLocalHostName() {
        return this._proxyLocalHostName;
    }

    public void proxyKRB5ConfigFile(Buffer proxyKRB5ConfigFile) {
        assert (proxyKRB5ConfigFile != null) : "proxyKRB5ConfigFile can not be null";
        this.proxyKRB5ConfigFile().data(proxyKRB5ConfigFile.data(), proxyKRB5ConfigFile.position(), proxyKRB5ConfigFile.length());
    }

    public Buffer proxyKRB5ConfigFile() {
        return this._proxyKrb5ConfigFile;
    }

    public static class RenewalModes {
        public static final int NONE = 0;
        public static final int PASSWORD = 1;
        public static final int PASSWORD_CHANGE = 2;

        private RenewalModes() {
            throw new AssertionError();
        }
    }
}

