/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.directory;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.ConsumerStatusService;

class ConsumerStatusServiceImpl
implements ConsumerStatusService {
    private long serviceId;
    private int action;
    private long sourceMirroringMode;
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private ElementList elementList = CodecFactory.createElementList();
    private ElementEntry elementEntry = CodecFactory.createElementEntry();
    private UInt tmpUInt = CodecFactory.createUInt();
    private StringBuilder stringBuffer = new StringBuilder();
    private int _flags;
    private long _wsbMode;

    ConsumerStatusServiceImpl() {
        this.clear();
    }

    @Override
    public void clear() {
        this.action = 2;
        this.serviceId = 0L;
        this._flags = 1;
        this.sourceMirroringMode = 0L;
        this._wsbMode = 0L;
    }

    @Override
    public int flags() {
        return this._flags;
    }

    @Override
    public void flags(int flags) {
        this._flags = flags;
    }

    @Override
    public int copy(ConsumerStatusService destConsumerStatusService) {
        assert (destConsumerStatusService != null) : "destConsumerStatusService must be non-null";
        destConsumerStatusService.serviceId(this.serviceId());
        destConsumerStatusService.action(this.action());
        if (this.checkHasSourceMirroringMode()) {
            destConsumerStatusService.applyHasSourceMirroringMode();
            destConsumerStatusService.sourceMirroringMode(this.sourceMirroringMode());
        }
        destConsumerStatusService.flags(this.flags());
        if (this.checkHasWarmStandbyMode()) {
            destConsumerStatusService.applyHasWarmStandbyMode();
            destConsumerStatusService.warmStandbyMode(this.warmStandbyMode());
        }
        return 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        this.clear();
        this.elementList.clear();
        int ret = 0;
        ret = this.elementList.decode(dIter, null);
        if (ret < 0) {
            return ret;
        }
        this.elementEntry.clear();
        boolean foundSourceMirroringMode = false;
        boolean foundWarmStandbyMode = false;
        while ((ret = this.elementEntry.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (this.elementEntry.name().equals(ElementNames.SOURCE_MIRROR_MODE)) {
                if (this.elementEntry.dataType() != 4) {
                    return ret;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0 && ret != 15) {
                    return ret;
                }
                this.sourceMirroringMode(this.tmpUInt.toLong());
                this._flags |= 1;
                foundSourceMirroringMode = true;
            }
            if (!this.elementEntry.name().equals(ElementNames.WARMSTANDBY_MODE)) continue;
            if (this.elementEntry.dataType() != 4) {
                return ret;
            }
            ret = this.tmpUInt.decode(dIter);
            if (ret != 0 && ret != 15) {
                return ret;
            }
            this.warmStandbyMode(this.tmpUInt.toLong());
            this._flags |= 2;
            foundWarmStandbyMode = true;
        }
        if (!foundSourceMirroringMode && !foundWarmStandbyMode) {
            return ret;
        }
        return 0;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.elementList.clear();
        this.elementList.applyHasStandardData();
        int ret = this.elementList.encodeInit(encodeIter, null, 0);
        if (ret < 0) {
            return ret;
        }
        if (this.checkHasSourceMirroringMode()) {
            this.elementEntry.clear();
            this.elementEntry.name(ElementNames.SOURCE_MIRROR_MODE);
            this.elementEntry.dataType(4);
            this.tmpUInt.value(this.sourceMirroringMode);
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret < 0) {
                return ret;
            }
        }
        if (this.checkHasWarmStandbyMode()) {
            this.elementEntry.clear();
            this.elementEntry.name(ElementNames.WARMSTANDBY_MODE);
            this.elementEntry.dataType(4);
            this.tmpUInt.value(this._wsbMode);
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret < 0) {
                return ret;
            }
        }
        if ((ret = this.elementList.encodeComplete(encodeIter, true)) < 0) {
            return ret;
        }
        return ret;
    }

    @Override
    public long serviceId() {
        return this.serviceId;
    }

    @Override
    public void serviceId(long serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public int action() {
        return this.action;
    }

    @Override
    public void action(int action) {
        this.action = action;
    }

    @Override
    public long sourceMirroringMode() {
        assert (this.checkHasSourceMirroringMode());
        return this.sourceMirroringMode;
    }

    @Override
    public void sourceMirroringMode(long sourceMirroringMode) {
        this.sourceMirroringMode = sourceMirroringMode;
    }

    @Override
    public boolean checkHasSourceMirroringMode() {
        return (this._flags & 1) != 0;
    }

    @Override
    public void applyHasSourceMirroringMode() {
        this._flags |= 1;
    }

    @Override
    public long warmStandbyMode() {
        assert (this.checkHasWarmStandbyMode());
        return this._wsbMode;
    }

    @Override
    public void warmStandbyMode(long warmStandbyMode) {
        this._wsbMode = warmStandbyMode;
    }

    @Override
    public boolean checkHasWarmStandbyMode() {
        return (this._flags & 2) != 0;
    }

    @Override
    public void applyHasWarmStandbyMode() {
        this._flags |= 2;
    }

    StringBuilder buildStringBuf() {
        this.stringBuffer.setLength(0);
        this.stringBuffer.insert(0, "ConsumerStatusService: \n");
        this.stringBuffer.append(tab);
        this.stringBuffer.append(tab);
        this.stringBuffer.append("action: ");
        this.stringBuffer.append(this.action());
        this.stringBuffer.append(eol);
        this.stringBuffer.append(tab);
        this.stringBuffer.append("serviceId: ");
        this.stringBuffer.append(this.serviceId());
        this.stringBuffer.append(eol);
        if (this.checkHasSourceMirroringMode()) {
            this.stringBuffer.append(tab);
            this.stringBuffer.append("sourceMirroringMode: ");
            this.stringBuffer.append(this.sourceMirroringMode());
            this.stringBuffer.append(eol);
        }
        if (this.checkHasWarmStandbyMode()) {
            this.stringBuffer.append(tab);
            this.stringBuffer.append("warmStandbyMode: ");
            this.stringBuffer.append(this.warmStandbyMode());
            this.stringBuffer.append(eol);
        }
        return this.stringBuffer;
    }

    public String toString() {
        return this.buildStringBuf().toString();
    }
}

