/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.cache;

import com.refinitiv.eta.valueadd.cache.CacheError;
import com.refinitiv.eta.valueadd.cache.CacheErrorImpl;
import com.refinitiv.eta.valueadd.cache.PayloadCache;
import com.refinitiv.eta.valueadd.cache.PayloadCacheConfigOptions;
import com.refinitiv.eta.valueadd.cache.PayloadCacheConfigOptionsImpl;
import com.refinitiv.eta.valueadd.cache.PayloadCacheImpl;
import com.refinitiv.eta.valueadd.cache.PayloadCursor;
import com.refinitiv.eta.valueadd.cache.PayloadCursorImpl;
import com.refinitiv.eta.valueadd.cache.PayloadEntry;
import com.refinitiv.eta.valueadd.cache.PayloadEntryImpl;

public class CacheFactory {
    private CacheFactory() {
        throw new AssertionError();
    }

    public static PayloadCache createPayloadCache(PayloadCacheConfigOptions configOptions, CacheError error) {
        if (error == null) {
            throw new UnsupportedOperationException("CacheFactory.createPayloadCache: error cannot be null, PayloadCache not created.");
        }
        if (configOptions == null) {
            error.errorId(-1);
            error.text("CacheFactory.createPayloadCache error: received invalid cache config options");
            return null;
        }
        return PayloadCacheImpl.create(configOptions, error);
    }

    public static PayloadEntry createPayloadEntry(PayloadCache cacheInstance, CacheError error) {
        if (error == null) {
            throw new UnsupportedOperationException("CacheFactory.createPayloadEntry: error cannot be null, PayloadEntry not created.");
        }
        if (cacheInstance == null) {
            error.errorId(-1);
            error.text("CacheFactory.createPayloadEntry error: received invalid cache instance");
            return null;
        }
        return PayloadEntryImpl.create(cacheInstance, error);
    }

    public static PayloadCursor createPayloadCursor() {
        return PayloadCursorImpl.create();
    }

    public static PayloadCacheConfigOptions createPayloadCacheConfig() {
        return new PayloadCacheConfigOptionsImpl();
    }

    public static CacheError createCacheError() {
        return new CacheErrorImpl();
    }
}

