/*
 * Decompiled with CFR 0.152.
 */
package com.recombee.api_client.bindings;

import com.recombee.api_client.bindings.RecombeeBinding;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Purchase
extends RecombeeBinding {
    protected String userId;
    protected String itemId;
    protected Date timestamp;
    protected Double amount;
    protected Double price;
    protected Double profit;
    protected String recommId;
    protected Map<String, Object> additionalData;

    public Purchase() {
    }

    public Purchase(String userId, String itemId) {
        this.userId = userId;
        this.itemId = itemId;
    }

    public Purchase(String userId, String itemId, Date timestamp, double amount, double price, double profit, String recommId, Map<String, Object> additionalData) {
        this.userId = userId;
        this.itemId = itemId;
        this.timestamp = timestamp;
        this.amount = amount;
        this.price = price;
        this.profit = profit;
        this.recommId = recommId;
        this.additionalData = additionalData;
    }

    public Purchase(Map<String, Object> jsonObject) {
        this.userId = (String)jsonObject.get("userId");
        this.itemId = (String)jsonObject.get("itemId");
        this.amount = (Double)jsonObject.get("amount");
        this.price = (Double)jsonObject.get("price");
        this.profit = (Double)jsonObject.get("profit");
        this.recommId = (String)jsonObject.get("recommId");
        this.additionalData = (Map)jsonObject.get("additionalData");
        Double epoch = 1000.0 * (Double)jsonObject.get("timestamp");
        this.timestamp = new Date(epoch.longValue());
    }

    public void setTimestamp(double epoch) {
        this.timestamp = new Date((long)(1000.0 * epoch));
    }

    public String getUserId() {
        return this.userId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getPrice() {
        return this.price;
    }

    public double getProfit() {
        return this.profit;
    }

    public String getRecommId() {
        return this.recommId;
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.userId).append((Object)this.itemId).append((Object)this.timestamp).append((Object)this.amount).append((Object)this.price).append((Object)this.profit).append((Object)this.recommId).append(this.additionalData).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Purchase)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Purchase rhs = (Purchase)obj;
        return new EqualsBuilder().append((Object)this.userId, (Object)rhs.userId).append((Object)this.itemId, (Object)rhs.itemId).append((Object)this.timestamp, (Object)rhs.timestamp).append((Object)this.amount, (Object)rhs.amount).append((Object)this.price, (Object)rhs.price).append((Object)this.profit, (Object)rhs.profit).append((Object)this.recommId, (Object)rhs.recommId).append(this.additionalData, rhs.additionalData).isEquals();
    }
}

