/*
 * Decompiled with CFR 0.152.
 */
package com.recombee.api_client.api_requests;

import com.recombee.api_client.api_requests.Request;
import com.recombee.api_client.bindings.Logic;
import com.recombee.api_client.util.HTTPMethod;
import java.util.HashMap;
import java.util.Map;

public class RecommendUsersToUser
extends Request {
    protected String userId;
    protected Long count;
    protected String filter;
    protected String booster;
    protected Boolean cascadeCreate;
    protected String scenario;
    protected Logic logic;
    protected Boolean returnProperties;
    protected String[] includedProperties;
    protected Double diversity;
    protected String minRelevance;
    protected Double rotationRate;
    protected Double rotationTime;
    protected Map<String, Object> expertSettings;
    protected Boolean returnAbGroup;

    public RecommendUsersToUser(String userId, long count) {
        this.userId = userId;
        this.count = count;
        this.timeout = 50000L;
    }

    public RecommendUsersToUser setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public RecommendUsersToUser setBooster(String booster) {
        this.booster = booster;
        return this;
    }

    public RecommendUsersToUser setCascadeCreate(boolean cascadeCreate) {
        this.cascadeCreate = cascadeCreate;
        return this;
    }

    public RecommendUsersToUser setScenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    public RecommendUsersToUser setLogic(Logic logic) {
        this.logic = logic;
        return this;
    }

    public RecommendUsersToUser setReturnProperties(boolean returnProperties) {
        this.returnProperties = returnProperties;
        return this;
    }

    public RecommendUsersToUser setIncludedProperties(String[] includedProperties) {
        this.includedProperties = includedProperties;
        return this;
    }

    public RecommendUsersToUser setDiversity(double diversity) {
        this.diversity = diversity;
        return this;
    }

    public RecommendUsersToUser setMinRelevance(String minRelevance) {
        this.minRelevance = minRelevance;
        return this;
    }

    public RecommendUsersToUser setRotationRate(double rotationRate) {
        this.rotationRate = rotationRate;
        return this;
    }

    public RecommendUsersToUser setRotationTime(double rotationTime) {
        this.rotationTime = rotationTime;
        return this;
    }

    public RecommendUsersToUser setExpertSettings(Map<String, Object> expertSettings) {
        this.expertSettings = expertSettings;
        return this;
    }

    public RecommendUsersToUser setReturnAbGroup(boolean returnAbGroup) {
        this.returnAbGroup = returnAbGroup;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public long getCount() {
        return this.count;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getBooster() {
        return this.booster;
    }

    public boolean getCascadeCreate() {
        if (this.cascadeCreate == null) {
            return false;
        }
        return this.cascadeCreate;
    }

    public String getScenario() {
        return this.scenario;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public boolean getReturnProperties() {
        if (this.returnProperties == null) {
            return false;
        }
        return this.returnProperties;
    }

    public String[] getIncludedProperties() {
        return this.includedProperties;
    }

    public double getDiversity() {
        return this.diversity;
    }

    public String getMinRelevance() {
        return this.minRelevance;
    }

    public double getRotationRate() {
        return this.rotationRate;
    }

    public double getRotationTime() {
        return this.rotationTime;
    }

    public Map<String, Object> getExpertSettings() {
        return this.expertSettings;
    }

    public boolean getReturnAbGroup() {
        if (this.returnAbGroup == null) {
            return false;
        }
        return this.returnAbGroup;
    }

    @Override
    public HTTPMethod getHTTPMethod() {
        return HTTPMethod.POST;
    }

    @Override
    public String getPath() {
        return String.format("/recomms/users/%s/users/", this.userId);
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return params;
    }

    @Override
    public Map<String, Object> getBodyParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("count", this.count);
        if (this.filter != null) {
            params.put("filter", this.filter);
        }
        if (this.booster != null) {
            params.put("booster", this.booster);
        }
        if (this.cascadeCreate != null) {
            params.put("cascadeCreate", this.cascadeCreate);
        }
        if (this.scenario != null) {
            params.put("scenario", this.scenario);
        }
        if (this.logic != null) {
            params.put("logic", this.logic);
        }
        if (this.returnProperties != null) {
            params.put("returnProperties", this.returnProperties);
        }
        if (this.includedProperties != null) {
            params.put("includedProperties", this.includedProperties);
        }
        if (this.diversity != null) {
            params.put("diversity", this.diversity);
        }
        if (this.minRelevance != null) {
            params.put("minRelevance", this.minRelevance);
        }
        if (this.rotationRate != null) {
            params.put("rotationRate", this.rotationRate);
        }
        if (this.rotationTime != null) {
            params.put("rotationTime", this.rotationTime);
        }
        if (this.expertSettings != null) {
            params.put("expertSettings", this.expertSettings);
        }
        if (this.returnAbGroup != null) {
            params.put("returnAbGroup", this.returnAbGroup);
        }
        return params;
    }
}

