/*
 * Decompiled with CFR 0.152.
 */
package com.recombee.api_client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.recombee.api_client.api_requests.Batch;
import com.recombee.api_client.api_requests.GetItemPropertyInfo;
import com.recombee.api_client.api_requests.GetItemValues;
import com.recombee.api_client.api_requests.GetUserPropertyInfo;
import com.recombee.api_client.api_requests.GetUserValues;
import com.recombee.api_client.api_requests.ItemBasedRecommendation;
import com.recombee.api_client.api_requests.ListGroupItems;
import com.recombee.api_client.api_requests.ListGroups;
import com.recombee.api_client.api_requests.ListItemBookmarks;
import com.recombee.api_client.api_requests.ListItemCartAdditions;
import com.recombee.api_client.api_requests.ListItemDetailViews;
import com.recombee.api_client.api_requests.ListItemProperties;
import com.recombee.api_client.api_requests.ListItemPurchases;
import com.recombee.api_client.api_requests.ListItemRatings;
import com.recombee.api_client.api_requests.ListItemViewPortions;
import com.recombee.api_client.api_requests.ListItems;
import com.recombee.api_client.api_requests.ListSeries;
import com.recombee.api_client.api_requests.ListSeriesItems;
import com.recombee.api_client.api_requests.ListUserBookmarks;
import com.recombee.api_client.api_requests.ListUserCartAdditions;
import com.recombee.api_client.api_requests.ListUserDetailViews;
import com.recombee.api_client.api_requests.ListUserProperties;
import com.recombee.api_client.api_requests.ListUserPurchases;
import com.recombee.api_client.api_requests.ListUserRatings;
import com.recombee.api_client.api_requests.ListUserViewPortions;
import com.recombee.api_client.api_requests.ListUsers;
import com.recombee.api_client.api_requests.RecommendItemsToItem;
import com.recombee.api_client.api_requests.RecommendItemsToUser;
import com.recombee.api_client.api_requests.RecommendUsersToItem;
import com.recombee.api_client.api_requests.RecommendUsersToUser;
import com.recombee.api_client.api_requests.Request;
import com.recombee.api_client.api_requests.UserBasedRecommendation;
import com.recombee.api_client.bindings.BatchResponse;
import com.recombee.api_client.bindings.Bookmark;
import com.recombee.api_client.bindings.CartAddition;
import com.recombee.api_client.bindings.DetailView;
import com.recombee.api_client.bindings.Group;
import com.recombee.api_client.bindings.GroupItem;
import com.recombee.api_client.bindings.Item;
import com.recombee.api_client.bindings.PropertyInfo;
import com.recombee.api_client.bindings.Purchase;
import com.recombee.api_client.bindings.Rating;
import com.recombee.api_client.bindings.RecombeeBinding;
import com.recombee.api_client.bindings.Recommendation;
import com.recombee.api_client.bindings.RecommendationResponse;
import com.recombee.api_client.bindings.Series;
import com.recombee.api_client.bindings.SeriesItem;
import com.recombee.api_client.bindings.User;
import com.recombee.api_client.bindings.ViewPortion;
import com.recombee.api_client.exceptions.ApiException;
import com.recombee.api_client.exceptions.ApiTimeoutException;
import com.recombee.api_client.exceptions.ResponseException;
import com.recombee.api_client.util.NetworkApplicationProtocol;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Hex;

public class RecombeeClient {
    String databaseId;
    String token;
    NetworkApplicationProtocol defaultProtocol = NetworkApplicationProtocol.HTTPS;
    String baseUri = "rapi.recombee.com";
    ObjectMapper mapper;
    final int BATCH_MAX_SIZE = 10000;
    final String USER_AGENT = "recombee-java-api-client/2.4.2";
    private final OkHttpClient httpClient = new OkHttpClient();

    public RecombeeClient(String databaseId, String token) {
        this.databaseId = databaseId;
        this.token = token;
        this.mapper = new ObjectMapper();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.mapper.setDateFormat((DateFormat)df);
        if (System.getenv("RAPI_URI") != null) {
            this.baseUri = System.getenv("RAPI_URI");
        }
    }

    public NetworkApplicationProtocol getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(NetworkApplicationProtocol defaultProtocol) {
        this.defaultProtocol = defaultProtocol;
    }

    public PropertyInfo send(GetItemPropertyInfo request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (PropertyInfo)this.mapper.readValue(responseStr, PropertyInfo.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PropertyInfo[] send(ListItemProperties request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (PropertyInfo[])this.mapper.readValue(responseStr, PropertyInfo[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Series[] send(ListSeries request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Series[])this.mapper.readValue(responseStr, Series[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SeriesItem[] send(ListSeriesItems request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (SeriesItem[])this.mapper.readValue(responseStr, SeriesItem[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Group[] send(ListGroups request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Group[])this.mapper.readValue(responseStr, Group[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GroupItem[] send(ListGroupItems request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (GroupItem[])this.mapper.readValue(responseStr, GroupItem[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PropertyInfo send(GetUserPropertyInfo request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (PropertyInfo)this.mapper.readValue(responseStr, PropertyInfo.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PropertyInfo[] send(ListUserProperties request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (PropertyInfo[])this.mapper.readValue(responseStr, PropertyInfo[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DetailView[] send(ListItemDetailViews request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (DetailView[])this.mapper.readValue(responseStr, DetailView[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DetailView[] send(ListUserDetailViews request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (DetailView[])this.mapper.readValue(responseStr, DetailView[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Purchase[] send(ListItemPurchases request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Purchase[])this.mapper.readValue(responseStr, Purchase[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Purchase[] send(ListUserPurchases request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Purchase[])this.mapper.readValue(responseStr, Purchase[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Rating[] send(ListItemRatings request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Rating[])this.mapper.readValue(responseStr, Rating[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Rating[] send(ListUserRatings request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Rating[])this.mapper.readValue(responseStr, Rating[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CartAddition[] send(ListItemCartAdditions request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (CartAddition[])this.mapper.readValue(responseStr, CartAddition[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CartAddition[] send(ListUserCartAdditions request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (CartAddition[])this.mapper.readValue(responseStr, CartAddition[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bookmark[] send(ListItemBookmarks request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Bookmark[])this.mapper.readValue(responseStr, Bookmark[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bookmark[] send(ListUserBookmarks request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Bookmark[])this.mapper.readValue(responseStr, Bookmark[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ViewPortion[] send(ListItemViewPortions request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (ViewPortion[])this.mapper.readValue(responseStr, ViewPortion[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ViewPortion[] send(ListUserViewPortions request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (ViewPortion[])this.mapper.readValue(responseStr, ViewPortion[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RecommendationResponse send(RecommendItemsToUser request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (RecommendationResponse)this.mapper.readValue(responseStr, RecommendationResponse.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RecommendationResponse send(RecommendUsersToUser request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (RecommendationResponse)this.mapper.readValue(responseStr, RecommendationResponse.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RecommendationResponse send(RecommendItemsToItem request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (RecommendationResponse)this.mapper.readValue(responseStr, RecommendationResponse.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RecommendationResponse send(RecommendUsersToItem request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (RecommendationResponse)this.mapper.readValue(responseStr, RecommendationResponse.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BatchResponse[] send(Batch batchRequest) throws ApiException {
        if (batchRequest.getRequests().size() > this.BATCH_MAX_SIZE) {
            return this.sendMultipartBatchRequest(batchRequest);
        }
        String responseStr = this.sendRequest(batchRequest);
        try {
            Object[] responses = (Object[])this.mapper.readValue(responseStr, Object[].class);
            BatchResponse[] result = new BatchResponse[responses.length];
            for (int i = 0; i < responses.length; ++i) {
                RecombeeBinding[] ar;
                ArrayList array;
                Map obj;
                int j;
                ArrayList array2;
                Map response = (Map)responses[i];
                int status = (Integer)response.get("code");
                Object parsedResponse = response.get("json");
                Request request = batchRequest.getRequests().get(i);
                if (status != 200 && status != 201) {
                    Map exceptionMap = (Map)parsedResponse;
                    parsedResponse = new ResponseException(request, status, (String)exceptionMap.get("error"));
                } else if (request instanceof ItemBasedRecommendation || request instanceof UserBasedRecommendation) {
                    Recommendation[] ar2;
                    boolean returnProperties = false;
                    if (request instanceof ItemBasedRecommendation) {
                        returnProperties = ((ItemBasedRecommendation)request).getReturnProperties();
                    }
                    if (request instanceof UserBasedRecommendation) {
                        returnProperties = ((UserBasedRecommendation)request).getReturnProperties();
                    }
                    if (returnProperties) {
                        array2 = (ArrayList)parsedResponse;
                        ar2 = new Recommendation[array2.size()];
                        for (j = 0; j < ar2.length; ++j) {
                            ar2[j] = new Recommendation((String)((Map)array2.get(j)).get("itemId"), (Map)array2.get(j));
                        }
                        parsedResponse = ar2;
                    } else {
                        array2 = (ArrayList)parsedResponse;
                        ar2 = new Recommendation[array2.size()];
                        for (j = 0; j < ar2.length; ++j) {
                            ar2[j] = new Recommendation((String)array2.get(j));
                        }
                        parsedResponse = ar2;
                    }
                } else if (request instanceof ListItems) {
                    Item[] ar3;
                    boolean returnProperties = ((ListItems)request).getReturnProperties();
                    if (returnProperties) {
                        array2 = (ArrayList)parsedResponse;
                        ar3 = new Item[array2.size()];
                        for (j = 0; j < ar3.length; ++j) {
                            ar3[j] = new Item((String)((Map)array2.get(j)).get("itemId"), (Map)array2.get(j));
                        }
                        parsedResponse = ar3;
                    } else {
                        array2 = (ArrayList)parsedResponse;
                        ar3 = new Item[array2.size()];
                        for (j = 0; j < ar3.length; ++j) {
                            ar3[j] = new Item((String)array2.get(j));
                        }
                        parsedResponse = ar3;
                    }
                } else if (request instanceof ListUsers) {
                    User[] ar4;
                    boolean returnProperties = ((ListUsers)request).getReturnProperties();
                    if (returnProperties) {
                        array2 = (ArrayList)parsedResponse;
                        ar4 = new User[array2.size()];
                        for (j = 0; j < ar4.length; ++j) {
                            ar4[j] = new User((String)((Map)array2.get(j)).get("userId"), (Map)array2.get(j));
                        }
                        parsedResponse = ar4;
                    } else {
                        array2 = (ArrayList)parsedResponse;
                        ar4 = new User[array2.size()];
                        for (j = 0; j < ar4.length; ++j) {
                            ar4[j] = new User((String)array2.get(j));
                        }
                        parsedResponse = ar4;
                    }
                } else if (request instanceof RecommendItemsToUser || request instanceof RecommendUsersToUser || request instanceof RecommendItemsToItem || request instanceof RecommendUsersToItem) {
                    parsedResponse = this.mapper.convertValue(parsedResponse, RecommendationResponse.class);
                } else if (request instanceof GetItemPropertyInfo) {
                    obj = (Map)parsedResponse;
                    parsedResponse = new PropertyInfo(obj);
                } else if (request instanceof ListItemProperties) {
                    array = (ArrayList)parsedResponse;
                    ar = new PropertyInfo[array.size()];
                    for (int j2 = 0; j2 < ar.length; ++j2) {
                        ar[j2] = new PropertyInfo((Map)array.get(j2));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListSeries) {
                    array = (ArrayList)parsedResponse;
                    ar = new Series[array.size()];
                    for (int j3 = 0; j3 < ar.length; ++j3) {
                        ar[j3] = new Series((String)array.get(j3));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListSeriesItems) {
                    array = (ArrayList)parsedResponse;
                    ar = new SeriesItem[array.size()];
                    for (int j4 = 0; j4 < ar.length; ++j4) {
                        ar[j4] = new SeriesItem((Map)array.get(j4));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListGroups) {
                    array = (ArrayList)parsedResponse;
                    ar = new Group[array.size()];
                    for (int j5 = 0; j5 < ar.length; ++j5) {
                        ar[j5] = new Group((String)array.get(j5));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListGroupItems) {
                    array = (ArrayList)parsedResponse;
                    ar = new GroupItem[array.size()];
                    for (int j6 = 0; j6 < ar.length; ++j6) {
                        ar[j6] = new GroupItem((Map)array.get(j6));
                    }
                    parsedResponse = ar;
                } else if (request instanceof GetUserPropertyInfo) {
                    obj = (Map)parsedResponse;
                    parsedResponse = new PropertyInfo(obj);
                } else if (request instanceof ListUserProperties) {
                    array = (ArrayList)parsedResponse;
                    ar = new PropertyInfo[array.size()];
                    for (int j7 = 0; j7 < ar.length; ++j7) {
                        ar[j7] = new PropertyInfo((Map)array.get(j7));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListItemDetailViews) {
                    array = (ArrayList)parsedResponse;
                    ar = new DetailView[array.size()];
                    for (int j8 = 0; j8 < ar.length; ++j8) {
                        ar[j8] = new DetailView((Map)array.get(j8));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListUserDetailViews) {
                    array = (ArrayList)parsedResponse;
                    ar = new DetailView[array.size()];
                    for (int j9 = 0; j9 < ar.length; ++j9) {
                        ar[j9] = new DetailView((Map)array.get(j9));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListItemPurchases) {
                    array = (ArrayList)parsedResponse;
                    ar = new Purchase[array.size()];
                    for (int j10 = 0; j10 < ar.length; ++j10) {
                        ar[j10] = new Purchase((Map)array.get(j10));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListUserPurchases) {
                    array = (ArrayList)parsedResponse;
                    ar = new Purchase[array.size()];
                    for (int j11 = 0; j11 < ar.length; ++j11) {
                        ar[j11] = new Purchase((Map)array.get(j11));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListItemRatings) {
                    array = (ArrayList)parsedResponse;
                    ar = new Rating[array.size()];
                    for (int j12 = 0; j12 < ar.length; ++j12) {
                        ar[j12] = new Rating((Map)array.get(j12));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListUserRatings) {
                    array = (ArrayList)parsedResponse;
                    ar = new Rating[array.size()];
                    for (int j13 = 0; j13 < ar.length; ++j13) {
                        ar[j13] = new Rating((Map)array.get(j13));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListItemCartAdditions) {
                    array = (ArrayList)parsedResponse;
                    ar = new CartAddition[array.size()];
                    for (int j14 = 0; j14 < ar.length; ++j14) {
                        ar[j14] = new CartAddition((Map)array.get(j14));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListUserCartAdditions) {
                    array = (ArrayList)parsedResponse;
                    ar = new CartAddition[array.size()];
                    for (int j15 = 0; j15 < ar.length; ++j15) {
                        ar[j15] = new CartAddition((Map)array.get(j15));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListItemBookmarks) {
                    array = (ArrayList)parsedResponse;
                    ar = new Bookmark[array.size()];
                    for (int j16 = 0; j16 < ar.length; ++j16) {
                        ar[j16] = new Bookmark((Map)array.get(j16));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListUserBookmarks) {
                    array = (ArrayList)parsedResponse;
                    ar = new Bookmark[array.size()];
                    for (int j17 = 0; j17 < ar.length; ++j17) {
                        ar[j17] = new Bookmark((Map)array.get(j17));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListItemViewPortions) {
                    array = (ArrayList)parsedResponse;
                    ar = new ViewPortion[array.size()];
                    for (int j18 = 0; j18 < ar.length; ++j18) {
                        ar[j18] = new ViewPortion((Map)array.get(j18));
                    }
                    parsedResponse = ar;
                } else if (request instanceof ListUserViewPortions) {
                    array = (ArrayList)parsedResponse;
                    ar = new ViewPortion[array.size()];
                    for (int j19 = 0; j19 < ar.length; ++j19) {
                        ar[j19] = new ViewPortion((Map)array.get(j19));
                    }
                    parsedResponse = ar;
                }
                result[i] = new BatchResponse(status, parsedResponse);
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BatchResponse[] sendMultipartBatchRequest(Batch batchRequest) throws ApiException {
        List<List<Request>> requestChunks = this.getRequestsChunks(batchRequest);
        ArrayList<BatchResponse[]> responses = new ArrayList<BatchResponse[]>();
        for (List<Request> rqs : requestChunks) {
            responses.add(this.send(new Batch(rqs)));
        }
        return this.concatenateResponses(responses);
    }

    private List<List<Request>> getRequestsChunks(Batch batchRequest) {
        ArrayList<List<Request>> result = new ArrayList<List<Request>>();
        List<Request> requests = batchRequest.getRequests();
        int fullparts = requests.size() / this.BATCH_MAX_SIZE;
        for (int i = 0; i < fullparts; ++i) {
            result.add(requests.subList(i * this.BATCH_MAX_SIZE, (i + 1) * this.BATCH_MAX_SIZE));
        }
        if (fullparts * this.BATCH_MAX_SIZE < requests.size()) {
            result.add(requests.subList(fullparts * this.BATCH_MAX_SIZE, requests.size()));
        }
        return result;
    }

    private BatchResponse[] concatenateResponses(ArrayList<BatchResponse[]> responses) {
        int size = 0;
        int i = 0;
        for (BatchResponse[] rsps : responses) {
            size += rsps.length;
        }
        BatchResponse[] result = new BatchResponse[size];
        for (BatchResponse[] rsps : responses) {
            for (BatchResponse rsp : rsps) {
                result[i++] = rsp;
            }
        }
        return result;
    }

    public Map<String, Object> send(GetItemValues request) throws ApiException {
        String responseStr = this.sendRequest(request);
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)this.mapper.readValue(responseStr, (TypeReference)typeRef);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> send(GetUserValues request) throws ApiException {
        String responseStr = this.sendRequest(request);
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)this.mapper.readValue(responseStr, (TypeReference)typeRef);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Recommendation[] send(UserBasedRecommendation request) throws ApiException {
        return this.sendDeprecatedRecomm(request);
    }

    public Recommendation[] send(ItemBasedRecommendation request) throws ApiException {
        return this.sendDeprecatedRecomm(request);
    }

    protected Recommendation[] sendDeprecatedRecomm(Request request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Recommendation[])this.mapper.readValue(responseStr, Recommendation[].class);
        }
        catch (IOException e) {
            TypeReference<HashMap<String, Object>[]> typeRef = new TypeReference<HashMap<String, Object>[]>(){};
            try {
                Map[] valsArray = (Map[])this.mapper.readValue(responseStr, (TypeReference)typeRef);
                Recommendation[] recomms = new Recommendation[valsArray.length];
                for (int i = 0; i < valsArray.length; ++i) {
                    recomms[i] = new Recommendation((String)valsArray[i].get("itemId"), valsArray[i]);
                }
                return recomms;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public Item[] send(ListItems request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (Item[])this.mapper.readValue(responseStr, Item[].class);
        }
        catch (IOException e) {
            TypeReference<HashMap<String, Object>[]> typeRef = new TypeReference<HashMap<String, Object>[]>(){};
            try {
                Map[] valsArray = (Map[])this.mapper.readValue(responseStr, (TypeReference)typeRef);
                Item[] recomms = new Item[valsArray.length];
                for (int i = 0; i < valsArray.length; ++i) {
                    recomms[i] = new Item((String)valsArray[i].get("itemId"), valsArray[i]);
                }
                return recomms;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public User[] send(ListUsers request) throws ApiException {
        String responseStr = this.sendRequest(request);
        try {
            return (User[])this.mapper.readValue(responseStr, User[].class);
        }
        catch (IOException e) {
            TypeReference<HashMap<String, Object>[]> typeRef = new TypeReference<HashMap<String, Object>[]>(){};
            try {
                Map[] valsArray = (Map[])this.mapper.readValue(responseStr, (TypeReference)typeRef);
                User[] recomms = new User[valsArray.length];
                for (int i = 0; i < valsArray.length; ++i) {
                    recomms[i] = new User((String)valsArray[i].get("userId"), valsArray[i]);
                }
                return recomms;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public String send(Request request) throws ApiException {
        return this.sendRequest(request);
    }

    private String sendRequest(Request request) throws ApiException {
        String signedUri = this.signUrl(this.processRequestUri(request));
        String protocolStr = request.getEnsureHttps() ? "https" : this.defaultProtocol.name().toLowerCase();
        String uri = protocolStr + "://" + this.baseUri + signedUri;
        OkHttpClient tempClient = this.httpClient.newBuilder().connectTimeout(request.getTimeout(), TimeUnit.MILLISECONDS).readTimeout(request.getTimeout(), TimeUnit.MILLISECONDS).writeTimeout(request.getTimeout(), TimeUnit.MILLISECONDS).build();
        Request.Builder httpRequestBuilder = new Request.Builder().url(uri).addHeader("User-Agent", this.USER_AGENT);
        switch (request.getHTTPMethod()) {
            case GET: {
                break;
            }
            case POST: {
                httpRequestBuilder = this.post(httpRequestBuilder, request);
                break;
            }
            case PUT: {
                httpRequestBuilder = this.put(httpRequestBuilder, request);
                break;
            }
            case DELETE: {
                httpRequestBuilder.delete();
            }
        }
        try {
            Response response = tempClient.newCall(httpRequestBuilder.build()).execute();
            this.checkErrors(response, request);
            return response.body().string();
        }
        catch (InterruptedIOException e) {
            throw new ApiTimeoutException(request);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String signUrl(String url) {
        url = url + (url.contains("?") ? "&" : "?") + "hmac_timestamp=" + System.currentTimeMillis() / 1000L;
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secret = new SecretKeySpec(this.token.getBytes(), "HmacSHA1");
            mac.init(secret);
            byte[] rawHmac = mac.doFinal(url.getBytes());
            String sign = Hex.encodeHexString((byte[])rawHmac);
            return url + "&hmac_sign=" + sign;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String processRequestUri(Request request) {
        String uri = "/" + this.databaseId + request.getPath();
        uri = this.appendQueryParameters(uri, request);
        return uri;
    }

    private String appendQueryParameters(String uri, Request request) {
        for (Map.Entry<String, Object> pair : request.getQueryParameters().entrySet()) {
            uri = uri + (uri.contains("?") ? "&" : "?");
            uri = uri + pair.getKey() + "=" + this.formatQueryParameterValue(pair.getValue());
        }
        return uri;
    }

    private String formatQueryParameterValue(Object val) {
        try {
            return URLEncoder.encode(val.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Request.Builder put(Request.Builder reqBuilder, Request req) {
        try {
            String json = this.mapper.writeValueAsString(req.getBodyParameters());
            MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
            reqBuilder.put(RequestBody.create((MediaType)JSON, (String)json)).addHeader("Content-Type", "application/json; charset=utf-8");
            return reqBuilder;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Request.Builder post(Request.Builder reqBuilder, Request req) {
        try {
            String json = this.mapper.writeValueAsString(req.getBodyParameters());
            MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
            reqBuilder.post(RequestBody.create((MediaType)JSON, (String)json)).addHeader("Content-Type", "application/json; charset=utf-8");
            return reqBuilder;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void checkErrors(Response response, Request request) throws ResponseException {
        if (response.code() == 200 || response.code() == 201) {
            return;
        }
        try {
            throw new ResponseException(request, response.code(), response.body().string());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResponseException(request, response.code(), "Failed to read the error from response");
        }
    }
}

