/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiClient;
import com.razorpay.BankAccount;
import com.razorpay.Customer;
import com.razorpay.RazorpayException;
import com.razorpay.Token;
import java.util.List;
import org.json.JSONObject;

public class CustomerClient
extends ApiClient {
    CustomerClient(String auth) {
        super(auth);
    }

    public Customer create(JSONObject request) throws RazorpayException {
        return (Customer)this.post("v1", "customers", request);
    }

    public Customer fetch(String id) throws RazorpayException {
        return (Customer)this.get("v1", String.format("customers/%s", id), null);
    }

    public Customer edit(String id, JSONObject request) throws RazorpayException {
        return (Customer)this.put("v1", String.format("customers/%s", id), request);
    }

    public List<Customer> fetchAll() throws RazorpayException {
        return this.fetchAll(null);
    }

    public List<Customer> fetchAll(JSONObject request) throws RazorpayException {
        return this.getCollection("v1", "customers", request);
    }

    public List<Token> fetchTokens(String id) throws RazorpayException {
        return this.getCollection("v1", String.format("customers/%s/tokens", id), null);
    }

    public Token fetchToken(String id, String tokenId) throws RazorpayException {
        return (Token)this.get("v1", String.format("customers/%s/tokens/%s", id, tokenId), null);
    }

    public Customer deleteToken(String id, String tokenId) throws RazorpayException {
        return (Customer)this.delete("v1", String.format("customers/%s/tokens/%s", id, tokenId), null);
    }

    public BankAccount addBankAccount(String id, JSONObject request) throws RazorpayException {
        return (BankAccount)this.post("v1", String.format("customers/%s/bank_account", id), request);
    }

    public Customer deleteBankAccount(String id, String bankId) throws RazorpayException {
        return (Customer)this.delete("v1", String.format("customers/%s/bank_account/%s", id, bankId), null);
    }

    public Customer requestEligibilityCheck(JSONObject request) throws RazorpayException {
        return (Customer)this.post("v1", "customers/eligibility", request);
    }

    public Customer fetchEligibility(String id) throws RazorpayException {
        return (Customer)this.get("v1", String.format("customers/eligibility/%s", id), null);
    }
}

