/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiClient;
import com.razorpay.RazorpayException;
import com.razorpay.Reversal;
import com.razorpay.Transfer;
import java.util.List;
import org.json.JSONObject;

public class TransferClient
extends ApiClient {
    TransferClient(String auth) {
        super(auth);
    }

    public Transfer create(JSONObject request) throws RazorpayException {
        return (Transfer)this.post("v1", "transfers", request);
    }

    public Transfer edit(String id, JSONObject request) throws RazorpayException {
        return (Transfer)this.patch("v1", String.format("transfers/%s", id), request);
    }

    public Reversal reversal(String id, JSONObject request) throws RazorpayException {
        return (Reversal)this.post("v1", String.format("transfers/%s/reversals", id), request);
    }

    public Transfer fetch(String id) throws RazorpayException {
        return (Transfer)this.get("v1", String.format("transfers/%s", id), null);
    }

    public List<Reversal> fetchReversal(String id) throws RazorpayException {
        return this.getCollection("v1", String.format("transfers/%s/reversals", id), null);
    }

    public List<Transfer> fetchAll() throws RazorpayException {
        return this.fetchAll(null);
    }

    public List<Transfer> fetchAll(JSONObject request) throws RazorpayException {
        return this.getCollection("v1", "transfers", request);
    }
}

