/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.Constants;
import com.razorpay.RazorpayException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiUtils {
    private static OkHttpClient client;
    private static Map<String, String> headers;
    private static String version;

    ApiUtils() {
    }

    static void createHttpClientInstance(boolean enableLogging) throws RazorpayException {
        if (client == null) {
            client = new OkHttpClient.Builder().build();
        }
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        if (enableLogging) {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        } else {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        }
        client = client.newBuilder().addInterceptor((Interceptor)loggingInterceptor).build();
        Properties properties = new Properties();
        try {
            properties.load(ApiUtils.class.getResourceAsStream("/project.properties"));
            version = (String)properties.get("version");
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
    }

    static Response postRequest(String path, JSONObject requestObject, String auth) throws RazorpayException {
        HttpUrl.Builder builder = ApiUtils.getBuilder(path);
        String requestContent = requestObject == null ? "" : requestObject.toString();
        RequestBody requestBody = RequestBody.create((MediaType)Constants.MEDIA_TYPE_JSON, (String)requestContent);
        Request request = ApiUtils.createRequest(Method.POST.name(), builder.build().toString(), requestBody, auth);
        return ApiUtils.processRequest(request);
    }

    static Response putRequest(String path, JSONObject requestObject, String auth) throws RazorpayException {
        HttpUrl.Builder builder = ApiUtils.getBuilder(path);
        String requestContent = requestObject == null ? "" : requestObject.toString();
        RequestBody requestBody = RequestBody.create((MediaType)Constants.MEDIA_TYPE_JSON, (String)requestContent);
        Request request = ApiUtils.createRequest(Method.PUT.name(), builder.build().toString(), requestBody, auth);
        return ApiUtils.processRequest(request);
    }

    static Response getRequest(String path, JSONObject requestObject, String auth) throws RazorpayException {
        HttpUrl.Builder builder = ApiUtils.getBuilder(path);
        ApiUtils.addQueryParams(builder, requestObject);
        Request request = ApiUtils.createRequest(Method.GET.name(), builder.build().toString(), null, auth);
        return ApiUtils.processRequest(request);
    }

    private static HttpUrl.Builder getBuilder(String path) {
        return new HttpUrl.Builder().scheme("https").host("api.razorpay.com").port(Constants.PORT.intValue()).addPathSegment("v1").addPathSegments(path);
    }

    private static Request createRequest(String method, String url, RequestBody requestBody, String auth) {
        Request.Builder builder = new Request.Builder().url(url).addHeader("Authorization", auth);
        builder.addHeader("User-Agent", "Razorpay/v1 JAVASDK/" + version + " Java/" + System.getProperty("java.version"));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        return builder.method(method, requestBody).build();
    }

    private static void addQueryParams(HttpUrl.Builder builder, JSONObject request) {
        if (request == null) {
            return;
        }
        Iterator keys = request.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            builder.addQueryParameter(key, request.get(key).toString());
        }
    }

    private static Response processRequest(Request request) throws RazorpayException {
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
    }

    static void addHeaders(Map<String, String> header) {
        headers.putAll(header);
    }

    static {
        headers = new HashMap<String, String>();
        version = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        GET,
        POST,
        PUT;

    }
}

