/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.log4j;

import com.rapid7.net.AsyncLogger;
import com.rapid7.net.LoggerConfiguration;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class LogentriesAppender
extends AppenderSkeleton {
    AsyncLogger iopsAsync;
    private final LoggerConfiguration.Builder configurationBuilder = new LoggerConfiguration.Builder();

    public void setToken(String token) {
        this.configurationBuilder.useToken(token);
    }

    public void setRegion(String region) {
        this.configurationBuilder.inRegion(region);
    }

    public void setHttpPut(boolean httpPut) {
        this.configurationBuilder.useHttpPut(httpPut);
    }

    public void setKey(String accountKey) {
        this.configurationBuilder.useAccountKey(accountKey);
    }

    public void setLocation(String logLocation) {
        this.configurationBuilder.httpPutLocation(logLocation);
    }

    public void setSsl(boolean ssl) {
        this.configurationBuilder.useSSL(ssl);
    }

    public void setDebug(boolean debug) {
        this.configurationBuilder.runInDebugMode(debug);
    }

    public void setIsUsingDataHub(boolean useDataHub) {
        this.configurationBuilder.useDataHub(useDataHub);
    }

    public void setDataHubAddr(String dataHubAddr) {
        this.configurationBuilder.toServerAddress(dataHubAddr);
    }

    public void setDataHubPort(int dataHubPort) {
        this.configurationBuilder.toServerPort(dataHubPort);
    }

    public void setLogHostName(boolean logHostName) {
        this.configurationBuilder.logHostNameAsPrefix(logHostName);
    }

    public void setHostName(String hostName) {
        this.configurationBuilder.useAsHostName(hostName);
    }

    public void setLogID(String logID) {
        this.configurationBuilder.setLogIdPrefix(logID);
    }

    protected void append(LoggingEvent event) {
        String[] stack;
        String formattedEvent = this.layout.format(event);
        if (this.layout.ignoresThrowable() && (stack = event.getThrowableStrRep()) != null) {
            int len = stack.length;
            formattedEvent = formattedEvent + ", ";
            for (int i = 0; i < len; ++i) {
                formattedEvent = formattedEvent + stack[i];
                if (i >= len - 1) continue;
                formattedEvent = formattedEvent + "\u2028";
            }
        }
        this.iopsAsync.addLineToQueue(formattedEvent);
    }

    public void close() {
        this.iopsAsync.close();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        this.iopsAsync = new AsyncLogger(this.configurationBuilder.build());
        super.activateOptions();
    }
}

