/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.tcshare.utils.CameraUtils;

public class CameraSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = CameraSurfaceView.class.getSimpleName();
    private SurfaceHolder mSurfaceHolder;

    public CameraSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public CameraSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CameraSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mSurfaceHolder = this.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        CameraUtils.openFrontalCamera();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        CameraUtils.getmCamera().startFaceDetection();
        CameraUtils.setPreviewSize(CameraUtils.getmCamera(), width, height);
        CameraUtils.setPictureSize(CameraUtils.getmCamera(), width, height);
        CameraUtils.startPreviewDisplay(holder);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        CameraUtils.getmCamera().stopFaceDetection();
        CameraUtils.releaseCamera();
    }
}

