/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import org.tcshare.androidutils.R;

public class BottomListDialog {
    public static void showSimpleDialog(Context ctx, OnItemClickListener listener, String[] ... groups) {
        BottomListDialog.showSimpleDialog(ctx, listener, R.layout.dialog_bottom_item, R.id.text, groups);
    }

    public static void showSimpleDialog(Context ctx, OnItemClickListener listener, int itemDividerColor, String[] ... groups) {
        int transColor = ctx.getResources().getColor(17170445);
        BottomListDialog.showDialog(ctx, R.layout.dialog_bottom_container, R.layout.dialog_bottom_group, R.layout.dialog_bottom_item, R.id.text, 12, 1, transColor, itemDividerColor, listener, groups);
    }

    public static void showSimpleDialog(Context ctx, OnItemClickListener listener, int itemLayout, int itemTextId, String[] ... groups) {
        int transColor = ctx.getResources().getColor(17170445);
        BottomListDialog.showDialog(ctx, R.layout.dialog_bottom_container, R.layout.dialog_bottom_group, itemLayout, itemTextId, 12, 1, transColor, -3355444, listener, groups);
    }

    public static void showDialog(Context ctx, int containerLayout, int groupLayout, int itemLayout, int itemTextId, int groupDivderHeight, int itemDividerHeight, int groupDividerColor, int itemDividerColor, OnItemClickListener listener, String[] ... groups) {
        BottomSheetDialog dialog = new BottomSheetDialog(ctx, R.style.BottomListSheetDialogTheme);
        ViewGroup dialogBg = (ViewGroup)LayoutInflater.from((Context)ctx).inflate(containerLayout, null, false);
        int oneDP = (int)BottomListDialog.dip2px(ctx, 1.0f);
        int pos = 0;
        for (int i = 0; i < groups.length; ++i) {
            ViewGroup groupBG = (ViewGroup)LayoutInflater.from((Context)ctx).inflate(groupLayout, null, false);
            for (int k = 0; k < groups[i].length; ++k) {
                View itemView = LayoutInflater.from((Context)ctx).inflate(itemLayout, null, false);
                TextView itemTextView = (TextView)itemView.findViewById(itemTextId);
                itemTextView.setText((CharSequence)groups[i][k]);
                BottomListDialog.recursiveSetOnClickListener(itemView, pos++, listener, dialog);
                View itemDivider = new View(ctx);
                itemDivider.setLayoutParams(new ViewGroup.LayoutParams(-1, itemDividerHeight * oneDP));
                itemDivider.setBackgroundColor(itemDividerColor);
                groupBG.addView(itemView);
                groupBG.addView(itemDivider);
            }
            groupBG.removeViewAt(groupBG.getChildCount() - 1);
            View groupDivider = new View(ctx);
            groupDivider.setLayoutParams(new ViewGroup.LayoutParams(-1, groupDivderHeight * oneDP));
            groupDivider.setBackgroundColor(groupDividerColor);
            dialogBg.addView((View)groupBG);
            dialogBg.addView(groupDivider);
        }
        dialogBg.removeViewAt(dialogBg.getChildCount() - 1);
        dialog.setContentView((View)dialogBg);
        dialog.setCanceledOnTouchOutside(true);
        dialog.setCancelable(true);
        dialog.show();
    }

    private static float dip2px(Context ctx, float dip) {
        float scale = ctx.getResources().getDisplayMetrics().density;
        return dip * scale;
    }

    private static void recursiveSetOnClickListener(View view, final int pos, final OnItemClickListener listener, final BottomSheetDialog dialog) {
        if (view instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)view;
            for (int i = vg.getChildCount() - 1; i >= 0; --i) {
                BottomListDialog.recursiveSetOnClickListener(view, pos, listener, dialog);
            }
        } else {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onClick(v, pos, dialog);
                }
            });
        }
    }

    public static interface OnItemClickListener {
        public void onClick(View var1, int var2, BottomSheetDialog var3);
    }
}

