/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.serial;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.tcshare.utils.packet.IPacket;
import org.tcshare.utils.packet.IPacketCallback;
import org.tcshare.utils.packet.PacketSimpleUtil;
import org.tcshare.utils.serial.SerialPort;

public class SerialCommunication {
    private static final String TAG = SerialCommunication.class.getSimpleName();
    private final String port;
    private final int band;
    private final IPacketCallback cb;
    private final IPacket psu;
    private SerialPort mSerialPort;
    private ReadThread mReadThread;
    private WriteThread mWriteThread;
    private boolean connected = false;

    public SerialCommunication(String port, int band, IPacket psu, IPacketCallback cb) {
        this.port = port;
        this.band = band;
        this.cb = cb;
        this.psu = psu;
    }

    public boolean sendPacket(byte[] payload) {
        if (this.mWriteThread != null && this.connected) {
            this.mWriteThread.sendData(this.psu.gen(payload));
            return true;
        }
        return false;
    }

    public boolean sendPacketFull(byte[] packet) {
        if (this.mWriteThread != null && this.connected) {
            this.mWriteThread.sendData(packet);
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean connect() {
        try {
            this.disconnect();
            this.mSerialPort = new SerialPort(this.port, this.band, 0);
            this.mReadThread = new ReadThread(this.mSerialPort.getInputStream());
            this.mReadThread.start();
            this.mWriteThread = new WriteThread(this.mSerialPort.getOutputStream());
            this.mWriteThread.start();
            this.connected = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connected = false;
            return false;
        }
    }

    public void disconnect() {
        try {
            this.mReadThread.interrupt();
            this.mSerialPort.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mReadThread = null;
        try {
            this.mWriteThread.interrupt();
            this.mSerialPort.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWriteThread = null;
        try {
            this.mSerialPort.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mSerialPort = null;
    }

    private class WriteThread
    extends Thread {
        private final OutputStream mOutputStream;
        private final LinkedBlockingQueue<byte[]> sendQueue = new LinkedBlockingQueue();

        public WriteThread(OutputStream outputStream) {
            this.mOutputStream = outputStream;
        }

        public void sendData(byte[] bytes) {
            try {
                this.sendQueue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    byte[] bytes = this.sendQueue.take();
                    this.mOutputStream.write(bytes);
                    this.mOutputStream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SerialCommunication.this.connected = false;
                    return;
                }
            }
        }
    }

    private class ReadThread
    extends Thread {
        private final InputStream mInputStream;

        public ReadThread(InputStream inputStream) {
            this.mInputStream = inputStream;
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    byte[] buffer = new byte[512];
                    if (this.mInputStream == null) {
                        return;
                    }
                    int size = this.mInputStream.read(buffer);
                    if (size <= 0) continue;
                    SerialCommunication.this.psu.preparePacket(PacketSimpleUtil.subBytes(buffer, 0, size), SerialCommunication.this.cb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SerialCommunication.this.connected = false;
                    return;
                }
            }
        }
    }
}

