/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.bluetooth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Observable;
import java.util.UUID;
import org.tcshare.dialog.LoadingDialog;
import org.tcshare.dialog.MsgDialogUtil;
import org.tcshare.utils.HexDump;
import org.tcshare.utils.ToastUtil;
import org.tcshare.utils.bluetooth.BTSearchDialog;
import org.tcshare.utils.packet.PacketUtil;

public class BTUtil
extends Observable {
    private static final String TAG = BTUtil.class.getSimpleName();
    private long maxWaitTime = 10000L;
    private Activity act;
    private BTSearchDialog btSearchDialog;
    private int supportedMTU = 20;
    private BluetoothGatt btGatt;
    private BluetoothGattCharacteristic writeCharacteristic;
    private BluetoothGattCharacteristic notifyCharacteristic;
    private final String servicesUUID;
    private final String notifyUUID;
    private final String writeUUID;
    private byte[] sendBytes;
    private static final Handler handler = new Handler(Looper.getMainLooper());
    private Dialog loadingDialog;
    private final Runnable dismissLoadingDialogDelay = () -> this.reset(this.maxWaitTime / 1000L + "\u79d2\u5185\uff0c\u672a\u6536\u5230\u84dd\u7259\u8fd4\u56de\u7684\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8fde\u63a5\uff01");
    private final BluetoothAdapter bluetoothAdapter;
    private BluetoothDevice connectDev;
    private final PacketUtil packetUtil;

    public BTUtil(String servicesUUID, String notifyUUID, String writeUUID, long maxWaitTime, PacketUtil packetUtil) {
        this.servicesUUID = servicesUUID;
        this.notifyUUID = notifyUUID;
        this.writeUUID = writeUUID;
        this.maxWaitTime = maxWaitTime;
        this.packetUtil = packetUtil;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public void setActivity(Activity act) {
        this.act = act;
        this.loadingDialog = LoadingDialog.createLoadingDialog((Context)act, "\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u540e...");
        this.btSearchDialog = new BTSearchDialog(act, this.bluetoothAdapter, this::connectBT);
    }

    public void reset(String msg) {
        this.setChanged();
        this.notifyObservers(new BTDisconnect());
        this.connectDev = null;
        handler.removeCallbacks(this.dismissLoadingDialogDelay);
        this.loadingDialog.dismiss();
        if (this.btGatt != null) {
            this.btGatt.close();
        }
        this.loadingDialog.dismiss();
        this.packetUtil.resetPacket();
        if (msg != null) {
            MsgDialogUtil.showMsg((Context)this.act, msg);
        }
    }

    public void searchBT() {
        this.btSearchDialog.show();
    }

    protected void connectBT(final BluetoothDevice device) {
        this.connectDev = device;
        this.loadingDialog.show();
        this.btGatt = device.connectGatt((Context)this.act, false, new BluetoothGattCallback(){
            private final PacketUtil.PacketReadyCallBack cb = new PacketUtil.PacketReadyCallBack(){

                @Override
                public void onPacketReady(byte[] recvBytes) {
                    handler.removeCallbacks(BTUtil.this.dismissLoadingDialogDelay);
                    BTUtil.this.loadingDialog.dismiss();
                    Log.e((String)TAG, (String)("recevPacket:" + HexDump.toHexString(recvBytes)));
                    PacketUtil.ValidPacket ret = BTUtil.this.packetUtil.validPayload(recvBytes);
                    BTUtil.this.act.runOnUiThread(() -> {
                        BTUtil.this.setChanged();
                        BTUtil.this.notifyObservers(new BTMsg(ret.valid, ret.type, ret.payload, BTUtil.this.sendBytes, recvBytes));
                    });
                }
            };

            public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
                super.onMtuChanged(gatt, mtu, status);
                if (status == 0) {
                    BTUtil.this.act.runOnUiThread(() -> ToastUtil.showToastShort((Context)BTUtil.this.act, "mtu:" + mtu));
                    BTUtil.this.supportedMTU = mtu - 3;
                    Log.e((String)TAG, (String)("onMtuChanged:" + (mtu - 3) + ":" + status));
                }
            }

            public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                super.onCharacteristicRead(gatt, characteristic, status);
                Log.e((String)TAG, (String)("onCharacteristicRead:" + HexDump.toHexString(characteristic.getValue())));
            }

            public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                super.onCharacteristicWrite(gatt, characteristic, status);
                Log.e((String)TAG, (String)("onCharacteristicWrite:" + HexDump.toHexString(characteristic.getValue())));
            }

            public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                super.onConnectionStateChange(gatt, status, newState);
                Log.e((String)TAG, (String)("onConnectionStateChange:-" + status + "-" + newState));
                if (status == 0) {
                    BTUtil.this.btGatt.discoverServices();
                    Log.e((String)TAG, (String)"GATT\u8fde\u63a5\u6210\u529f\uff01\u4e0b\u4e00\u6b65\u627e\u5bf9\u5e94\u7684\u670d\u52a1\u3002");
                } else {
                    BTUtil.this.act.runOnUiThread(() -> BTUtil.this.reset("\u4e0d\u652f\u6301\u7684\u8bbe\u5907\uff0c\u65e0\u6cd5\u8fde\u63a5\u5230\u8bbe\u5907\uff01"));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressLint(value={"SetTextI18n"})
            public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                super.onServicesDiscovered(gatt, status);
                Log.e((String)TAG, (String)"onServicesDiscovered");
                try {
                    if (status == 0) {
                        List supportedGattServices = BTUtil.this.btGatt.getServices();
                        for (int i = 0; i < supportedGattServices.size(); ++i) {
                            Log.e((String)"success", (String)("1:BluetoothGattService UUID=:" + ((BluetoothGattService)supportedGattServices.get(i)).getUuid()));
                            List listGattCharacteristic = ((BluetoothGattService)supportedGattServices.get(i)).getCharacteristics();
                            for (int j = 0; j < listGattCharacteristic.size(); ++j) {
                                int charaProp = ((BluetoothGattCharacteristic)listGattCharacteristic.get(j)).getProperties();
                                String p = (charaProp | 2) > 0 ? "\u5c5e\u6027\u53ef\u8bfb" : "\u5c5e\u6027\u4e0d\u53ef\u8bfb";
                                Log.e((String)"success", (String)("2:   BluetoothGattCharacteristic UUID=:" + ((BluetoothGattCharacteristic)listGattCharacteristic.get(j)).getUuid() + "=" + p + "=" + ((BluetoothGattCharacteristic)listGattCharacteristic.get(j)).getWriteType()));
                            }
                        }
                    } else {
                        BTUtil.this.act.runOnUiThread(() -> {
                            BTUtil.this.loadingDialog.dismiss();
                            MsgDialogUtil.showMsg((Context)BTUtil.this.act, "\u627e\u4e0d\u5230\u670d\u52a1\uff0c\u65e0\u6cd5\u8fde\u63a5\u5230\u8bbe\u5907\uff01");
                        });
                        return;
                    }
                    BluetoothGattService bluetoothGattService = BTUtil.this.btGatt.getService(UUID.fromString(BTUtil.this.servicesUUID));
                    BTUtil.this.writeCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(BTUtil.this.writeUUID));
                    BTUtil.this.notifyCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(BTUtil.this.notifyUUID));
                    gatt.readCharacteristic(BTUtil.this.notifyCharacteristic);
                    List descriptors = BTUtil.this.notifyCharacteristic.getDescriptors();
                    for (BluetoothGattDescriptor descriptor : descriptors) {
                        boolean b1 = descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                        if (b1) {
                            gatt.writeDescriptor(descriptor);
                            Log.e((String)TAG, (String)("\u63cf\u8ff0 UUID :" + descriptor.getUuid().toString() + "\u8bbe\u7f6e\u5141\u8bb8\u901a\u77e5\u6210\u529f\uff01"));
                            continue;
                        }
                        Log.e((String)TAG, (String)("\u63cf\u8ff0 UUID :" + descriptor.getUuid().toString() + " \u8bbe\u7f6e\u5141\u8bb8\u901a\u77e5\u5931\u8d25"));
                    }
                    boolean ret = gatt.setCharacteristicNotification(BTUtil.this.notifyCharacteristic, true);
                    if (!ret) {
                        BTUtil.this.act.runOnUiThread(() -> MsgDialogUtil.showMsg((Context)BTUtil.this.act, "\u76d1\u542c\u84dd\u7259\u901a\u77e5\u5931\u8d25\uff01"));
                        return;
                    }
                    Log.e((String)"TAG", (String)"\u8bbe\u7f6e\u76d1\u542c\u6210\u529f!");
                    BTUtil.this.act.runOnUiThread(() -> {
                        BTUtil.this.setChanged();
                        BTUtil.this.notifyObservers(new BTConnect(device));
                        ToastUtil.showToastShort((Context)BTUtil.this.act, "\u8bbe\u5907\u8fde\u63a5\u6210\u529f\uff01");
                        BTUtil.this.bluetoothAdapter.cancelDiscovery();
                        int mtu = 512;
                        Log.e((String)TAG, (String)("request " + mtu + " mtu:" + gatt.requestMtu(mtu)));
                        BTUtil.this.btSearchDialog.dismiss();
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BTUtil.this.act.runOnUiThread(() -> MsgDialogUtil.showMsg((Context)BTUtil.this.act, "\u8fde\u63a5\u5931\u8d25\uff0c\u8be5\u7a0b\u5e8f\u4ec5\u652f\u6301\u8fde\u63a5\u6307\u5b9a\u8bbe\u5907\uff01"));
                }
                finally {
                    BTUtil.this.loadingDialog.dismiss();
                }
            }

            public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                super.onCharacteristicChanged(gatt, characteristic);
                BTUtil.this.packetUtil.preparePacket(characteristic.getValue(), this.cb);
            }
        });
    }

    public void sendData(byte[] payload) {
        this.sendData(payload, true);
    }

    public void sendData(byte[] payload, boolean showProgress) {
        if (this.connectDev == null || this.writeCharacteristic == null || this.notifyCharacteristic == null) {
            ToastUtil.showToastShort((Context)this.act, "\u672a\u8fde\u63a5\u5230\u8bbe\u5907\uff01");
            return;
        }
        if (payload == null || payload.length == 0) {
            ToastUtil.showToastShort((Context)this.act, "\u53d1\u9001\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return;
        }
        if (showProgress) {
            this.loadingDialog.show();
            handler.postDelayed(this.dismissLoadingDialogDelay, this.maxWaitTime);
        }
        this.sendBytes = payload;
        Log.e((String)TAG, (String)("\u9700\u8981\u53d1\u9001\u7684\u6570\u636e\uff1a" + HexDump.toHexString(payload)));
        ByteBuffer tmpBB = ByteBuffer.allocate(this.supportedMTU);
        for (byte b : payload) {
            tmpBB.put(b);
            if (tmpBB.hasRemaining()) continue;
            byte[] packet = tmpBB.array();
            Log.e((String)TAG, (String)("sendPacket:" + HexDump.toHexString(packet)));
            if (this.sendPacketFailed(packet)) {
                tmpBB.clear();
                if (showProgress) {
                    MsgDialogUtil.showMsg((Context)this.act, "\u62c6\u5206\u6570\u636e\u5305\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
                }
                return;
            }
            tmpBB.clear();
        }
        tmpBB.flip();
        byte[] packet = new byte[tmpBB.limit()];
        tmpBB.get(packet);
        if (packet.length > 0) {
            Log.e((String)TAG, (String)("sendPacketFlush:" + HexDump.toHexString(packet)));
            if (this.sendPacketFailed(packet) && showProgress) {
                MsgDialogUtil.showMsg((Context)this.act, "\u62c6\u5206\u6570\u636e\u5305\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
        }
    }

    private boolean sendPacketFailed(byte[] bytes) {
        this.writeCharacteristic.setValue(bytes);
        boolean ret = this.btGatt.writeCharacteristic(this.writeCharacteristic);
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return !ret;
    }

    public BluetoothDevice getConnectDev() {
        return this.connectDev;
    }

    public static class BTDisconnect {
    }

    public static class BTConnect {
        public BluetoothDevice device;

        public BTConnect(BluetoothDevice device) {
            this.device = device;
        }
    }

    public static class BTMsg {
        public final boolean validPacket;
        public final byte[] sendBytes;
        public final byte[] recvBytes;
        public final byte[] payload;
        private final byte type;

        public BTMsg(boolean validPacket, byte type, byte[] payload, byte[] sendBytes, byte[] recvBytes) {
            this.validPacket = validPacket;
            this.type = type;
            this.sendBytes = sendBytes;
            this.recvBytes = recvBytes;
            this.payload = payload;
        }
    }
}

