/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SimpleImageScaledDown {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scaledDown(String file, String outFile, int reqWidth, int reqHeight) {
        OutputStream os = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)file, (BitmapFactory.Options)options);
            options.inSampleSize = SimpleImageScaledDown.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            Bitmap scaledBitmap = BitmapFactory.decodeFile((String)file, (BitmapFactory.Options)options);
            os = new FileOutputStream(outFile);
            scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 90, os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

