/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.util.Log;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {
    private static final String TAG = SerialPort.class.getSimpleName();
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;
    private String rs485Path;

    public SerialPort(File device, int baudrate, int flags, @Nullable String rs485Path) throws SecurityException, IOException {
        this.rs485Path = rs485Path;
        this.mFd = SerialPort.open(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        Log.e((String)TAG, (String)"native open returns ok");
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    public static native FileDescriptor open(String var0, int var1, int var2);

    public native void close();

    public int enSend() {
        return this.rs485Path == null ? -1 : SerialPort.SystemCMD("echo 1 > " + this.rs485Path);
    }

    public int enRec() {
        return this.rs485Path == null ? -1 : SerialPort.SystemCMD("echo 0 > " + this.rs485Path);
    }

    public static native int SystemCMD(String var0);
}

