/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PhoneInfo {
    private static final String TAG = PhoneInfo.class.getSimpleName();
    private static final String FILE_MEMORY = "/proc/meminfo";
    private static final String FILE_CPU = "/proc/cpuinfo";
    public String mIMEI;
    public int mPhoneType;
    public int mSysVersion;
    public String mNetWorkCountryIso;
    public String mNetWorkOperator;
    public String mNetWorkOperatorName;
    public int mNetWorkType;
    public boolean mIsOnLine;
    public String mConnectTypeName;
    public long mFreeMem;
    public long mTotalMem;
    public Map<String, String> mCupInfo;
    public String mProductName;
    public String mModelName;
    public String mManufacturerName;

    private PhoneInfo() {
    }

    public static String getIMEI(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (0 == context.getPackageManager().checkPermission("android.permission.READ_PHONE_STATE", context.getPackageName())) {
            return manager.getDeviceId();
        }
        return null;
    }

    public static int getPhoneType(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getPhoneType();
    }

    public static int getSysVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getNetWorkCountryIso(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getNetworkCountryIso();
    }

    public static String getNetWorkOperator(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getNetworkOperator();
    }

    public static String getNetWorkOperatorName(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getNetworkOperatorName();
    }

    public static int getNetworkType(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getNetworkType();
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public static String getConnectTypeName(Context context) {
        if (!PhoneInfo.isOnline(context)) {
            return "OFFLINE";
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        if (info != null) {
            return info.getTypeName();
        }
        return "OFFLINE";
    }

    public static long getFreeMem(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
        manager.getMemoryInfo(info);
        long free = info.availMem / 1024L / 1024L;
        return free;
    }

    public static long getTotalMem(Context context) {
        try {
            FileReader fr = new FileReader(FILE_MEMORY);
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split("\\s+");
            Log.w((String)TAG, (String)text);
            return Long.valueOf(array[1]) / 1024L;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public static Map<String, String> getCpuInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(FILE_CPU));){
            String text;
            while ((text = br.readLine()) != null) {
                if ("".equals(text = text.trim())) continue;
                String[] array = text.split("\\s*:\\s*", 2);
                if (array.length != 2) {
                    Log.e((String)TAG, (String)("\u83b7\u53d6CPU\u4fe1\u606f\u65e0\u6cd5\u89e3\u6790\uff1a" + text));
                    continue;
                }
                map.put(array[0], array[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getProductName() {
        return Build.PRODUCT;
    }

    public static String getModelName() {
        return Build.MODEL;
    }

    public static String getManufacturerName() {
        return Build.MANUFACTURER;
    }

    public static PhoneInfo getPhoneInfo(Context context) {
        PhoneInfo result = new PhoneInfo();
        result.mIMEI = PhoneInfo.getIMEI(context);
        result.mPhoneType = PhoneInfo.getPhoneType(context);
        result.mSysVersion = PhoneInfo.getSysVersion();
        result.mNetWorkCountryIso = PhoneInfo.getNetWorkCountryIso(context);
        result.mNetWorkOperator = PhoneInfo.getNetWorkOperator(context);
        result.mNetWorkOperatorName = PhoneInfo.getNetWorkOperatorName(context);
        result.mNetWorkType = PhoneInfo.getNetworkType(context);
        result.mIsOnLine = PhoneInfo.isOnline(context);
        result.mConnectTypeName = PhoneInfo.getConnectTypeName(context);
        result.mFreeMem = PhoneInfo.getFreeMem(context);
        result.mTotalMem = PhoneInfo.getTotalMem(context);
        result.mCupInfo = PhoneInfo.getCpuInfo();
        result.mProductName = PhoneInfo.getProductName();
        result.mModelName = PhoneInfo.getModelName();
        result.mManufacturerName = PhoneInfo.getManufacturerName();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IMEI : " + this.mIMEI + "\n");
        builder.append("mPhoneType : " + this.mPhoneType + "\n");
        builder.append("mSysVersion : " + this.mSysVersion + "\n");
        builder.append("mNetWorkCountryIso : " + this.mNetWorkCountryIso + "\n");
        builder.append("mNetWorkOperator : " + this.mNetWorkOperator + "\n");
        builder.append("mNetWorkOperatorName : " + this.mNetWorkOperatorName + "\n");
        builder.append("mNetWorkType : " + this.mNetWorkType + "\n");
        builder.append("mIsOnLine : " + this.mIsOnLine + "\n");
        builder.append("mConnectTypeName : " + this.mConnectTypeName + "\n");
        builder.append("mFreeMem : " + this.mFreeMem + "M\n");
        builder.append("mTotalMem : " + this.mTotalMem + "M\n");
        builder.append("mCupInfo : " + this.mCupInfo + "\n");
        builder.append("mProductName : " + this.mProductName + "\n");
        builder.append("mModelName : " + this.mModelName + "\n");
        builder.append("mManufacturerName : " + this.mManufacturerName + "\n");
        return builder.toString();
    }
}

