/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import org.tcshare.androidutils.R;
import org.tcshare.utils.ShellUtils;
import org.tcshare.utils.ToastUtil;

public class PackageUtil {
    public static boolean isAppInstalled(Context context, String appPackageName) {
        PackageManager pm = context.getPackageManager();
        boolean installed = false;
        try {
            pm.getPackageInfo(appPackageName, 1);
            installed = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            installed = false;
        }
        return installed;
    }

    public static void startAPP(Context ctx) {
        PackageUtil.startAPP(ctx, ctx.getPackageName());
    }

    public static void startAPP(Context ctx, String appPackageName) {
        try {
            Intent intent = ctx.getPackageManager().getLaunchIntentForPackage(appPackageName);
            ctx.startActivity(intent);
        }
        catch (Exception e) {
            ToastUtil.showToastShort(ctx, ctx.getString(R.string.app_not_install));
        }
    }

    public static ShellUtils.CommandResult installSilent(String packageName, String apkFile) {
        return ShellUtils.execCommand("pm install -i " + packageName + " -f " + apkFile, true, true);
    }

    public static ShellUtils.CommandResult installSilent(Context ctx, String apkFile) {
        return PackageUtil.installSilent(ctx.getPackageName(), apkFile);
    }

    public static ShellUtils.CommandResult updateSilent(String apkFile) {
        return ShellUtils.execCommand("pm install -r  -f " + apkFile, true, true);
    }

    public static ShellUtils.CommandResult uninstallSilent(String packageName) {
        return ShellUtils.execCommand("pm uninstall " + packageName, true, true);
    }

    public static ShellUtils.CommandResult startApp(String packageName, String activity) {
        return ShellUtils.execCommand("am start -n " + packageName + "/" + activity, true, true);
    }
}

