/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.tcshare.utils.ToastUtil;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private final Context ctx;
    private Thread.UncaughtExceptionHandler mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    private Map<String, String> mInfos = new HashMap<String, String>();
    private DateFormat mFormatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private Class restartActivity;
    public static File CRASH_DIR;

    public CrashHandler(Context ctx) {
        this.ctx = ctx;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void setRestartActivity(Class restartActivity) {
        this.restartActivity = restartActivity;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex)) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.e((String)this.getClass().toString(), (String)(e == null ? "" : e.toString()));
            }
            if (this.restartActivity != null) {
                Intent intent = new Intent(this.ctx, this.restartActivity);
                intent.addFlags(335577088);
                this.ctx.startActivity(intent);
            }
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(Throwable ex) {
        if (null == ex) {
            return false;
        }
        ToastUtil.showToastLong(this.ctx, "\u7a0b\u5e8f\u5f02\u5e38\uff0c1\u79d2\u540e\u91cd\u542f\uff01");
        this.collectDeviceInfo();
        this.saveCrashInfo2File(ex);
        return true;
    }

    private void collectDeviceInfo() {
        Field[] fields;
        try {
            PackageManager pm = this.ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.mInfos.put("versionName", versionName);
                this.mInfos.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"an error occured when collect package info", (Throwable)e);
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.mInfos.put(field.getName(), field.get(null).toString());
                Log.d((String)TAG, (String)(field.getName() + " : " + field.get(null)));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"an error occured when collect crash info", (Throwable)e);
            }
        }
    }

    private String saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.mInfos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\n");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        sb.append(result);
        try {
            long timestamp = System.currentTimeMillis();
            String time = this.mFormatter.format(new Date());
            String fileName = "crash-" + time + "-" + timestamp + ".log";
            if (Environment.getExternalStorageState().equals("mounted")) {
                if (CRASH_DIR == null && !(CRASH_DIR = new File(Environment.getExternalStorageDirectory() + "/crash/")).exists()) {
                    CRASH_DIR.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(new File(CRASH_DIR, fileName));
                fos.write(sb.toString().getBytes());
                fos.close();
            }
            return fileName;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"an error occured while writing file...", (Throwable)e);
            return null;
        }
    }
}

