/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.network.cookie;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import okhttp3.Cookie;
import okhttp3.HttpUrl;
import org.tcshare.network.cookie.CookieStore;
import org.tcshare.network.cookie.SerializableHttpCookie;

public class PersistentCookieStore
implements CookieStore {
    private static final String LOG_TAG = "PersistentCookieStore";
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private static final String COMMA = ",";
    protected HashMap<String, List<Cookie>> allCookies = new HashMap();
    protected SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.restoreAll();
    }

    protected String encodeCookie(SerializableHttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in encodeCookie", (Throwable)e);
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    protected Cookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableHttpCookie)objectInputStream.readObject()).getCookie();
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in decodeCookie", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)LOG_TAG, (String)"ClassNotFoundException in decodeCookie", (Throwable)e);
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public void saveAll() {
        SharedPreferences.Editor edit = this.cookiePrefs.edit();
        for (Map.Entry<String, List<Cookie>> entry : this.allCookies.entrySet()) {
            String host = entry.getKey();
            StringBuilder sb = new StringBuilder();
            for (Cookie cookie : entry.getValue()) {
                sb.append(this.encodeCookie(new SerializableHttpCookie(cookie))).append(COMMA);
            }
            if (sb.length() > COMMA.length()) {
                sb.substring(0, sb.length() - COMMA.length());
            }
            edit.putString(host, sb.toString());
        }
        edit.apply();
    }

    public void restoreAll() {
        Map map = this.cookiePrefs.getAll();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            if (entry.getValue() != null) {
                List<String> cookieStr = Arrays.asList(((String)entry.getValue()).split(COMMA));
                for (String cStr : cookieStr) {
                    cookies.add(this.decodeCookie(cStr));
                }
            }
            this.allCookies.put((String)entry.getKey(), cookies);
        }
    }

    @Override
    public void add(HttpUrl url, List<Cookie> cookies) {
        List<Cookie> oldCookies = this.allCookies.get(url.host());
        if (oldCookies != null) {
            Iterator<Cookie> itNew = cookies.iterator();
            Iterator<Cookie> itOld = oldCookies.iterator();
            while (itNew.hasNext()) {
                String va = itNew.next().name();
                while (va != null && itOld.hasNext()) {
                    String v = itOld.next().name();
                    if (v == null || !va.equals(v)) continue;
                    itOld.remove();
                }
            }
            oldCookies.addAll(cookies);
        } else {
            this.allCookies.put(url.host(), cookies);
        }
        this.saveAll();
    }

    @Override
    public List<Cookie> get(HttpUrl uri) {
        List<Cookie> cookies = this.allCookies.get(uri.host());
        if (cookies == null) {
            cookies = new ArrayList<Cookie>();
            this.allCookies.put(uri.host(), cookies);
        }
        return cookies;
    }

    @Override
    public boolean removeAll() {
        this.allCookies.clear();
        this.saveAll();
        return true;
    }

    @Override
    public List<Cookie> getCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Set<String> httpUrls = this.allCookies.keySet();
        for (String url : httpUrls) {
            cookies.addAll((Collection<Cookie>)this.allCookies.get(url));
        }
        return cookies;
    }

    @Override
    public boolean remove(HttpUrl uri, Cookie cookie) {
        List<Cookie> cookies = this.allCookies.get(uri.host());
        if (cookie != null) {
            boolean removed = cookies.remove(cookie);
            if (removed) {
                this.saveAll();
            }
            return removed;
        }
        return false;
    }
}

