/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.network;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.tcshare.network.MimeTypeUtil;

public class RequestBuilderFactory {
    private static Headers headers = Headers.of((String[])new String[0]);

    public static Headers getHeaders() {
        return headers;
    }

    public static void setHeaders(Headers headers) {
        RequestBuilderFactory.headers = headers;
    }

    private static String getMimeType(String filePath) {
        return MimeTypeUtil.getType(filePath);
    }

    public static Request.Builder createMultiPostRequestBuilder(String targetUrl, MediaType formType, String fileKey, Map<String, String> map, List<File> files) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.addFormDataPart(entry.getKey(), entry.getValue());
            }
        }
        if (formType != null) {
            builder.setType(formType);
        }
        if (files != null && fileKey != null) {
            for (File file : files) {
                builder.addFormDataPart(fileKey, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)RequestBuilderFactory.getMimeType(file.getName())), (File)file));
            }
        }
        return new Request.Builder().url(targetUrl).tag((Object)UUID.randomUUID()).post((RequestBody)builder.build()).headers(headers);
    }

    public static Request.Builder createDelRequestBuilder(String targetUrl, Map<String, String> map) {
        FormBody.Builder builder = new FormBody.Builder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        return new Request.Builder().url(targetUrl).tag((Object)UUID.randomUUID()).delete((RequestBody)builder.build()).headers(headers);
    }

    public static Request.Builder createPostRequestBuilder(String targetUrl, Map<String, String> map) {
        FormBody.Builder builder = new FormBody.Builder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        return new Request.Builder().url(targetUrl).tag((Object)UUID.randomUUID()).post((RequestBody)builder.build()).headers(headers);
    }

    public static Request.Builder createPutRequestBuilder(String targetUrl, Map<String, String> map) {
        FormBody.Builder builder = new FormBody.Builder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        return new Request.Builder().url(targetUrl).tag((Object)UUID.randomUUID()).put((RequestBody)builder.build()).headers(headers);
    }

    public static Request.Builder createGetRequestBuilder(String targetUrl, Map<String, String> map) {
        if (map != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
            targetUrl = targetUrl + (targetUrl.contains("?") ? sb.toString() : "?" + sb.toString().replaceFirst("&", ""));
        }
        return new Request.Builder().url(targetUrl).tag((Object)UUID.randomUUID()).get().headers(headers);
    }

    public static Request.Builder createPostJsonRequestBuilder(String targetUrl, String json) {
        RequestBody jsonBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)json);
        return new Request.Builder().url(targetUrl).tag((Object)UUID.randomUUID()).post(jsonBody).headers(headers).header("content-type", "application/json;charset:utf-8");
    }
}

