/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logview.standout.ui;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.util.LinkedList;
import org.tcshare.androidutils.R;
import org.tcshare.logview.standout.StandOutWindow;
import org.tcshare.logview.standout.Utils;
import org.tcshare.logview.standout.constants.StandOutFlags;
import org.tcshare.logview.standout.ui.TouchInfo;

public class Window
extends FrameLayout {
    public static final int VISIBILITY_GONE = 0;
    public static final int VISIBILITY_VISIBLE = 1;
    public static final int VISIBILITY_TRANSITION = 2;
    static final String TAG = "Window";
    public Class<? extends StandOutWindow> cls;
    public int id;
    public int visibility;
    public boolean focused;
    public StandOutWindow.StandOutLayoutParams originalParams;
    public int flags;
    public TouchInfo touchInfo;
    public Bundle data;
    int displayWidth;
    int displayHeight;
    private final StandOutWindow mContext;
    private LayoutInflater mLayoutInflater;

    public Window(Context context) {
        super(context);
        this.mContext = null;
    }

    public Window(final StandOutWindow context, final int id2) {
        super((Context)context);
        FrameLayout body;
        View content;
        context.setTheme(context.getThemeStyle());
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.cls = ((Object)((Object)context)).getClass();
        this.id = id2;
        this.originalParams = context.getParams(id2, this);
        this.flags = context.getFlags(id2);
        this.touchInfo = new TouchInfo();
        this.touchInfo.ratio = (float)this.originalParams.width / (float)this.originalParams.height;
        this.data = new Bundle();
        DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
        this.displayWidth = metrics.widthPixels;
        this.displayHeight = (int)((float)metrics.heightPixels - 25.0f * metrics.density);
        if (Utils.isSet(this.flags, StandOutFlags.FLAG_DECORATION_SYSTEM)) {
            content = this.getSystemDecorations();
            body = (FrameLayout)content.findViewById(R.id.body);
        } else {
            content = new FrameLayout((Context)context);
            content.setId(R.id.content);
            body = (FrameLayout)content;
        }
        this.addView(content);
        body.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean consumed = false;
                consumed = context.onTouchHandleMove(id2, Window.this, v, event) || consumed;
                consumed = context.onTouchBody(id2, Window.this, v, event) || consumed;
                return consumed;
            }
        });
        context.createAndAttachView(id2, body);
        if (body.getChildCount() == 0) {
            throw new RuntimeException("You must attach your view to the given frame in createAndAttachView()");
        }
        if (!Utils.isSet(this.flags, StandOutFlags.FLAG_FIX_COMPATIBILITY_ALL_DISABLE)) {
            this.fixCompatibility((View)body);
        }
        if (!Utils.isSet(this.flags, StandOutFlags.FLAG_ADD_FUNCTIONALITY_ALL_DISABLE)) {
            this.addFunctionality((View)body);
        }
        this.setTag(body.getTag());
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        StandOutWindow.StandOutLayoutParams params = this.getLayoutParams();
        if (event.getAction() == 0 && this.mContext.getFocusedWindow() != this) {
            this.mContext.focus(this.id);
        }
        if (event.getPointerCount() >= 2 && Utils.isSet(this.flags, StandOutFlags.FLAG_WINDOW_PINCH_RESIZE_ENABLE) && (event.getAction() & 0xFF) == 5) {
            this.touchInfo.scale = 1.0;
            this.touchInfo.dist = -1.0;
            this.touchInfo.firstWidth = params.width;
            this.touchInfo.firstHeight = params.height;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 4: {
                if (this.mContext.getFocusedWindow() == this) {
                    this.mContext.unfocus(this);
                }
                this.mContext.onTouchBody(this.id, this, (View)this, event);
            }
        }
        if (event.getPointerCount() >= 2 && Utils.isSet(this.flags, StandOutFlags.FLAG_WINDOW_PINCH_RESIZE_ENABLE)) {
            float x0 = event.getX(0);
            float y0 = event.getY(0);
            float x1 = event.getX(1);
            float y1 = event.getY(1);
            double dist = Math.sqrt(Math.pow(x0 - x1, 2.0) + Math.pow(y0 - y1, 2.0));
            switch (event.getAction() & 0xFF) {
                case 2: {
                    if (this.touchInfo.dist == -1.0) {
                        this.touchInfo.dist = dist;
                    }
                    this.touchInfo.scale *= dist / this.touchInfo.dist;
                    this.touchInfo.dist = dist;
                    this.edit().setAnchorPoint(0.5f, 0.5f).setSize((int)(this.touchInfo.firstWidth * this.touchInfo.scale), (int)(this.touchInfo.firstHeight * this.touchInfo.scale)).commit();
                }
            }
            this.mContext.onResize(this.id, this, (View)this, event);
        }
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mContext.onKeyEvent(this.id, this, event)) {
            Log.d((String)TAG, (String)("Window " + this.id + " key event " + event + " cancelled by implementation."));
            return false;
        }
        if (event.getAction() == 1) {
            switch (event.getKeyCode()) {
                case 4: {
                    this.mContext.unfocus(this);
                    return true;
                }
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onFocus(boolean focus) {
        if (!Utils.isSet(this.flags, StandOutFlags.FLAG_WINDOW_FOCUSABLE_DISABLE)) {
            if (focus == this.focused) {
                return false;
            }
            this.focused = focus;
            if (this.mContext.onFocusChange(this.id, this, focus)) {
                Log.d((String)TAG, (String)("Window " + this.id + " focus change " + (focus ? "(true)" : "(false)") + " cancelled by implementation."));
                this.focused = !focus;
                return false;
            }
            if (!Utils.isSet(this.flags, StandOutFlags.FLAG_WINDOW_FOCUS_INDICATOR_DISABLE)) {
                View content = this.findViewById(R.id.content);
                if (focus) {
                    content.setBackgroundResource(17170453);
                } else if (Utils.isSet(this.flags, StandOutFlags.FLAG_DECORATION_SYSTEM)) {
                    content.setBackgroundResource(17170453);
                } else {
                    content.setBackgroundResource(0);
                }
            }
            StandOutWindow.StandOutLayoutParams params = this.getLayoutParams();
            params.setFocusFlag(focus);
            this.mContext.updateViewLayout(this.id, params);
            if (focus) {
                this.mContext.setFocusedWindow(this);
            } else if (this.mContext.getFocusedWindow() == this) {
                this.mContext.setFocusedWindow(null);
            }
            return true;
        }
        return false;
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (!(params instanceof StandOutWindow.StandOutLayoutParams)) {
            throw new IllegalArgumentException(TAG + this.id + ": LayoutParams must be an instance of StandOutLayoutParams.");
        }
        super.setLayoutParams(params);
    }

    public Editor edit() {
        return new Editor();
    }

    public StandOutWindow.StandOutLayoutParams getLayoutParams() {
        StandOutWindow.StandOutLayoutParams params = (StandOutWindow.StandOutLayoutParams)super.getLayoutParams();
        if (params == null) {
            params = this.originalParams;
        }
        params.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        return params;
    }

    private View getSystemDecorations() {
        View decorations = this.mLayoutInflater.inflate(R.layout.system_window_decorators, null);
        final ImageView icon = (ImageView)decorations.findViewById(R.id.window_icon);
        icon.setImageResource(this.mContext.getAppIcon());
        icon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopupWindow dropDown = Window.this.mContext.getDropDown(Window.this.id);
                if (dropDown != null) {
                    dropDown.showAsDropDown((View)icon);
                }
            }
        });
        TextView title = (TextView)decorations.findViewById(R.id.title);
        title.setText((CharSequence)this.mContext.getTitle(this.id));
        View hide = decorations.findViewById(R.id.hide);
        hide.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Window.this.mContext.hide(Window.this.id);
            }
        });
        hide.setVisibility(8);
        View maximize = decorations.findViewById(R.id.maximize);
        maximize.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StandOutWindow.StandOutLayoutParams params = Window.this.getLayoutParams();
                boolean isMaximized = Window.this.data.getBoolean("isMaximized");
                if (isMaximized && params.width == Window.this.displayWidth && params.height == Window.this.displayHeight && params.x == 0 && params.y == 0) {
                    Window.this.data.putBoolean("isMaximized", false);
                    int oldWidth = Window.this.data.getInt("widthBeforeMaximize", -1);
                    int oldHeight = Window.this.data.getInt("heightBeforeMaximize", -1);
                    int oldX = Window.this.data.getInt("xBeforeMaximize", -1);
                    int oldY = Window.this.data.getInt("yBeforeMaximize", -1);
                    Window.this.edit().setSize(oldWidth, oldHeight).setPosition(oldX, oldY).commit();
                } else {
                    Window.this.data.putBoolean("isMaximized", true);
                    Window.this.data.putInt("widthBeforeMaximize", params.width);
                    Window.this.data.putInt("heightBeforeMaximize", params.height);
                    Window.this.data.putInt("xBeforeMaximize", params.x);
                    Window.this.data.putInt("yBeforeMaximize", params.y);
                    Window.this.edit().setSize(1.0f, 1.0f).setPosition(0, 0).commit();
                }
            }
        });
        View close = decorations.findViewById(R.id.close);
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Window.this.mContext.close(Window.this.id);
            }
        });
        View titlebar = decorations.findViewById(R.id.titlebar);
        titlebar.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean consumed = Window.this.mContext.onTouchHandleMove(Window.this.id, Window.this, v, event);
                return consumed;
            }
        });
        View corner = decorations.findViewById(R.id.corner);
        corner.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean consumed = Window.this.mContext.onTouchHandleResize(Window.this.id, Window.this, v, event);
                return consumed;
            }
        });
        if (Utils.isSet(this.flags, StandOutFlags.FLAG_WINDOW_HIDE_ENABLE)) {
            hide.setVisibility(0);
        }
        if (Utils.isSet(this.flags, StandOutFlags.FLAG_DECORATION_MAXIMIZE_DISABLE)) {
            maximize.setVisibility(8);
        }
        if (Utils.isSet(this.flags, StandOutFlags.FLAG_DECORATION_CLOSE_DISABLE)) {
            close.setVisibility(8);
        }
        if (Utils.isSet(this.flags, StandOutFlags.FLAG_DECORATION_MOVE_DISABLE)) {
            titlebar.setOnTouchListener(null);
        }
        if (Utils.isSet(this.flags, StandOutFlags.FLAG_DECORATION_RESIZE_DISABLE)) {
            corner.setVisibility(8);
        }
        return decorations;
    }

    void addFunctionality(View root) {
        View icon;
        View corner;
        if (!Utils.isSet(this.flags, StandOutFlags.FLAG_ADD_FUNCTIONALITY_RESIZE_DISABLE) && (corner = root.findViewById(R.id.corner)) != null) {
            corner.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    boolean consumed = Window.this.mContext.onTouchHandleResize(Window.this.id, Window.this, v, event);
                    return consumed;
                }
            });
        }
        if (!Utils.isSet(this.flags, StandOutFlags.FLAG_ADD_FUNCTIONALITY_DROP_DOWN_DISABLE) && (icon = root.findViewById(R.id.window_icon)) != null) {
            icon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PopupWindow dropDown = Window.this.mContext.getDropDown(Window.this.id);
                    if (dropDown != null) {
                        dropDown.showAsDropDown(icon);
                    }
                }
            });
        }
    }

    void fixCompatibility(View root) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.add(root);
        View view = null;
        while ((view = (View)queue.poll()) != null) {
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                queue.add(group.getChildAt(i));
            }
        }
    }

    public class Editor {
        public static final int UNCHANGED = Integer.MIN_VALUE;
        StandOutWindow.StandOutLayoutParams mParams;
        float anchorX;
        float anchorY;

        public Editor() {
            this.mParams = Window.this.getLayoutParams();
            this.anchorY = 0.0f;
            this.anchorX = 0.0f;
        }

        public Editor setAnchorPoint(float x, float y) {
            if (x < 0.0f || x > 1.0f || y < 0.0f || y > 1.0f) {
                throw new IllegalArgumentException("Anchor point must be between 0 and 1, inclusive.");
            }
            this.anchorX = x;
            this.anchorY = y;
            return this;
        }

        public Editor setSize(float percentWidth, float percentHeight) {
            return this.setSize((int)((float)Window.this.displayWidth * percentWidth), (int)((float)Window.this.displayHeight * percentHeight));
        }

        public Editor setSize(int width, int height) {
            return this.setSize(width, height, false);
        }

        private Editor setSize(int width, int height, boolean skip) {
            if (this.mParams != null) {
                if (this.anchorX < 0.0f || this.anchorX > 1.0f || this.anchorY < 0.0f || this.anchorY > 1.0f) {
                    throw new IllegalStateException("Anchor point must be between 0 and 1, inclusive.");
                }
                int lastWidth = this.mParams.width;
                int lastHeight = this.mParams.height;
                if (width != Integer.MIN_VALUE) {
                    this.mParams.width = width;
                }
                if (height != Integer.MIN_VALUE) {
                    this.mParams.height = height;
                }
                int maxWidth = this.mParams.maxWidth;
                int maxHeight = this.mParams.maxHeight;
                if (Utils.isSet(Window.this.flags, StandOutFlags.FLAG_WINDOW_EDGE_LIMITS_ENABLE)) {
                    maxWidth = Math.min(maxWidth, Window.this.displayWidth);
                    maxHeight = Math.min(maxHeight, Window.this.displayHeight);
                }
                this.mParams.width = Math.min(Math.max(this.mParams.width, this.mParams.minWidth), maxWidth);
                this.mParams.height = Math.min(Math.max(this.mParams.height, this.mParams.minHeight), maxHeight);
                if (Utils.isSet(Window.this.flags, StandOutFlags.FLAG_WINDOW_ASPECT_RATIO_ENABLE)) {
                    int ratioWidth = (int)((float)this.mParams.height * Window.this.touchInfo.ratio);
                    int ratioHeight = (int)((float)this.mParams.width / Window.this.touchInfo.ratio);
                    if (ratioHeight >= this.mParams.minHeight && ratioHeight <= this.mParams.maxHeight) {
                        this.mParams.height = ratioHeight;
                    } else {
                        this.mParams.width = ratioWidth;
                    }
                }
                if (!skip) {
                    this.setPosition((int)((float)this.mParams.x + (float)lastWidth * this.anchorX), (int)((float)this.mParams.y + (float)lastHeight * this.anchorY));
                }
            }
            return this;
        }

        public Editor setPosition(float percentWidth, float percentHeight) {
            return this.setPosition((int)((float)Window.this.displayWidth * percentWidth), (int)((float)Window.this.displayHeight * percentHeight));
        }

        public Editor setPosition(int x, int y) {
            return this.setPosition(x, y, false);
        }

        private Editor setPosition(int x, int y, boolean skip) {
            if (this.mParams != null) {
                if (this.anchorX < 0.0f || this.anchorX > 1.0f || this.anchorY < 0.0f || this.anchorY > 1.0f) {
                    throw new IllegalStateException("Anchor point must be between 0 and 1, inclusive.");
                }
                if (x != Integer.MIN_VALUE) {
                    this.mParams.x = (int)((float)x - (float)this.mParams.width * this.anchorX);
                }
                if (y != Integer.MIN_VALUE) {
                    this.mParams.y = (int)((float)y - (float)this.mParams.height * this.anchorY);
                }
                if (Utils.isSet(Window.this.flags, StandOutFlags.FLAG_WINDOW_EDGE_LIMITS_ENABLE)) {
                    if (this.mParams.gravity != 51) {
                        throw new IllegalStateException("The window " + Window.this.id + " gravity must be TOP|LEFT if FLAG_WINDOW_EDGE_LIMITS_ENABLE or FLAG_WINDOW_EDGE_TILE_ENABLE is set.");
                    }
                    this.mParams.x = Math.min(Math.max(this.mParams.x, 0), Window.this.displayWidth - this.mParams.width);
                    this.mParams.y = Math.min(Math.max(this.mParams.y, 0), Window.this.displayHeight - this.mParams.height);
                }
            }
            return this;
        }

        public void commit() {
            if (this.mParams != null) {
                Window.this.mContext.updateViewLayout(Window.this.id, this.mParams);
                this.mParams = null;
            }
        }
    }

    public static class WindowDataKeys {
        public static final String IS_MAXIMIZED = "isMaximized";
        public static final String WIDTH_BEFORE_MAXIMIZE = "widthBeforeMaximize";
        public static final String HEIGHT_BEFORE_MAXIMIZE = "heightBeforeMaximize";
        public static final String X_BEFORE_MAXIMIZE = "xBeforeMaximize";
        public static final String Y_BEFORE_MAXIMIZE = "yBeforeMaximize";
    }
}

