/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logview.logcatviewer.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.tcshare.logcatviewer.service.ILogcatViewerService;
import org.tcshare.logview.logcatviewer.utils.Constants;

public class LogcatViewerService
extends Service {
    private static final String LOG_TAG = "LogcatViewerService";
    private static Handler mHandler;
    private String mLogcatSource = "main";
    private String mRecordingFilename;
    private Vector<String> mRecordingData;
    private int mRecordedLogEntriesCount;
    private volatile boolean mShouldLogcatRunnableBeKilled = false;
    private volatile boolean mIsLogcatRunnableRunning = false;
    private boolean mIsRecording = false;
    private boolean mIsPaused = false;
    private String mFilterText;
    private static final int LOG_SAVING_INTERVAL = 5000;
    public static final int MSG_LOGCAT_RUN_FAILURE = 1;
    public static final int MSG_LOGCAT_READ_FAILURE = 2;
    public static final int MSG_NEW_LOG_ENTRY = 3;
    private Runnable mLogcatRunnable = new Runnable(){

        @Override
        public void run() {
            LogcatViewerService.this.mIsLogcatRunnableRunning = true;
            LogcatViewerService.this.runLogcatSubscriber();
            LogcatViewerService.this.mIsLogcatRunnableRunning = false;
        }
    };
    private Runnable mRecordLogEntryRunnable = new Runnable(){

        @Override
        public void run() {
            LogcatViewerService.this.recordLogData();
            mHandler.postDelayed(LogcatViewerService.this.mRecordLogEntryRunnable, 5000L);
        }
    };
    private final ILogcatViewerService.Stub mBinder = new ILogcatViewerService.Stub(){

        @Override
        public void changeLogcatSource(String logcatSource) {
            LogcatViewerService.this.mLogcatSource = logcatSource;
            this.restart();
        }

        @Override
        public void restart() {
            LogcatViewerService.this.requestToKillLogcatRunnableThread();
            while (LogcatViewerService.this.mIsLogcatRunnableRunning) {
                Log.d((String)LogcatViewerService.LOG_TAG, (String)"restart:Waiting to kill LogcatRunnable thread");
            }
            LogcatViewerService.this.mShouldLogcatRunnableBeKilled = false;
            Thread thr = new Thread(LogcatViewerService.this.mLogcatRunnable);
            thr.start();
        }

        @Override
        public void stop() {
            Log.d((String)LogcatViewerService.LOG_TAG, (String)"stop:request to stop LogcatViewerService service is made.");
            LogcatViewerService.this.requestToKillLogcatRunnableThread();
            while (LogcatViewerService.this.mIsLogcatRunnableRunning) {
                Log.d((String)LogcatViewerService.LOG_TAG, (String)"stop:Waiting to kill LogcatRunnable thread");
            }
            LogcatViewerService.this.stopSelf();
        }

        @Override
        public void startRecording(String recordingFilename, String filterText) {
            LogcatViewerService.this.mRecordingData = new Vector();
            LogcatViewerService.this.mIsRecording = true;
            LogcatViewerService.this.mRecordingFilename = recordingFilename;
            LogcatViewerService.this.mFilterText = filterText;
            mHandler.postDelayed(LogcatViewerService.this.mRecordLogEntryRunnable, 5000L);
        }

        @Override
        public void stopRecording() {
            mHandler.removeCallbacks(LogcatViewerService.this.mRecordLogEntryRunnable);
            LogcatViewerService.this.mIsRecording = false;
            LogcatViewerService.this.recordLogData();
            LogcatViewerService.this.mRecordingData.removeAllElements();
            LogcatViewerService.this.mRecordingFilename = null;
        }

        @Override
        public boolean isRecording() {
            return LogcatViewerService.this.mIsRecording;
        }

        @Override
        public void pause() {
            LogcatViewerService.this.mIsPaused = true;
        }

        @Override
        public void resume() {
            LogcatViewerService.this.mIsPaused = false;
        }
    };

    public void onCreate() {
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int i = super.onStartCommand(intent, flags, startId);
        Log.i((String)LOG_TAG, (String)"onStartCommand:service is started.");
        return i;
    }

    public boolean onUnbind(Intent intent) {
        this.requestToKillLogcatRunnableThread();
        while (this.mIsLogcatRunnableRunning) {
            Log.d((String)LOG_TAG, (String)"onUnbind:Waiting to kill LogcatRunnable thread");
        }
        this.stopSelf();
        return false;
    }

    public static void setHandler(Handler handler) {
        mHandler = handler;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    private void runLogcatSubscriber() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("/system/bin/logcat -b " + this.mLogcatSource);
        }
        catch (IOException e) {
            this.sendMessage(1);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (!this.shouldLogcatRunnableBeKilled()) {
                if (this.mIsPaused) continue;
                String logEntry = reader.readLine();
                this.sendLogEntry(logEntry);
                if (!this.mIsRecording || !TextUtils.isEmpty((CharSequence)this.mFilterText) && (TextUtils.isEmpty((CharSequence)this.mFilterText) || !logEntry.toLowerCase().contains(this.mFilterText.toLowerCase()))) continue;
                this.mRecordingData.add(logEntry);
            }
            Log.d((String)LOG_TAG, (String)"Preparing to terminate LogcatRunnable thread");
            if (this.mIsRecording) {
                this.recordLogData();
                mHandler.removeCallbacks(this.mRecordLogEntryRunnable);
                this.mIsRecording = false;
                this.mRecordingData.removeAllElements();
                this.mRecordingFilename = null;
            }
            reader.close();
            process.destroy();
        }
        catch (IOException e) {
            this.sendMessage(2);
        }
        Log.d((String)LOG_TAG, (String)"Terminating LogcatRunnable thread");
    }

    private synchronized void requestToKillLogcatRunnableThread() {
        this.mShouldLogcatRunnableBeKilled = true;
    }

    private synchronized boolean shouldLogcatRunnableBeKilled() {
        return this.mShouldLogcatRunnableBeKilled;
    }

    private void sendMessage(int msg) {
        Message.obtain((Handler)mHandler, (int)msg, (Object)"error").sendToTarget();
    }

    private void sendLogEntry(String logEntry) {
        Message.obtain((Handler)mHandler, (int)3, (Object)logEntry).sendToTarget();
    }

    private void recordLogData() {
        try {
            int size = this.mRecordingData.size();
            if (size == 0) {
                return;
            }
            Vector<String> recordingData = new Vector<String>(this.mRecordingData);
            File logDir = Constants.getRecordDir((Context)this);
            logDir.mkdirs();
            File logFile = new File(logDir, this.mRecordingFilename);
            FileWriter logFileWriter = new FileWriter(logFile, true);
            for (int i = 0; i < size; ++i) {
                logFileWriter.append(recordingData.elementAt(i) + "\n");
                this.mRecordingData.removeElementAt(0);
            }
            recordingData.removeAllElements();
            logFileWriter.close();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("recordLogData:Error writing the log to file. Exception: " + e.toString()));
        }
    }
}

