/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logutils;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.orhanobut.logger.LogStrategy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class MyDiskLogStrategy
implements LogStrategy {
    private final Handler handler;

    public MyDiskLogStrategy(Handler handler) {
        this.handler = handler;
    }

    public void log(int level, String tag, String message) {
        this.handler.sendMessage(this.handler.obtainMessage(level, (Object)message));
    }

    static class WriteHandler
    extends Handler {
        private final String folder;
        private final int maxFileSize;

        WriteHandler(Looper looper, String folder, int maxFileSize) {
            super(looper);
            this.folder = folder;
            this.maxFileSize = maxFileSize;
        }

        public void handleMessage(Message msg) {
            block4: {
                String content = (String)msg.obj;
                FileWriter fileWriter = null;
                File logFile = this.getLogFile(this.folder, "logs");
                try {
                    fileWriter = new FileWriter(logFile, true);
                    this.writeLog(fileWriter, content);
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    if (fileWriter == null) break block4;
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        private void writeLog(FileWriter fileWriter, String content) throws IOException {
            fileWriter.append(content).append("\r\n");
        }

        private File getLogFile(String folderName, String fileName) {
            File folder = new File(folderName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            int newFileCount = 0;
            File existingFile = null;
            File newFile = new File(folder, String.format("%s_%s.txt", fileName, newFileCount));
            while (newFile.exists()) {
                existingFile = newFile;
                newFile = new File(folder, String.format("%s_%s.txt", fileName, ++newFileCount));
            }
            if (existingFile != null) {
                if (existingFile.length() >= (long)this.maxFileSize) {
                    return newFile;
                }
                return existingFile;
            }
            return newFile;
        }
    }
}

