/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fragment;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.util.HashMap;
import java.util.Map;
import org.tcshare.androidutils.R;

public class WebViewFragment
extends Fragment
implements View.OnClickListener {
    private static final String TAG = WebViewFragment.class.getSimpleName();
    protected WebView mWebView;
    protected String url;
    protected String content;
    private View loading;
    private View retry;
    protected Map<String, Object> jsScripts = new HashMap<String, Object>();

    public static WebViewFragment newInstance(String url, String content) {
        WebViewFragment frag = new WebViewFragment();
        Bundle args = new Bundle();
        args.putString("url", url);
        args.putString("content", content);
        frag.setArguments(args);
        return frag;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.url = bundle.getString("url");
            this.content = bundle.getString("content");
        }
    }

    @SuppressLint(value={"JavascriptInterface"})
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_webview, container, false);
        this.mWebView = (WebView)view.findViewById(R.id.webView);
        this.loading = view.findViewById(R.id.loading);
        this.retry = view.findViewById(R.id.retry);
        this.retry.setOnClickListener((View.OnClickListener)this);
        this.initSettings(this.mWebView);
        this.mWebView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.mWebView.setHorizontalScrollBarEnabled(true);
        this.mWebView.setVerticalScrollBarEnabled(true);
        this.mWebView.setDownloadListener((DownloadListener)new MyWebViewDownLoadListener());
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                Log.e((String)"tmp", (String)("errorCode:" + errorCode + "-" + description + "-" + failingUrl));
                WebViewFragment.this.retry.setVisibility(0);
                WebViewFragment.this.mWebView.loadData("", "text/html; charset=UTF-8", null);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.d((String)TAG, (String)("error:" + error));
                WebViewFragment.this.retry.setVisibility(0);
                WebViewFragment.this.mWebView.loadData("", "text/html; charset=UTF-8", null);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                WebViewFragment.this.mWebView.loadUrl(url);
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        WebChromeClient wvcc = new WebChromeClient(){

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
            }

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress >= 100) {
                    WebViewFragment.this.mWebView.getSettings().setBlockNetworkImage(false);
                    WebViewFragment.this.loading.setVisibility(8);
                }
            }
        };
        this.mWebView.setWebChromeClient(wvcc);
        for (Map.Entry<String, Object> entry : this.jsScripts.entrySet()) {
            this.mWebView.addJavascriptInterface(entry.getValue(), entry.getKey());
        }
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.mWebView.getSettings().setBlockNetworkImage(true);
            this.mWebView.loadUrl(this.url);
        } else if (!TextUtils.isEmpty((CharSequence)this.content)) {
            this.mWebView.loadData(this.content, "text/html; charset=UTF-8", null);
        }
        return view;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initSettings(WebView mWebView) {
        WebSettings webSettings = mWebView.getSettings();
        webSettings.setCacheMode(-1);
        webSettings.setDomStorageEnabled(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setUserAgentString("Mozilla/5.0 (Linux; Android 5.1.1; Nexus 6 Build/LYZ28E) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.20 Mobile Safari/537.36");
        webSettings.setGeolocationEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
    }

    public void addJavascriptInterface(Object obj, String name) {
        this.jsScripts.put(name, obj);
    }

    public void onPause() {
        super.onPause();
        this.mWebView.onPause();
    }

    public void onResume() {
        this.mWebView.onResume();
        super.onResume();
    }

    public void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.destroy();
            this.mWebView = null;
        }
        super.onDestroy();
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public void clearSession() {
        CookieManager.getInstance().removeSessionCookie();
    }

    public void clearCacheAndHistory() {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.clearCache(true);
        this.mWebView.clearHistory();
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.retry) {
            this.reLoad(this.url, this.content);
        }
    }

    public void reLoad(String url, String content) {
        this.url = url;
        this.content = content;
        this.loading.setVisibility(0);
        this.retry.setVisibility(8);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.mWebView.getSettings().setBlockNetworkImage(true);
            this.mWebView.loadUrl(url);
        } else if (!TextUtils.isEmpty((CharSequence)content)) {
            this.mWebView.loadData(content, "text/html; charset=UTF-8", null);
        }
    }

    private class MyWebViewDownLoadListener
    implements DownloadListener {
        private MyWebViewDownLoadListener() {
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            WebViewFragment.this.startActivity(intent);
        }
    }
}

