/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import org.tcshare.androidutils.R;
import org.tcshare.fileselectorlib.FileSelectorTheme;
import org.tcshare.fileselectorlib.Objects.BasicParams;

public class NavigationAdapter
extends RecyclerView.Adapter {
    private Context context;
    private ArrayList<String> RelativePathList;
    private int naviBarTextColor;
    private int naviBarTextSize;
    private int naviBarArrowIcon;
    private OnRecycleItemClickListener recycleItemClickListener;

    public NavigationAdapter(Context context, ArrayList<String> relativePathList) {
        this.context = context;
        this.RelativePathList = relativePathList;
        FileSelectorTheme theme = BasicParams.getInstance().getTheme();
        this.naviBarTextColor = theme.getNaviBarTextColor();
        this.naviBarTextSize = theme.getNaviBarTextSize();
        this.naviBarArrowIcon = theme.getNaviBarArrowIcon();
    }

    public void UpdatePathList(ArrayList<String> relativePathList) {
        this.RelativePathList = relativePathList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View item_view = View.inflate((Context)this.context, (int)R.layout.navigation_item, null);
        return new ViewHolder(item_view);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        ViewHolder viewHolder = (ViewHolder)holder;
        viewHolder.path.setText((CharSequence)this.RelativePathList.get(position));
        viewHolder.path.setTextColor(this.naviBarTextColor);
        viewHolder.path.setTextSize((float)this.naviBarTextSize);
        viewHolder.setPosition(position);
        if (position == this.getItemCount() - 1) {
            viewHolder.next.setVisibility(4);
        } else {
            viewHolder.next.setVisibility(0);
        }
        viewHolder.next.setImageResource(this.naviBarArrowIcon);
    }

    public int getItemCount() {
        return this.RelativePathList.size();
    }

    public void setRecycleItemClickListener(OnRecycleItemClickListener recycleItemClickListener) {
        this.recycleItemClickListener = recycleItemClickListener;
    }

    public static interface OnRecycleItemClickListener {
        public void onClick(View var1, int var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView path;
        private ImageView next;
        private int position;

        public ViewHolder(View itemView) {
            super(itemView);
            this.path = (TextView)itemView.findViewById(R.id.navi_path);
            this.next = (ImageView)itemView.findViewById(R.id.next);
            itemView.setOnClickListener(v -> NavigationAdapter.this.recycleItemClickListener.onClick(itemView, this.position));
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }
}

