/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tcshare.androidutils.R;
import org.tcshare.fileselectorlib.FileSelectorTheme;
import org.tcshare.fileselectorlib.Objects.BasicParams;
import org.tcshare.fileselectorlib.Objects.FileInfo;
import org.tcshare.fileselectorlib.Utils.FileUtil;

public class FileListAdapter
extends BaseAdapter {
    private ArrayList<FileInfo> FileList;
    private HashMap<Integer, Boolean> SelectionMap = new HashMap();
    private Context mContext;
    private LayoutInflater inflater;
    private boolean isSelect = false;
    private int themeColor;
    private int fileNameColor;
    private int fileNameSize;
    private int fileInfoColor;
    private int fileInfoSize;
    private int checkboxDrawable;
    private boolean isRepaintCheckbox;

    public FileListAdapter(ArrayList<FileInfo> fileList, Context mContext) {
        this.FileList = fileList;
        this.mContext = mContext;
        this.inflater = LayoutInflater.from((Context)mContext);
        this.clearSelections();
        FileSelectorTheme theme = BasicParams.getInstance().getTheme();
        this.themeColor = theme.getThemeColor();
        this.fileNameColor = theme.getFileNameColor();
        this.fileNameSize = theme.getFileNameSize();
        this.fileInfoColor = theme.getFileInfoColor();
        this.fileInfoSize = theme.getFileInfoSize();
        this.checkboxDrawable = theme.getCheckboxDrawable();
        this.isRepaintCheckbox = theme.isReplaceCheckboxBackground();
    }

    public void clearSelections() {
        for (int i = 0; i < this.FileList.size(); ++i) {
            this.SelectionMap.put(i, false);
        }
    }

    public void updateFileList(ArrayList<FileInfo> fileList) {
        this.FileList = fileList;
        this.notifyDataSetChanged();
    }

    public void setSelect(boolean select) {
        this.isSelect = select;
        this.notifyDataSetChanged();
    }

    public void notifyFileSelected(int position, boolean isSelected) {
        this.SelectionMap.put(position, isSelected);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.FileList.size();
    }

    public Object getItem(int position) {
        return this.FileList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            convertView = this.inflater.inflate(R.layout.file_list_item, null);
            viewHolder.ivFileIcon = (ImageView)convertView.findViewById(R.id.FileIcon);
            viewHolder.tvFileCount = (TextView)convertView.findViewById(R.id.FileCount);
            viewHolder.tvFileName = (TextView)convertView.findViewById(R.id.FileName);
            viewHolder.tvFileDate = (TextView)convertView.findViewById(R.id.FileDate);
            viewHolder.ckSelector = (CheckBox)convertView.findViewById(R.id.select_box);
            viewHolder.llInfo = (LinearLayout)convertView.findViewById(R.id.FileInfo);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        viewHolder.tvFileName.setText((CharSequence)this.FileList.get(position).getFileName());
        viewHolder.tvFileName.setTextColor(this.fileNameColor);
        viewHolder.tvFileName.setTextSize((float)this.fileNameSize);
        viewHolder.tvFileCount.setText((CharSequence)this.FileList.get(position).getFileCount());
        viewHolder.tvFileCount.setTextColor(this.fileInfoColor);
        viewHolder.tvFileCount.setTextSize((float)this.fileInfoSize);
        viewHolder.tvFileDate.setText((CharSequence)this.FileList.get(position).getFileLastUpdateTime());
        viewHolder.tvFileDate.setTextColor(this.fileInfoColor);
        viewHolder.tvFileDate.setTextSize((float)this.fileInfoSize);
        this.setIcon(position, viewHolder);
        if (this.FileList.get(position).getFileType() == FileInfo.FileType.Parent) {
            this.ViewShow((ViewGroup)viewHolder.llInfo, 4, 0);
            viewHolder.tvFileName.setGravity(16);
        } else {
            this.ViewShow((ViewGroup)viewHolder.llInfo, 0, 25);
        }
        if (this.isSelect && this.FileList.get(position).getFileType() != FileInfo.FileType.Parent) {
            viewHolder.ckSelector.setVisibility(0);
        } else {
            viewHolder.ckSelector.setVisibility(4);
        }
        if (this.isRepaintCheckbox) {
            viewHolder.ckSelector.setButtonDrawable(this.checkboxDrawable);
        }
        if (this.SelectionMap != null && this.isSelect && viewHolder.ckSelector != null) {
            viewHolder.ckSelector.setChecked(!Objects.isNull(this.SelectionMap.get(position)) && this.SelectionMap.get(position) != false);
        }
        return convertView;
    }

    private void setIcon(int position, ViewHolder viewHolder) {
        FileInfo currentFile = this.FileList.get(position);
        if (BasicParams.getInstance().getCustomIcon().size() > 0) {
            Map<String, Bitmap> customIcons = BasicParams.getInstance().getCustomIcon();
            for (Map.Entry<String, Bitmap> entry : customIcons.entrySet()) {
                if (!FileUtil.fileFilter(currentFile.getFilePath(), entry.getKey())) continue;
                viewHolder.ivFileIcon.setImageBitmap(entry.getValue());
                return;
            }
        }
        switch (currentFile.getFileType()) {
            case Folder: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.file_folder);
                break;
            }
            case Parent: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.fs_back_to_parent);
                break;
            }
            case Image: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.file_image);
                break;
            }
            case Audio: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.file_audio);
                break;
            }
            case Video: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.file_video);
                break;
            }
            case Text: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.file_text);
                break;
            }
            case Unknown: {
                viewHolder.ivFileIcon.setImageResource(R.mipmap.file_unknown);
                break;
            }
        }
    }

    private void ViewShow(ViewGroup view, int visible, int dp) {
        view.setVisibility(visible);
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params.height = (int)((float)dp * this.mContext.getResources().getDisplayMetrics().density);
        view.setLayoutParams(params);
    }

    public static class ViewHolder {
        public LinearLayout llInfo;
        public ImageView ivFileIcon;
        public TextView tvFileName;
        public TextView tvFileCount;
        public TextView tvFileDate;
        public CheckBox ckSelector;
    }
}

